/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sdk.utils;

import com.ebaiyihui.sdk.exception.OauthException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static String createJWT(String clientId, String clientSecret, String randomStr, String sign, String signType, String tokenSecret, Integer ttlSecond) {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().setHeaderParam("jwt", (Object)"HS512").claim("clientId", (Object)clientId).claim("clientSecret", (Object)clientSecret).claim("randomStr", (Object)randomStr).claim("sign", (Object)sign).claim("signType", (Object)signType).signWith(SignatureAlgorithm.HS512, tokenSecret);
        if (ttlSecond >= 0) {
            long expMillis = nowMillis + (long)(ttlSecond * 1000);
            Date exp = new Date(expMillis);
            builder.setExpiration(exp).setNotBefore(now);
        }
        return "Bearer " + builder.compact();
    }

    public static Claims parseJWT(String jsonWebToken, String secret) throws OauthException {
        Claims claims = null;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(jsonWebToken.replace("Bearer ", "")).getBody();
        }
        catch (Exception e) {
            log.error("invalid access token\u2014\u2014>{}" + e.getMessage());
            throw new OauthException("invalid access token");
        }
        return claims;
    }
}

