/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.patient.client;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.patient.client.error.PatientInfoError;
import com.ebaiyihui.patient.common.dto.PatientInfoDTO;
import com.ebaiyihui.patient.common.vo.PatientConsulVO;
import com.ebaiyihui.patient.common.vo.PatientInfoVO;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="service-patient-server", fallbackFactory=PatientInfoError.class)
public interface PatientInfoClient {
    @PostMapping(value={"/api/v1/patient_patientinfo/deletebyid_userid"})
    public ResultInfo<Integer> deletePatientInfoById(@RequestParam(value="id") Long var1, @RequestParam(value="userId") Long var2);

    @PostMapping(value={"/api/v1/patient_patientinfo/savepatientinfo"})
    public ResultInfo<Integer> savePatientInfo(@RequestBody PatientInfoVO var1);

    @GetMapping(value={"/api/v1/patient_patientinfo/getbyid"})
    public ResultInfo<PatientInfoDTO> getPatientInfoById(@RequestParam(value="id") Long var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/updatebyidselective"})
    public ResultInfo<Integer> updatePatientInfoByIdSelective(@RequestBody PatientInfoVO var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/updatebyid"})
    public ResultInfo<Integer> updatePatientInfoById(@RequestBody PatientInfoVO var1);

    @GetMapping(value={"/api/v1/patient_patientinfo/getallvalidpatientinfo"})
    public ResultInfo<List<PatientInfoDTO>> getAllValidPatientInfo();

    @GetMapping(value={"/api/v1/patient_patientinfo/getallvalidbyuseridandhospitalid"})
    public ResultInfo getAllValidByUserIdAndHospitalId(@RequestParam(value="userId") Long var1, @RequestParam(value="hospitalId") Long var2);

    @GetMapping(value={"/api/v1/patient_patientinfo/getdefaultbyuseridandhospitalid"})
    public ResultInfo<PatientInfoDTO> getDefaultPatientInfoByUserIdAndHospitalId(@RequestParam(value="userId") Long var1, @RequestParam(value="hospitalId") Long var2);

    @GetMapping(value={"/api/v1/patient_patientinfo/getlastbindbyuseridandhospitalid"})
    public ResultInfo<PatientInfoDTO> getLastBindPatientInfoByUserIdAndHospitalId(@RequestParam(value="userId") Long var1, @RequestParam(value="hospitalId") Long var2);

    @GetMapping(value={"/api/v1/patient_patientinfo/getpagebyhospitalidandmobilenumberandnickname"})
    public ResultInfo<PageResult> getPageByHospitalIdAndMobileNumberOrNickName(@RequestParam(value="createTimeSort") String var1, @RequestParam(value="hospitalId") Long var2, @RequestParam(value="mobileNumebrOrNickName", required=false) String var3, @RequestParam(value="pageNum") int var4, @RequestParam(value="pageSize") int var5);

    @GetMapping(value={"/api/v1/patient_patientinfo/getcurrentdatenewpatientnumbyhospitalid"})
    public ResultInfo<Long> getNewPatientNum(@RequestParam(value="hospitalId") Long var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/save/consultation"})
    public ResultInfo<PatientConsulVO> saveCconsultation(@RequestBody PatientConsulVO var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/get/patient_list"})
    public ResultInfo<Map<Long, Object>> getPatientMap(@RequestBody Long[] var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/patient_ishave"})
    public ResultInfo<PatientInfoDTO> getPatientInfoIsHave(@RequestBody PatientConsulVO var1);

    @GetMapping(value={"/api/v1/patient_patientinfo/get/patientinfo/byviewid"})
    public ResultInfo<PatientInfoDTO> getPatientinfoByViewId(@RequestParam(value="viewId") String var1);

    @GetMapping(value={"/api/v1/patient_patientinfo/get/patient_info"})
    public ResultInfo<List<PatientInfoDTO>> getPatientInfoByNameOrPhoneNum(@RequestParam(value="nameOrPhonNum") String var1);

    @PostMapping(value={"/api/v1/patient_patientinfo/get/patient_info/bylistid"})
    public ResultInfo<List<PatientInfoDTO>> getPatientInfoList(@RequestBody Long[] var1);
}

