/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.alipay.request.AliPayownLoadRequest;
import com.ebaiyihui.wisdommedical.model.AliPaymedicareRefundRequest;
import com.ebaiyihui.wisdommedical.model.ChannelBill;
import com.ebaiyihui.wisdommedical.pojo.YB.AliPayRefuntResponse;
import com.ebaiyihui.wisdommedical.pojo.YB.OutpatientYbPaymentCallback;
import com.ebaiyihui.wisdommedical.pojo.YB.OutpatientYbPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.YB.ResultResponse;
import com.ebaiyihui.wisdommedical.service.AlipayService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u963f\u91cc\u533b\u4fdd\u63a5\u53e3"})
@RequestMapping(value={"/api/v1/alipay"})
public class AlipayController {
    private static final Logger log = LoggerFactory.getLogger(AlipayController.class);
    @Autowired
    AlipayService alipayService;
    @Autowired
    PayCallBackService payCallBackService;

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u533b\u4fdd\u652f\u4ed8\u63a5\u53e3", notes="\u95e8\u8bca\u7f34\u8d39\u533b\u4fdd\u652f\u4ed8\u63a5\u53e3")
    @PostMapping(value={"/alipayTradeAppPay"})
    public BaseResponse<String> alipayTradeAppPay(@RequestBody OutpatientYbPaymentReqVO outpatientPaymentReqVO) {
        try {
            return this.alipayService.alipayTradeAppPay(outpatientPaymentReqVO);
        }
        catch (Exception e) {
            log.error("alipayTradeAppPay\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @PostMapping(value={"/outpatientYbPaymentCallback"})
    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u533b\u4fdd\u652f\u4ed8\u56de\u8c03")
    public String outpatientYbPaymentCallback(OutpatientYbPaymentCallback outpatientYbPaymentCallback) {
        try {
            log.info("\u95e8\u8bca\u7f34\u8d39\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\u63a5\u6536\u5230\u53c2\u6570\u4e3a->{}", (Object)JSON.toJSONString((Object)outpatientYbPaymentCallback));
            if (!"TRADE_SUCCESS".equals(outpatientYbPaymentCallback.getTrade_status())) {
                log.error("\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\u72b6\u6001\u4e0d\u6b63\u5e38");
                return "Success";
            }
            this.payCallBackService.outpatientYbPaymentCallback(outpatientYbPaymentCallback);
            return "Success";
        }
        catch (Exception e) {
            log.error("\u533b\u4fdd\u56de\u8c03\u652f\u4ed8\u51fa\u73b0\u5f02\u5e38->{}", (Throwable)e);
            return "Success";
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355", notes="\u83b7\u53d6\u652f\u4ed8\u5b9d\u8d26\u5355")
    @PostMapping(value={"/getAliPayBill"})
    public BaseResponse<List<ChannelBill>> getAliPayBill(@RequestBody AliPayownLoadRequest aliPayownLoadRequest) {
        return this.alipayService.downLoadBill(aliPayownLoadRequest);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u533b\u4fdd\u9000\u6b3e\u63a5\u53e3", notes="\u652f\u4ed8\u5b9d\u533b\u4fdd\u9000\u6b3e\u63a5\u53e3")
    @PostMapping(value={"/aliPayMedicareRefund"})
    public ResultResponse<AliPayRefuntResponse> aliPayMedicareRefund(@RequestBody AliPaymedicareRefundRequest aliPaymedicareRefundRequest) {
        try {
            String refund = this.alipayService.medicareRefund(aliPaymedicareRefundRequest);
            ResultResponse aliPayRefunt = (ResultResponse)JSON.parseObject((String)refund, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return aliPayRefunt;
        }
        catch (Exception e) {
            return ResultResponse.error((String)"Error");
        }
    }
}

