/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79d1\u5ba4api"})
@RequestMapping(value={"api/v1/dept"})
public class DepartmentController {
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Autowired
    private DepartmentService departmentService;

    @ApiOperation(value="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4\u53f7\u7c7b", notes="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4\u53f7\u7c7b")
    @GetMapping(value={"/getDeptList"})
    public BaseResponse<List<GetDeptListVoRes>> getDeptList(String hl, String date) {
        try {
            if (null == hl) {
                List deptList = this.departmentService.getDeptList();
                return BaseResponse.success((Object)deptList);
            }
            List deptList = this.departmentService.getDeptList(hl, date);
            return BaseResponse.success((Object)deptList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4\u51fa\u9519\u4fe1\u606f\u4e3a{}", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u6392\u73ed\u79d1\u5ba4\uff08\u5b9e\u65f6\u83b7\u53d6\uff09", notes="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4(\u5b9e\u65f6\u83b7\u53d6)")
    @GetMapping(value={"/getHospDeptList"})
    public BaseResponse<List<HospitalDeptVo>> getHospDeptList(String branchCode, String date) {
        try {
            List deptList = this.departmentService.getHospDeptList(branchCode, date);
            return BaseResponse.success((Object)deptList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4\u51fa\u9519\u4fe1\u606f\u4e3a{}", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
    }
}

