/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.SyncHisScheduleException;
import com.ebaiyihui.wisdommedical.service.SyncHisOrderService;
import com.ebaiyihui.wisdommedical.service.SynchroHisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u540c\u6b65hisApi"})
@RequestMapping(value={"/synHis"})
public class SyncScheduleController {
    private static final Logger log = LoggerFactory.getLogger(SyncScheduleController.class);
    @Autowired
    private SynchroHisService synchroHisService;
    @Autowired
    private SyncHisOrderService syncHisOrderService;
    private static final String FAILURE_REASON = "\u540c\u6b65his\u6392\u73ed\u6570\u636e\u5931\u8d25!";
    private static final String SUCCESS_REASONS = "\u540c\u6b65his\u6392\u73ed\u6570\u636e\u5b8c\u6210";

    @DisableAuthConfig
    @ApiOperation(value="\u540c\u6b65his\u6392\u73ed\u4fe1\u606f", notes="\u540c\u6b65his\u6392\u73ed\u4fe1\u606f\uff0c\u6392\u73ed\uff0c\u79d1\u5ba4\uff0c\u533b\u751f")
    @RequestMapping(value={"/getSyncSchedule"}, method={RequestMethod.POST})
    public BaseResponse getSyncSchedule(@RequestParam(value="hospitalCode") String hospitalCode) throws SyncHisScheduleException {
        try {
            this.synchroHisService.syncDocSchedule(hospitalCode);
        }
        catch (SyncHisScheduleException e) {
            throw new SyncHisScheduleException(FAILURE_REASON);
        }
        return BaseResponse.success((Object)SUCCESS_REASONS);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6700\u65b0\u540c\u6b65his\u6392\u73ed\u4fe1\u606f", notes="\u6700\u65b0\u540c\u6b65his\u6392\u73ed\u4fe1\u606f")
    @RequestMapping(value={"/synSchedule"}, method={RequestMethod.POST})
    public BaseResponse synSchedule(@RequestParam(value="hospitalCode") String hospitalCode) throws SyncHisScheduleException {
        try {
            this.synchroHisService.syncSchedule(hospitalCode);
        }
        catch (SyncHisScheduleException e) {
            throw new SyncHisScheduleException(FAILURE_REASON);
        }
        return BaseResponse.success((Object)SUCCESS_REASONS);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6700\u65b0\u540c\u6b65his\u79d1\u5ba4", notes="\u6700\u65b0\u540c\u6b65his\u79d1\u5ba4")
    @RequestMapping(value={"/synDeptSchedule"}, method={RequestMethod.GET})
    public BaseResponse synDeptSchedule(@RequestParam(value="hospitalCode") String hospitalCode) throws SyncHisScheduleException {
        try {
            this.synchroHisService.syncDept(hospitalCode);
        }
        catch (SyncHisScheduleException e) {
            throw new SyncHisScheduleException(FAILURE_REASON);
        }
        return BaseResponse.success((Object)SUCCESS_REASONS);
    }

    @ApiOperation(value="\u540c\u6b65his\u6392\u73ed\u4fe1\u606f  \u5904\u7406\u9057\u6f0f\u7684\u6392\u73ed", notes="\u540c\u6b65his\u6392\u73ed\u4fe1\u606f\uff0c\u6392\u73ed\uff0c\u79d1\u5ba4\uff0c\u533b\u751f")
    @RequestMapping(value={"/getSyncMissSchedule"}, method={RequestMethod.POST})
    public BaseResponse getSyncMissSchedule(@RequestParam(value="hospitalCode") String hospitalCode, @RequestParam(value="deptCode") String deptCode, @RequestParam(value="deptName") String deptName) throws SyncHisScheduleException {
        try {
            this.synchroHisService.syncMissDocSchedule(hospitalCode, deptCode, deptName);
        }
        catch (SyncHisScheduleException e) {
            throw new SyncHisScheduleException(FAILURE_REASON);
        }
        return BaseResponse.success((Object)SUCCESS_REASONS);
    }

    @ApiOperation(value="\u540c\u6b65his\u8ba2\u5355\u4fe1\u606f \u5df2\u5220\u9664", notes="\u540c\u6b65his\u6302\u53f7\u8bb0\u5f55\u8ba2\u5355 \u5df2\u5220\u9664")
    @RequestMapping(value={"/getSyncAppointOrder"}, method={RequestMethod.POST})
    public BaseResponse getSyncAppointOrder(@RequestParam(value="hospitalCode") String hospitalCode, @RequestParam(value="cardNo") String cardNo) {
        this.syncHisOrderService.syncHisOrder(hospitalCode, cardNo);
        return BaseResponse.success();
    }
}

