/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.api.ScheduleClient;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.appoint.GetRegDoctInfoVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDoctInfoVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.interceptor.ImporyDoctorVerifyHandler;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DocAppendInfoQrcodeDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.ScheduleDoctorDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.DocAppendInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetDocListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.OSSClientUtil;
import com.ebaiyihui.wisdommedical.util.RemoveBlankUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.ebaiyihui.wisdommedical.util.UnZipUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.JedisCluster;

@Service
public class DoctorServiceImpl
implements DoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ProPropertiesConstant proPropertiesConstant;
    @Autowired
    private ImporyDoctorVerifyHandler imporyDoctorVerifyHandler;
    @Autowired
    private ScheduleClient scheduleClient;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;

    public DoctorRecordEntity getDoctorRecordEntity(String doctorId, String hospitalCode) {
        return this.doctorRecordMapper.selectByDoctorIdAndHospitalCode(doctorId, hospitalCode);
    }

    public List<DoctorRecordEntity> getDoctorIdList(List<String> doctorCodes, String organId) {
        return this.doctorRecordMapper.getDoctorIdList(doctorCodes, organId);
    }

    public DoctorRecordEntity getDoctorRecordByDoctorCodeAndHosCode(String doctorCode, String organCode) {
        return this.doctorRecordMapper.getDoctorRecordByDoctorCodeAndHosCode(doctorCode, organCode);
    }

    public void updateDoctorIdByDoctorCode(String doctorId, String doctorCode, String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, doctorCode);
        if (doctorRecordEntity != null) {
            this.doctorRecordMapper.updateDoctorIdByDoctorCode(doctorId, doctorCode, hospitalCode);
        }
    }

    public List<Long> getDoctorCodeListBydoctorIds(String doctorIds) {
        List doctorCodeList = this.doctorRecordMapper.getDoctorCodeList(doctorIds, this.proPropertiesConstant.getOrganCode());
        List<Long> doctorIdList = doctorCodeList.stream().map(doctorRecordEntity -> {
            if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        return doctorIdList;
    }

    public List<ScheduleDoctorVoRes> getScheduleDoctor(ScheduleDoctorVoReq scheduleDoctorVoReq) {
        HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectByHospitalId(scheduleDoctorVoReq.getOrganId());
        if (null == hospitalAreaRecordEntity) {
            return new ArrayList<ScheduleDoctorVoRes>();
        }
        List scheduleDoctorDTOS = this.scheduleRecordMapper.selectByHospitalCodeAndDeptCode(hospitalAreaRecordEntity.getHospitalCode(), scheduleDoctorVoReq.getDeptCode());
        ArrayList<ScheduleDoctorVoRes> scheduleDoctorVoResList = new ArrayList<ScheduleDoctorVoRes>();
        for (ScheduleDoctorDTO scheduleDoctorDTO : scheduleDoctorDTOS) {
            if (!StringUtils.isNotBlank((CharSequence)scheduleDoctorDTO.getDoctorId())) continue;
            ScheduleDoctorVoRes scheduleDoctorVoRes = new ScheduleDoctorVoRes();
            scheduleDoctorVoRes.setDoctorId(Long.valueOf(scheduleDoctorDTO.getDoctorId()));
            scheduleDoctorVoRes.setDoctorCode(scheduleDoctorDTO.getDoctorCode());
            scheduleDoctorVoRes.setDoctorName(scheduleDoctorDTO.getDoctorName());
            scheduleDoctorVoRes.setDeptCode(scheduleDoctorDTO.getDeptCode());
            scheduleDoctorVoRes.setDeptName(scheduleDoctorDTO.getDeptName());
            scheduleDoctorVoResList.add(scheduleDoctorVoRes);
        }
        return scheduleDoctorVoResList;
    }

    public PageResult<DoctorRecordEntity> getDocInfoList(GetDocListReqVo getDocListReqVo) {
        PageHelper.startPage((int)getDocListReqVo.getPageNum(), (int)getDocListReqVo.getPageSize());
        Page page = this.doctorRecordMapper.getDocInfoList(getDocListReqVo.getSearchParam(), getDocListReqVo.getHospAreaCode());
        PageResult result = new PageResult(page.getPageNum(), page.getPageSize());
        result.setTotal((int)page.getTotal());
        result.setTotalPages(page.getPages());
        result.setContent(page.getResult());
        return result;
    }

    public int deleteDoctorRecord(Long id) {
        return this.doctorRecordMapper.deleteByPrimaryKey(id);
    }

    public int updateDoctorRecord(DoctorRecordEntity doctorRecordEntity) {
        return this.doctorRecordMapper.updateByPrimaryKeySelective(doctorRecordEntity);
    }

    public int addDoctorRecord(DoctorRecordEntity doctorRecordEntity) throws Exception {
        DoctorRecordEntity doctorRecord = this.doctorRecordMapper.selectByDocCode(doctorRecordEntity.getDocCode());
        if (doctorRecord != null) {
            throw new DoctorScheduleException("\u533b\u751f\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        return this.doctorRecordMapper.insertSelective(doctorRecordEntity);
    }

    public DoctorRecordEntity getDoctorRecord(Long id) {
        return this.doctorRecordMapper.selectByPrimaryKey(id);
    }

    public BaseResponse<Object> importWestern(MultipartFile excelfile) {
        List uploadDocList = null;
        List failList = null;
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setNeedVerfiy(true);
        importParams.setVerifyHanlder((IExcelVerifyHandler)this.imporyDoctorVerifyHandler);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)excelfile.getInputStream(), UploadDocExcelReqVo.class, (ImportParams)importParams);
            uploadDocList = result.getList();
            failList = result.getFailList();
        }
        catch (Exception e) {
            throw new RuntimeException("excel\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b8c\u6574\uff01");
        }
        if (CollectionUtil.isEmpty((Collection)uploadDocList)) {
            return BaseResponse.error((String)"excel\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b8c\u6574\uff01");
        }
        for (UploadDocExcelReqVo uploadDoc : uploadDocList) {
            RemoveBlankUtil.beanAttributeValueTrim((Object)uploadDoc);
            DoctorRecordEntity doctorRecordEntity = (DoctorRecordEntity)BeanUtil.copyProperties((Object)uploadDoc, DoctorRecordEntity.class, (String[])new String[0]);
            doctorRecordEntity.setHospitalCode(this.proPropertiesConstant.getOrganCode());
            doctorRecordEntity.setStatus(Byte.valueOf("1"));
            this.doctorRecordMapper.insertSelective(doctorRecordEntity);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("list", uploadDocList);
        resultMap.put("success", uploadDocList.size());
        resultMap.put("failList", failList);
        resultMap.put("failed", failList.size());
        return BaseResponse.success(resultMap);
    }

    public BaseResponse<DocAppendInfoResVO> getDocAppendInfo(String doctorCode) {
        FrontRequest frontRequest = new FrontRequest();
        RequestRegDoctInfoVo requestRegDoctInfoVo = new RequestRegDoctInfoVo(doctorCode);
        frontRequest.setBody((Object)requestRegDoctInfoVo);
        FrontResponse frontResponse = this.scheduleClient.getDoctorInfo(frontRequest);
        if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
            log.error("\u3010\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528his\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        List bodyList = (List)frontResponse.getBody();
        if (CollectionUtil.isEmpty((Collection)bodyList)) {
            log.error("\u3010\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u3011his\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528his\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5");
        }
        ArrayList<DocAppendInfoResVO.DeptInfo> deptInfoList = new ArrayList<DocAppendInfoResVO.DeptInfo>();
        for (GetRegDoctInfoVo getRegDoctInfoVo : bodyList) {
            deptInfoList.add(DocAppendInfoResVO.DeptInfo.builder().deptCode(getRegDoctInfoVo.getDeptCode()).deptName(getRegDoctInfoVo.getDeptName()).build());
        }
        DocAppendInfoResVO docAppendInfoResVO = DocAppendInfoResVO.builder().docCode(((GetRegDoctInfoVo)bodyList.get(0)).getEmplCode()).docName(((GetRegDoctInfoVo)bodyList.get(0)).getEmplName()).diagFee(((GetRegDoctInfoVo)bodyList.get(0)).getDiagFee()).regFee(((GetRegDoctInfoVo)bodyList.get(0)).getRegFee()).regLevelCode(((GetRegDoctInfoVo)bodyList.get(0)).getReglevlCode()).regLevelName(((GetRegDoctInfoVo)bodyList.get(0)).getLevlName()).deptInfoList(deptInfoList).build();
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectByDocCode(doctorCode);
        if (Objects.nonNull(doctorRecordEntity)) {
            docAppendInfoResVO.setDocIntroduce(doctorRecordEntity.getDocIntroduce());
            docAppendInfoResVO.setDocAvatar(doctorRecordEntity.getDocAvatar());
            docAppendInfoResVO.setDocGoodAt(doctorRecordEntity.getDocGoodAt());
        }
        ArrayList<DocAppendInfoResVO.FeeTypeEnum> feeTypeEnums = new ArrayList<DocAppendInfoResVO.FeeTypeEnum>();
        feeTypeEnums.add(DocAppendInfoResVO.FeeTypeEnum.FREE);
        feeTypeEnums.add(DocAppendInfoResVO.FeeTypeEnum.CHARGE);
        docAppendInfoResVO.setFeeTypeEnums(feeTypeEnums);
        return BaseResponse.success((Object)docAppendInfoResVO);
    }

    public BaseResponse<String> generateDocAppendInfoQrcode(DocAppendInfoQrcodeDTO req) {
        if (StringUtils.equals((CharSequence)req.getFeeType(), (CharSequence)DocAppendInfoResVO.FeeTypeEnum.FREE.getCode()) && !StringUtils.equals((CharSequence)"4092", (CharSequence)req.getDeptCode())) {
            Integer limitNum = 30;
            DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectByDocCode(req.getDocCode());
            if (Objects.nonNull(doctorRecordEntity)) {
                limitNum = doctorRecordEntity.getFreeLimit();
            }
            DateTime startDate = DateUtil.beginOfMonth((Date)new Date());
            DateTime endDate = DateUtil.endOfMonth((Date)new Date());
            Integer count = this.appointmentRecordMapper.selectAppendRegistCount(req.getDocCode(), DateUtil.formatDate((Date)startDate), DateUtil.formatDate((Date)endDate));
            if (count >= limitNum) {
                return BaseResponse.error((String)("\u5f53\u524d\u533b\u751f\u514d\u8d39\u53f7\u52a0\u53f7\u5df2\u4e0a\u9650" + limitNum));
            }
        }
        if ("4002".equals(req.getDeptCode())) {
            req.setRegFee("0");
            req.setDiagFee("21");
            req.setRegLevelCode("100");
            req.setRegLevelName("\u6025\u8bca");
        }
        ScheduleRecordEntity scheduleRecordEntity = this.buildNewScheduleRecored(req);
        this.scheduleRecordMapper.insertSelective(scheduleRecordEntity);
        req.setScheduleId(scheduleRecordEntity.getSysScheduleId());
        String key = "YSJH_QRCODE_" + scheduleRecordEntity.getSysScheduleId();
        this.jedisCluster.set(key, JSON.toJSONString((Object)req));
        this.jedisCluster.expire(key, 300);
        return BaseResponse.success((Object)scheduleRecordEntity.getSysScheduleId());
    }

    public DocAppendInfoQrcodeDTO getDocAppendInfoQrcode(String qrcodeId) {
        String key = "YSJH_QRCODE_" + qrcodeId;
        String result = this.jedisCluster.get(key);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            DocAppendInfoQrcodeDTO docAppendInfoQrcodeDTO = (DocAppendInfoQrcodeDTO)JSON.parseObject((String)result, DocAppendInfoQrcodeDTO.class);
            this.feeRule(docAppendInfoQrcodeDTO);
            BigDecimal payMount = new BigDecimal(docAppendInfoQrcodeDTO.getRegFee()).add(new BigDecimal(docAppendInfoQrcodeDTO.getDiagFee()));
            docAppendInfoQrcodeDTO.setPayAmount(payMount.toPlainString());
            return docAppendInfoQrcodeDTO;
        }
        throw new RuntimeException("\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u4e8c\u7ef4\u7801");
    }

    public BaseResponse<Object> insertDoctorPortraiturl(MultipartFile file) {
        try {
            HashMap<String, String> mapUrl = new HashMap<String, String>();
            List multipartFiles = UnZipUtils.unZip((MultipartFile)file);
            String docUrlStr = "";
            for (MultipartFile multipartFile : multipartFiles) {
                docUrlStr = multipartFile.getName();
                if (!docUrlStr.contains("jpg") && !docUrlStr.contains("png") && !docUrlStr.contains("jpeg") || docUrlStr.contains("/._")) continue;
                String replace = docUrlStr.replace(".jpg", "").replace(".png", "").replace(".jpeg", "");
                String docCode = replace.substring(replace.lastIndexOf("/") + 1, replace.length());
                String doctorFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)multipartFile, (String)docCode);
                String doctorSignUrl = OSSClientUtil.getUrl((String)doctorFileName);
                mapUrl.put(docCode, doctorSignUrl);
            }
            StringBuilder msg = new StringBuilder();
            msg.append("\u4e0d\u5b58\u5728\u533b\u751f\u7f16\u7801\u4e3a");
            Boolean flag = true;
            for (String docCode : mapUrl.keySet()) {
                DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectByDocCode(docCode);
                if (Objects.isNull(doctorRecordEntity)) {
                    msg.append(docCode + "|");
                    flag = false;
                    continue;
                }
                doctorRecordEntity.setDocAvatar((String)mapUrl.get(docCode));
                this.doctorRecordMapper.updateByPrimaryKeySelective(doctorRecordEntity);
            }
            msg.append("\u7684\u533b\u751f,\u5176\u4ed6\u6b63\u5e38\u63d2\u5165");
            if (flag.booleanValue()) {
                return BaseResponse.success((Object)"\u63d2\u5165\u6210\u529f");
            }
            return BaseResponse.success((Object)msg.toString());
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u6279\u91cf\u63d2\u5165\u5934\u50cf\u5f02\u5e38" + e.getMessage()));
        }
    }

    private ScheduleRecordEntity buildNewScheduleRecored(DocAppendInfoQrcodeDTO req) {
        ScheduleRecordEntity scheduleRecord = new ScheduleRecordEntity();
        long schduleId = this.snowflakeIdWorker.nextId();
        scheduleRecord.setAdmLocation(req.getDeptName());
        scheduleRecord.setAvailableCount(Integer.valueOf(1));
        scheduleRecord.setDeptCategoryCode(req.getDeptCode());
        scheduleRecord.setDeptCategoryName(req.getDeptName());
        scheduleRecord.setDeptCode(req.getDeptCode());
        scheduleRecord.setDeptName(req.getDeptName());
        scheduleRecord.setDocCode(req.getDocCode());
        scheduleRecord.setDocName(req.getDocName());
        String areaCode = req.getDeptName().contains("\u6d1b\u9f99") ? "LLYQ" : "YBB";
        scheduleRecord.setHospitalArea(areaCode);
        scheduleRecord.setHospitalAreaName(Objects.equals("LLYQ", areaCode) ? "\u6d1b\u9f99\u9662\u533a" : "\u6cb3\u79d1\u5927\u4e8c\u9644\u9662\u9662\u672c\u90e8");
        scheduleRecord.setHospitalCode(this.proPropertiesConstant.getOrganCode());
        scheduleRecord.setHospitalName("\u6cb3\u5357\u79d1\u6280\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
        scheduleRecord.setIsPrecise(Byte.valueOf((byte)0));
        scheduleRecord.setRegFee(new BigDecimal(req.getRegFee()));
        scheduleRecord.setReplaceScheduleHisId(Convert.toStr((Object)schduleId));
        scheduleRecord.setScheduleDate(DateUtils.getCurrentDate());
        scheduleRecord.setScheduleHisId(Convert.toStr((Object)schduleId));
        scheduleRecord.setScheduleLevel(req.getRegLevelName());
        scheduleRecord.setScheduleLevelCode(req.getRegLevelCode());
        scheduleRecord.setScheduleLevelOrder(Integer.valueOf(1));
        scheduleRecord.setScheduleRange(new Byte("2"));
        scheduleRecord.setScheduleType(new Byte("1"));
        scheduleRecord.setServiceFee(new BigDecimal("0.0"));
        scheduleRecord.setStatus(new Byte("1"));
        scheduleRecord.setTotalCount(Integer.valueOf(5));
        scheduleRecord.setRegTitelCode(req.getRegLevelCode());
        scheduleRecord.setRegTitelName(req.getRegLevelName());
        scheduleRecord.setUpdatetime(new Date());
        scheduleRecord.setUpdateStatus(Byte.valueOf((byte)1));
        scheduleRecord.setSysScheduleId(Convert.toStr((Object)schduleId));
        scheduleRecord.setAutoId(Long.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleRecord.setDiagFee(new BigDecimal(req.getDiagFee()));
        scheduleRecord.setIsAppend("1");
        req.setHospitalArea(scheduleRecord.getHospitalArea());
        req.setHospitalAreaName(scheduleRecord.getHospitalAreaName());
        return scheduleRecord;
    }

    private void feeRule(DocAppendInfoQrcodeDTO docAppendInfoQrcodeDTO) {
        LocalDateTime now = LocalDateTime.now();
        LocalTime currentTime = now.toLocalTime();
        LocalTime startTime1 = LocalTime.of(8, 0);
        LocalTime endTime1 = LocalTime.of(12, 0);
        LocalTime startTime2 = LocalTime.of(14, 0);
        LocalTime endTime2 = LocalTime.of(17, 30);
        LocalDateTime todayStartTime3 = now.toLocalDate().atTime(LocalTime.of(18, 0));
        LocalDateTime tomorrowEndTime3 = now.toLocalDate().plusDays(1L).atTime(LocalTime.of(8, 0));
        if (!(currentTime.isAfter(startTime1) && currentTime.isBefore(endTime1) || currentTime.isAfter(startTime2) && currentTime.isBefore(endTime2))) {
            if (docAppendInfoQrcodeDTO.getDeptName().contains("\u513f\u79d1")) {
                if (!now.isAfter(todayStartTime3) && !now.isBefore(tomorrowEndTime3)) {
                    docAppendInfoQrcodeDTO.setRegFee("0");
                    docAppendInfoQrcodeDTO.setDiagFee("21");
                    docAppendInfoQrcodeDTO.setRegLevelCode("100");
                    docAppendInfoQrcodeDTO.setRegLevelName("\u6025\u8bca\u8bca\u67e5\u8d39");
                }
            } else {
                docAppendInfoQrcodeDTO.setRegFee("0");
                docAppendInfoQrcodeDTO.setDiagFee("21");
                docAppendInfoQrcodeDTO.setRegLevelCode("100");
                docAppendInfoQrcodeDTO.setRegLevelName("\u6025\u8bca\u8bca\u67e5\u8d39");
            }
        }
    }
}

