/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.api.InHospitalClient;
import com.ebaiyihui.api.NetReportClient;
import com.ebaiyihui.api.PaymentClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardReq;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.inhosp.DepositRecordsItem;
import com.ebaiyihui.hkdhisfront.inhosp.FeeItem;
import com.ebaiyihui.hkdhisfront.inhosp.GetIPDepositRecordsReq;
import com.ebaiyihui.hkdhisfront.inhosp.GetInpAdmissionReq;
import com.ebaiyihui.hkdhisfront.inhosp.GetInpAdmissionResItems;
import com.ebaiyihui.hkdhisfront.inhosp.GetOrdItemsReq;
import com.ebaiyihui.hkdhisfront.inhosp.ReponseFeeListVo;
import com.ebaiyihui.hkdhisfront.outpatient.FeeDetail;
import com.ebaiyihui.hkdhisfront.payment.AttachParams;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderRequest;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderResponse;
import com.ebaiyihui.hkdhisfront.payment.PrepayRequest;
import com.ebaiyihui.hkdhisfront.payment.PrepayResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientCheckRecordEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.InpatientCheckRecordEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.GetOrdItemsResItems;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private InHospitalClient InHospitalApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private InHospitalClient inHospitalClient;
    @Autowired
    private NetReportClient netReportClient;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private PaymentClient paymentClient;
    @Autowired
    private InpatientCheckRecordEntityMapper inpatientCheckRecordEntityMapper;

    public GetInpAdmissionResItems getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        FrontRequest frontRequest = new FrontRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCardNo(getInpAdmissionReqVO.getCardNo());
        frontRequest.setBody((Object)getInpAdmissionReq);
        FrontResponse frontResponse = this.inHospitalClient.queryInHospInfo(frontRequest);
        if (Objects.isNull(frontResponse) || !Objects.equals(frontResponse.getCode(), "1")) {
            log.error("InHospitalServiceImpl.getInpAdmissionItems->\u672a\u67e5\u8be2\u5230\u4f4f\u9662\u8bb0\u5f55");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u4f4f\u9662\u8bb0\u5f55");
        }
        getInpAdmissionReqVO.setCardNo(((GetInpAdmissionResItems)frontResponse.getBody()).getInHospNo());
        this.addInpatientCheckRecord(getInpAdmissionReqVO);
        return (GetInpAdmissionResItems)frontResponse.getBody();
    }

    private void addInpatientCheckRecord(GetInpAdmissionReqVO getInpAdmissionReqVO) {
        InpatientCheckRecordEntity inpatientCheckRecordEntity = InpatientCheckRecordEntity.builder().openId(getInpAdmissionReqVO.getOpenId()).inHospNo(getInpAdmissionReqVO.getCardNo()).organCode(getInpAdmissionReqVO.getOrganCode()).organName(getInpAdmissionReqVO.getChannelCode()).phone(getInpAdmissionReqVO.getPhone()).build();
        this.inpatientCheckRecordEntityMapper.insert(inpatientCheckRecordEntity);
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        FrontRequest frontRequest = new FrontRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setInHospNo(inHospitalRechargeDetailReqVO.getInHospNo());
        getIPDepositRecordsReq.setStartDate(inHospitalRechargeDetailReqVO.getStartDate());
        getIPDepositRecordsReq.setEndDate(inHospitalRechargeDetailReqVO.getEndDate());
        frontRequest.setBody((Object)getIPDepositRecordsReq);
        FrontResponse frontResponse = this.inHospitalClient.prepayRecord(frontRequest);
        if (Objects.isNull(frontResponse) || !Objects.equals(frontResponse.getCode(), "1")) {
            log.error("InHospitalServiceImpl.getRechargeDetail->\u672a\u67e5\u8be2\u5230\u5145\u503c\u660e\u7ec6");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u5145\u503c\u660e\u7ec6");
        }
        List depositRecordsItemList = (List)frontResponse.getBody();
        if (CollectionUtils.isEmpty((Collection)depositRecordsItemList)) {
            log.error("InHospitalServiceImpl.getRechargeDetail->\u672a\u67e5\u8be2\u5230\u5145\u503c\u660e\u7ec6");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u5145\u503c\u660e\u7ec6");
        }
        BigDecimal detailTotalMoney = depositRecordsItemList.stream().map(DepositRecordsItem::getRechargeMoney).map(s -> s == null ? BigDecimal.ZERO : new BigDecimal((String)s)).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect = depositRecordsItemList.stream().sorted(Comparator.comparing(DepositRecordsItem::getRechargeTime).reversed()).collect(Collectors.toList());
        inHospitalRechargeDetailResVO.setDetailTotalMoney(detailTotalMoney.toPlainString());
        inHospitalRechargeDetailResVO.setDetailRechargeList(collect);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        FrontRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        FrontResponse frontResponse = this.inHospitalClient.queryDailyBill(getOrdItemsReqGatewayRequest);
        if (Objects.isNull(frontResponse) || !Objects.equals(frontResponse.getCode(), "1")) {
            log.error("InHospitalServiceImpl.getIhHospitalOrderItems->\u672a\u67e5\u8be2\u5230\u8d39\u7528\u660e\u7ec6");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u65e5\u6e05\u5355\u8d39\u7528\u660e\u7ec6");
        }
        ReponseFeeListVo getOrdItemsRes = (ReponseFeeListVo)frontResponse.getBody();
        if (Objects.isNull(frontResponse.getBody()) || CollectionUtils.isEmpty((Collection)getOrdItemsRes.getFeeItemList())) {
            log.error("InHospitalServiceImpl.getIhHospitalOrderItems->\u672a\u67e5\u8be2\u5230\u8d39\u7528\u660e\u7ec6");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u65e5\u6e05\u5355\u8d39\u7528\u660e\u7ec6");
        }
        List feeItemList = getOrdItemsRes.getFeeItemList();
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        getIhHospitalOrderItemsResVo.setFeeItemList(feeItemList);
        getIhHospitalOrderItemsResVo.setName(getOrdItemsRes.getName());
        getIhHospitalOrderItemsResVo.setSex(getOrdItemsRes.getSex());
        getIhHospitalOrderItemsResVo.setAdmDate(getOrdItemsRes.getInDate());
        getIhHospitalOrderItemsResVo.setAdmDep(getOrdItemsRes.getDeptName());
        getIhHospitalOrderItemsResVo.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        BigDecimal detailTotalMoney = feeItemList.stream().map(FeeItem::getCost).map(s -> s == null ? BigDecimal.ZERO : new BigDecimal((String)s)).reduce(BigDecimal.ZERO, BigDecimal::add);
        getIhHospitalOrderItemsResVo.setTotalMoney(detailTotalMoney);
        ArrayList<IhHospitalOrderFreeTypeVo> ihHospitalOrderFreeTypeVoList = new ArrayList<IhHospitalOrderFreeTypeVo>();
        IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
        ArrayList<GetOrdItemsResItems> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItems>();
        for (FeeItem feeItem : feeItemList) {
            GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
            getOrdItemsResItems.setItmMastName(feeItem.getItemName());
            getOrdItemsResItems.setPrice(feeItem.getUnitPrice());
            getOrdItemsResItems.setAmount(feeItem.getCost());
            getOrdItemsResItems.setQty(feeItem.getQty());
            getOrdItemsResItems.setSpec(feeItem.getSpecs());
            getOrdItemsResItems.setUomDesc(feeItem.getUnit());
            getOrdItemsResItems.setRate(feeItem.getRate());
            getOrdItemsResItemsList.add(getOrdItemsResItems);
        }
        ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList(getOrdItemsResItemsList);
        ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setCardNo(inHospDepositCreateOrderReqVO.getInHospNo());
        GetInpAdmissionResItems inpAdmissionItems = this.getInpAdmissionItems(getInpAdmissionReqVO);
        if (Objects.isNull(inpAdmissionItems)) {
            log.error("InHospitalServiceImpl.inHospDepositCreateOrder->\u672a\u67e5\u8be2\u5230\u4f4f\u9662\u4fe1\u606f");
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4f4f\u9662\u4fe1\u606f");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity(inpAdmissionItems, inHospDepositCreateOrderReqVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) {
        log.info("nHospDepositPay->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)inHospDepositPayReqVO.getOrderSeq());
        String payment = this.jedisCluster.get(inHospDepositPayReqVO.getOrderSeq() + "_inhosp_pay");
        if (StringUtils.isNotBlank((CharSequence)payment)) {
            return BaseResponse.success((Object)payment);
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        if (Objects.isNull(inpatientDepositDetailEntity)) {
            log.error("InHospitalServiceImpl.InHospDepositPay->\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            return BaseResponse.error((String)"\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        return this.payCreateOrder(inHospDepositPayReqVO, inpatientDepositDetailEntity);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        return depositCreateOrderResVO;
    }

    public List<InHospitalNumByIdCardVo> getInHospRecordList(String cardId) {
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(cardId);
        if (Objects.isNull(cardDetailsInfoRespVO)) {
            log.error("InHospitalServiceImpl.getInHospRecordList->\u672a\u67e5\u8be2\u5230\u5c31\u8bca\u5361\u4fe1\u606f");
            return null;
        }
        InHospitalNumByIdCardReq getInHospitalNumByIdCardReq = new InHospitalNumByIdCardReq();
        getInHospitalNumByIdCardReq.setIdenno(cardDetailsInfoRespVO.getCredNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)getInHospitalNumByIdCardReq);
        frontRequest.setTransactionId(UUID.randomUUID().toString());
        frontRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        log.info("InHospitalServiceImpl.getInHospRecordList->\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)frontRequest);
        FrontResponse inHospitalRecords = this.netReportClient.getInHospitalNumByIdCard(frontRequest);
        log.info("InHospitalServiceImpl.getInHospRecordList->\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)inHospitalRecords);
        if (inHospitalRecords.getCode().equals("1")) {
            return (List)inHospitalRecords.getBody();
        }
        return null;
    }

    public List<FeeDetail> getInHospitalFeeList(GetOrdItemsReq req) {
        FrontRequest frontRequest = new FrontRequest();
        req.setStartDate(req.getStartDate() + " 00:00:00");
        req.setEndDate(req.getEndDate() + " 23:59:59");
        frontRequest.setBody((Object)req);
        frontRequest.setTransactionId(UUID.randomUUID().toString());
        frontRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        log.info("InHospitalServiceImpl.getHospitalOrderItems->\u67e5\u8be2\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)frontRequest);
        FrontResponse frontResponse = this.inHospitalClient.patientsCostInfor(frontRequest);
        log.info("InHospitalServiceImpl.getHospitalOrderItems->\u67e5\u8be2\u4f4f\u9662\u8ba2\u5355\u660e\u7ec6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)frontResponse);
        if (frontResponse.getCode().equals("1")) {
            return (List)frontResponse.getBody();
        }
        return null;
    }

    private FrontRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        FrontRequest gatewayRequest = new FrontRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        getOrdItemsReq.setStartDate(getHospitalOrderItemsReqVo.getFreeDate());
        getOrdItemsReq.setEndDate(getHospitalOrderItemsReqVo.getFreeDate());
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(inHospDepositCreateOrderReqVO.getInHospNo());
        depositDetailEntity.setInpatientDate((Date)DateUtil.parseDate((CharSequence)getInpAdmissionResItems.getInDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(getInpAdmissionResItems.getInHospNo());
        depositDetailEntity.setPatientOrganId(getInpAdmissionResItems.getInHospNo());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(getInpAdmissionResItems.getInHospNo());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getInHospNo());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalConsum()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getTotalDepost()));
        depositDetailEntity.setPreMoneyBalance(new BigDecimal(getInpAdmissionResItems.getDepostBalance()));
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        depositDetailEntity.setDeptName(getInpAdmissionResItems.getDeptName());
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(inpatientDepositDetailEntity.getId());
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(inpatientDepositDetailEntity.getMoney());
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inpatientDepositDetailEntity.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(InHospDepositPayReqVO inHospDepositPayReqVO, InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        String organCode = inpatientDepositDetailEntity.getDeptName().contains("\u6d1b\u9f99") ? "LLYQ" : "YBB";
        FrontRequest request = this.buildCreateOrderRequest(inpatientDepositDetailEntity);
        request.setOrganCode(organCode);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u521b\u5efa\u8ba2\u5355\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)request));
        FrontResponse createOrderFrontResponse = this.paymentClient.createOrder(request);
        if (Objects.isNull(createOrderFrontResponse) || !"1".equals(createOrderFrontResponse.getCode())) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)createOrderFrontResponse));
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
        }
        CreateOrderResponse createOrderResponse = (CreateOrderResponse)createOrderFrontResponse.getBody();
        if (Objects.isNull(createOrderResponse)) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
        }
        inpatientDepositDetailEntity.setTradeNo(createOrderResponse.getTradeNo());
        FrontRequest prepayRequest = this.buildPrepayRequest(inHospDepositPayReqVO, inpatientDepositDetailEntity);
        prepayRequest.setOrganCode(organCode);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u9884\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)prepayRequest));
        FrontResponse prepayFrontResponse = this.paymentClient.prepay(prepayRequest);
        if (Objects.isNull(prepayFrontResponse) || !"1".equals(prepayFrontResponse.getCode())) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)prepayFrontResponse));
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u4e0b\u5355\u5931\u8d25");
        }
        PrepayResponse prepayResponse = (PrepayResponse)prepayFrontResponse.getBody();
        if (Objects.isNull(prepayResponse)) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
        }
        String payMsg = prepayResponse.getPayMsg();
        JSONObject jsonObject = JSONObject.parseObject((String)payMsg);
        jsonObject.put("packageValue", jsonObject.get((Object)"package"));
        this.jedisCluster.set(inpatientDepositDetailEntity.getOrderSeq() + "_inhosp_pay", JSON.toJSONString((Object)jsonObject.toJSONString()));
        this.jedisCluster.expire(inpatientDepositDetailEntity.getOrderSeq() + "_inhosp_pay", 7200);
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKeySelective(inpatientDepositDetailEntity);
        return BaseResponse.success((Object)jsonObject.toJSONString());
    }

    private FrontRequest<CreateOrderRequest> buildCreateOrderRequest(InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        FrontRequest request = new FrontRequest();
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        CreateOrderRequest createOrderRequest = CreateOrderRequest.builder().businessId(inpatientDepositDetailEntity.getOrderSeq()).goodsCode("inhos_payment").identityId(inpatientDepositDetailEntity.getPatientOrganId()).isAgency("false").macNumber("\u4e92\u533b\u5fae\u4fe1\u5c0f\u7a0b\u5e8f").name(inpatientDepositDetailEntity.getPatientName()).operator("zwby").orderBody("\u4e92\u8054\u7f51\u533b\u9662\u5c0f\u7a0b\u5e8f\u4f4f\u9662\u9884\u4ea4\u91d1").payAmount(inpatientDepositDetailEntity.getMoney()).totalAmount(inpatientDepositDetailEntity.getMoney()).build();
        ArrayList<CreateOrderRequest.GoodsList> goodsList = new ArrayList<CreateOrderRequest.GoodsList>();
        CreateOrderRequest.GoodsList goodsListObj = CreateOrderRequest.GoodsList.builder().goodsAmount(inpatientDepositDetailEntity.getMoney()).goodsName("\u4f4f\u9662\u9884\u4ea4\u91d1").goodsPrice(inpatientDepositDetailEntity.getMoney()).goodsQuantity(new BigDecimal("1.0")).goodsSpec("1").build();
        goodsList.add(goodsListObj);
        createOrderRequest.setGoodsList(goodsList);
        request.setBody((Object)createOrderRequest);
        return request;
    }

    private FrontRequest<PrepayRequest> buildPrepayRequest(InHospDepositPayReqVO inHospDepositPayReqVO, InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        FrontRequest request = new FrontRequest();
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        PrepayRequest prepayRequest = PrepayRequest.builder().requestNo(inpatientDepositDetailEntity.getOrderSeq()).tradeNo(inpatientDepositDetailEntity.getTradeNo()).payType("WeChatAppletPay").payAmount(inpatientDepositDetailEntity.getMoney().toString()).macNumber("\u4e92\u533b\u5fae\u4fe1\u5c0f\u7a0b\u5e8f").notifyUrl(this.propertiesConstant.getInHospitalPayNotifyUrl()).build();
        AttachParams attachParams = AttachParams.builder().callbackUrl(this.propertiesConstant.getInHospitalPayNotifyUrl()).build();
        prepayRequest.setAttachParams(JSON.toJSONString((Object)attachParams));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("openid", (Object)inHospDepositPayReqVO.getOpenId());
        jsonObject.put("goods_desc", (Object)"\u4f4f\u9662\u9884\u4ea4\u91d1");
        prepayRequest.setBizContent(jsonObject.toJSONString());
        request.setBody((Object)prepayRequest);
        return request;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

