/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT = "HH:mm";
    public static final String SIMPLE_FORMAT = "yyyy-MM-dd";
    private static final String FORMAT = "yyyyMMddHHmmss";
    private static final String SIMPLE_NOSPE_FORMAT = "yyyyMMdd";
    private static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";
    private static final String SIMPLE_TIME_NOSE_FORMAT = "HH:mm";
    public static final String SIMPLE_YMD_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String SIMPLE_YMDFULL_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    private static final String PARSE_EXCEPTION = "ParseException";

    public static long getDistanceDays(String str1, String str2) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long days = 0L;
        try {
            java.util.Date one = df.parse(str1);
            java.util.Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        return days;
    }

    public static long[] getDistanceTimes(String str1, String str2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            java.util.Date one = df.parse(str1);
            java.util.Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        long[] times = new long[]{day, hour, min, sec};
        return times;
    }

    public static String getDistanceTime(String str1, String str2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            java.util.Date one = df.parse(str1);
            java.util.Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206" + sec + "\u79d2";
    }

    public static java.util.Date getAgoDay(int i) {
        java.util.Date date = new java.util.Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -i);
        date = calendar.getTime();
        return date;
    }

    public static java.util.Date getDayZero(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        java.util.Date start = calendar.getTime();
        return start;
    }

    public static long differFrom(java.util.Date date1, java.util.Date date2) {
        long minutes = date2.getTime() - date1.getTime();
        return minutes;
    }

    public static long differFromSecond(java.util.Date date1, java.util.Date date2) {
        long minutes = (date2.getTime() - date1.getTime()) / 1000L;
        return minutes;
    }

    public static Integer getAge(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strYear = df.format(date);
        String year = strYear.split("-")[0];
        Calendar cal = Calendar.getInstance();
        int iCurrYear = cal.get(1);
        int iAge = iCurrYear - Integer.valueOf(year);
        return iAge;
    }

    public static boolean judgeTime(String startStr, String endStr) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            java.util.Date dt1 = df.parse(startStr);
            java.util.Date dt2 = df.parse(endStr);
            if (dt1.getTime() < dt2.getTime()) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentTimeNoSecond() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(calendar.getTime());
    }

    public static java.util.Date getDateBefore(java.util.Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static java.util.Date getDateAfter(java.util.Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static java.util.Date getAddMonth(java.util.Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, month);
        return now.getTime();
    }

    public static String dateToYMDFullString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        return sdf.format(date);
    }

    public static String dateToYMDString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return sdf.format(date);
    }

    public static java.util.Date getSubtractMonth(java.util.Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static java.util.Date getAddYear(java.util.Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, year);
        return now.getTime();
    }

    public static java.util.Date getSubtractYear(java.util.Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, -year);
        return now.getTime();
    }

    private static Calendar initCurrentDate() {
        java.util.Date date = new java.util.Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int getCurrentYear() {
        Calendar c = DateUtils.initCurrentDate();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        return DateUtils.initCurrentDate().get(2) + 1;
    }

    public static int getCurrentDay() {
        return DateUtils.initCurrentDate().get(5);
    }

    public static int getCurrentHour() {
        return DateUtils.initCurrentDate().get(11);
    }

    public static int getCurrentMinute() {
        return DateUtils.initCurrentDate().get(12);
    }

    public static int getCurrentSecond() {
        return DateUtils.initCurrentDate().get(13);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat parse = new SimpleDateFormat(format);
        return parse.format(new java.util.Date());
    }

    public static java.util.Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        java.util.Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static String dateToString(java.util.Date date, String par) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(par);
        return sdf.format(date);
    }

    public static long strToDateLong(String date) {
        long l = 0L;
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(Date.valueOf(date));
            l = ca.getTimeInMillis();
        }
        catch (Exception e) {
            log.error("strToDateLong\u5f02\u5e38:", (Throwable)e);
        }
        return l;
    }

    public static String longToStrDate(String format, long time) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new java.util.Date(time));
    }

    public static java.util.Date strToDate(String str, String parsePatterns) throws ParseException {
        return DateUtils.parseDate((String)str, (String)parsePatterns);
    }

    public static java.util.Date getAfterCurrentDay(int days) {
        java.util.Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            log.error("getAfterCurrentDay:", (Throwable)e);
        }
        return result;
    }

    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleNoSpeToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(calendar.getTime());
    }

    public static java.util.Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Timestamp getCurrentDateTimestamp() {
        Calendar calendar = Calendar.getInstance();
        return new Timestamp(calendar.getTime().getTime());
    }

    public static String getNextWeekToString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(7, 6);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getNextDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, 1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        return result;
    }

    public static String getLastWeekToString() {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.add(4, -1);
            result = df.format(calendar.getTime());
        }
        catch (Exception e) {
            log.error("getLastWeekToString:", (Throwable)e);
        }
        return result;
    }

    public static String getYestarDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, -1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        return result;
    }

    public static java.util.Date stringToSimpleDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date stringToSimpleDateJS(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String stringToSimpleString(String string) {
        String newDate = string;
        try {
            java.util.Date date = DateUtils.stringToDate((String)string, (String)"yyyy-MM-dd HH:mm:ss");
            newDate = DateUtils.dateToSimpleString((java.util.Date)date);
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        return newDate;
    }

    public static java.util.Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date stringToFullDateTime(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String dateToFullString(java.util.Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String timeToFullString(java.util.Date date) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(date);
    }

    public static String getWeekChinese(String date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            log.error("ParseException", (Throwable)e);
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getWeekZhou(String date) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            log.error("getWeekZhou:", (Throwable)e);
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean judgeDate(String startStr, String endStr) {
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        java.util.Date endDate = DateUtils.stringToSimpleDate((String)endStr);
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
            return startDate.before(endDate);
        }
        return false;
    }

    public static boolean judgeDateEqual(String startStr, String endStr) {
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        java.util.Date endDate = DateUtils.stringToSimpleDate((String)endStr);
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
            return startDate.before(endDate) || startDate.compareTo(endDate) == 0;
        }
        return false;
    }

    public static String getNumAfterDate(String str, int day) {
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(7, day);
        return DateUtils.dateToSimpleString((java.util.Date)calendar.getTime());
    }

    public static String unixTimeToString(String unixTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(unixTime));
        return DateUtils.dateToSimpleString((java.util.Date)c.getTime());
    }

    public static String stringToUnixTime(String date) {
        Calendar c = Calendar.getInstance();
        java.util.Date date2 = DateUtils.stringToSimpleDate((String)date);
        c.setTime(date2);
        return c.getTimeInMillis() + "";
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            log.error("stringToTimestamp:", (Throwable)e);
        }
        return ts;
    }

    public static String getStrByTimestamp(Timestamp ccTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(ccTime);
    }

    public static Time strToTime(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        try {
            format.parse(str);
        }
        catch (Exception e) {
            log.error("strToTime", (Throwable)e);
        }
        return Time.valueOf(str);
    }

    public static Time getTime() {
        java.util.Date d = new java.util.Date();
        Time time = new Time(d.getTime());
        return time;
    }

    public static int getBetweenDayNumber(java.util.Date dateA, java.util.Date dateB) {
        long dayNumber = 0L;
        long day = 86400000L;
        try {
            dayNumber = (dateB.getTime() - dateA.getTime()) / day;
        }
        catch (Exception e) {
            log.error("getBetweenDayNumber", (Throwable)e);
        }
        return (int)dayNumber;
    }

    public static int daysBetween(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static int secondsBetween(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static java.util.Date dateAddDays(java.util.Date date, int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, addDays);
        return calendar.getTime();
    }

    public static java.util.Date dateAddHours(java.util.Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, addHours);
        return calendar.getTime();
    }

    public static java.util.Date dateAddMinutes(java.util.Date date, int addMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, addMinutes);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        java.util.Date date = DateUtils.dateAddMinutes((java.util.Date)DateUtils.stringToFullDateTime((String)"04:00"), (int)5);
        String s = "12:02-12:09";
        System.out.println(s.substring(0, 5));
    }

    public static String longToString(long currentTime, String formatType) throws ParseException {
        java.util.Date date = DateUtils.longToDate((long)currentTime, (String)formatType);
        String strTime = DateUtils.dateToString((java.util.Date)date, (String)formatType);
        return strTime;
    }

    public static java.util.Date stringToDate(String strTime, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        java.util.Date date = null;
        date = formatter.parse(strTime);
        return date;
    }

    public static java.util.Date longToDate(long currentTime, String formatType) throws ParseException {
        java.util.Date dateOld = new java.util.Date(currentTime);
        String sDateTime = DateUtils.dateToString((java.util.Date)dateOld, (String)formatType);
        java.util.Date date = DateUtils.stringToDate((String)sDateTime, (String)formatType);
        return date;
    }

    public static long dateToLong(java.util.Date date) {
        return date.getTime();
    }

    public static java.util.Date setPrecise(java.util.Date d, int hour, int min, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date addDays(java.util.Date time, Integer count) {
        if (null == count || count == 0) {
            return time;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.add(5, count);
        java.util.Date newTime = c.getTime();
        return newTime;
    }

    public static java.util.Date subHMS(java.util.Date time) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(time);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.set(14, 0);
        return cal1.getTime();
    }

    public static String getWeekSimpleChinese(String date) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            log.error("getWeekSimpleChinese", (Throwable)e);
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getAgeByBirth(java.util.Date birthDay) throws ParseException {
        int age = 0;
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static boolean checkTimeRange(String startTime, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            java.util.Date startDate = sdf.parse(startTime);
            java.util.Date endDate = sdf.parse(DateTimeFormatter.ofPattern(format).format(LocalDateTime.now()));
            return startDate.after(endDate);
        }
        catch (Exception e) {
            log.error("checkTimeRange:", (Throwable)e);
            return false;
        }
    }

    public static String checkTime(String date) {
        StringBuilder a = new StringBuilder();
        java.util.Date feeDate = DateUtils.stringToSimpleDate((String)date);
        String feeDateString = DateUtils.dateToString((java.util.Date)feeDate, (String)"yyyy/MM/dd");
        String[] substring = feeDateString.split("/");
        StringBuilder b = new StringBuilder();
        b = "0".equals(substring[1].substring(0, 1)) ? b.append(substring[1].replace("0", "")) : b.append(substring[1]);
        a.append(substring[0]).append("/").append((CharSequence)b).append("/").append(substring[2]);
        return a.toString();
    }

    public static String jsTimeToTimeString(String date) {
        String s = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            java.util.Date parse = simpleDateFormat.parse(date);
            s = DateUtils.dateToFullString((java.util.Date)parse);
        }
        catch (Exception e) {
            log.error("jsTimeToTimeString", (Throwable)e);
        }
        return s;
    }
}

