/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.core.dto.drugItem.ResponseDrugResDTO;
import com.ebaiyihui.his.core.dto.drugItem.ResponseResDTO;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.DrugService;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.vo.DrugCountReqVo;
import com.ebaiyihui.his.core.vo.DrugListReqVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugServiceImpl
implements DrugService {
    private static final Logger log = LoggerFactory.getLogger(DrugServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<ResponseDrugResDTO> getDrugList(FrontRequest<DrugListReqVo> frontRequest) {
        HashMap<String, DrugListReqVo> map = new HashMap<String, DrugListReqVo>();
        DrugListReqVo drugListReqVo = (DrugListReqVo)frontRequest.getBody();
        log.info("drugListReqVo\u5165\u53c2:" + drugListReqVo.toString());
        map.put(RequestEntityEnum.GET_DRUG_LIST.getValue(), drugListReqVo);
        FrontResponse cardInfoFrontResponse = this.hisRemoteService.requestHis(frontRequest.getTransactionId(), MethodCodeEnum.GET_DRUG_LIST.getValue(), map, ResponseDrugResDTO.class);
        log.info("==========" + JSONObject.toJSONString((Object)cardInfoFrontResponse));
        ResponseDrugResDTO responseDrug = (ResponseDrugResDTO)cardInfoFrontResponse.getBody();
        log.info("==========\u8f6c\u5316\u7684\u5bf9\u8c61\u7684\u503c" + JSONObject.toJSONString((Object)responseDrug));
        if (null == responseDrug) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(cardInfoFrontResponse.getCode())) {
            return FrontResponse.error((String)cardInfoFrontResponse.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(cardInfoFrontResponse.getCode())) {
            return FrontResponse.success((String)cardInfoFrontResponse.getTransactionId(), null);
        }
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)responseDrug);
    }

    public FrontResponse<ResponseResDTO> getDrugCount(FrontRequest<DrugCountReqVo> frontRequest) {
        HashMap<String, DrugCountReqVo> map = new HashMap<String, DrugCountReqVo>();
        DrugCountReqVo drugListReqVo = (DrugCountReqVo)frontRequest.getBody();
        log.info("drugListReqVo\u5165\u53c2:" + drugListReqVo.toString());
        map.put(RequestEntityEnum.GET_DRUG_COUNT.getValue(), drugListReqVo);
        FrontResponse cardInfoFrontResponse = this.hisRemoteService.requestHis(frontRequest.getTransactionId(), MethodCodeEnum.GET_DRUG_COUNT.getValue(), map, ResponseResDTO.class);
        ResponseResDTO responseRes = (ResponseResDTO)cardInfoFrontResponse.getBody();
        if (null == responseRes) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(cardInfoFrontResponse.getCode())) {
            return FrontResponse.error((String)cardInfoFrontResponse.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(cardInfoFrontResponse.getCode())) {
            return FrontResponse.success((String)cardInfoFrontResponse.getTransactionId(), null);
        }
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)responseRes);
    }
}

