/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.ebaiyihui.his.core.dto.OrderPushResDto;
import com.ebaiyihui.his.core.dto.OrderResDto;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.OrderStateEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.service.OrderService;
import com.ebaiyihui.his.core.vo.OrderCancelReqVo;
import com.ebaiyihui.his.core.vo.OrderPushReqVo;
import com.ebaiyihui.his.core.vo.OrderPushResVo;
import com.ebaiyihui.his.core.vo.OrderReqVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<OrderPushResVo> push(FrontRequest<OrderPushReqVo> orderPushReqVo) {
        HashMap<String, OrderPushReqVo> map = new HashMap<String, OrderPushReqVo>();
        OrderPushReqVo orderPushReq = (OrderPushReqVo)orderPushReqVo.getBody();
        log.info("orderPushReqVo\u5165\u53c2:{}", (Object)orderPushReqVo.toString());
        map.put(RequestEntityEnum.REQUEST_ORDER_PUSH_INFO.getValue(), orderPushReq);
        FrontResponse orderPushFrontResponse = this.hisRemoteService.requestHis(orderPushReqVo.getTransactionId(), MethodCodeEnum.REQUEST_ORDER_INFO.getValue(), map, OrderPushResDto.class);
        OrderPushResDto orderPush = (OrderPushResDto)orderPushFrontResponse.getBody();
        if (null == orderPush) {
            return FrontResponse.error((String)orderPushReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(orderPush.getResult())) {
            return FrontResponse.error((String)orderPushReqVo.getTransactionId(), (String)"0", (String)orderPush.getErr());
        }
        if (!OrderStateEnum.OORDER_SUCCESS.getValue().equals(orderPush.getOrderState())) {
            return FrontResponse.error((String)orderPushReqVo.getTransactionId(), (String)"0", (String)orderPush.getErr());
        }
        OrderPushResVo orderPushResVo = new OrderPushResVo();
        orderPushResVo.setOrderId(orderPush.getId());
        return FrontResponse.success((String)orderPushReqVo.getTransactionId(), (Object)orderPushResVo);
    }

    public FrontResponse<String> cancel(FrontRequest<OrderCancelReqVo> orderCancelReqVo) {
        HashMap<String, OrderCancelReqVo> map = new HashMap<String, OrderCancelReqVo>();
        OrderCancelReqVo orderCancelReq = (OrderCancelReqVo)orderCancelReqVo.getBody();
        log.info("orderCancelReq\u5165\u53c2:{}", (Object)orderCancelReq.toString());
        map.put(RequestEntityEnum.REQUEST_ORDER_CANCEL_INFO.getValue(), orderCancelReq);
        FrontResponse orderPushFrontResponse = this.hisRemoteService.requestHis(orderCancelReqVo.getTransactionId(), MethodCodeEnum.REQUEST_ORDER_INFO.getValue(), map, OrderResDto.class);
        OrderResDto order = (OrderResDto)orderPushFrontResponse.getBody();
        if (null == order) {
            return FrontResponse.error((String)orderCancelReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(order.getResult())) {
            return FrontResponse.error((String)orderCancelReqVo.getTransactionId(), (String)"0", (String)order.getErr());
        }
        return FrontResponse.success((String)orderCancelReqVo.getTransactionId(), (Object)"");
    }

    public FrontResponse<String> whetherCancel(FrontRequest<OrderReqVo> orderReqVo) {
        HashMap<String, OrderReqVo> map = new HashMap<String, OrderReqVo>();
        OrderReqVo orderReq = (OrderReqVo)orderReqVo.getBody();
        log.info("orderReq\u5165\u53c2:{}", (Object)orderReq.toString());
        map.put(RequestEntityEnum.REQUEST_ORDER_INFO.getValue(), orderReq);
        FrontResponse orderPushFrontResponse = this.hisRemoteService.requestHis(orderReqVo.getTransactionId(), MethodCodeEnum.REQUEST_ORDER_WHETHER_CANCEL_INFO.getValue(), map, OrderResDto.class);
        OrderResDto order = (OrderResDto)orderPushFrontResponse.getBody();
        if (null == order) {
            return FrontResponse.error((String)orderReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(order.getResult())) {
            return FrontResponse.error((String)orderReqVo.getTransactionId(), (String)"0", (String)order.getErr());
        }
        return FrontResponse.success((String)orderReqVo.getTransactionId(), (Object)"");
    }
}

