/*
 * Decompiled with CFR 0.152.
 */
package com.igoodsale.ucetner.utils;

import com.igoodsale.framework.utils.UniqueKeyGenerator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    private int retryCount = 3;
    private int waitIntervalInMS = 100;

    public String simpleLock(String redisKey, int expireInSecond) {
        String lockValue = UniqueKeyGenerator.generateUUID();
        boolean flag = false;
        if (StringUtils.isEmpty((Object)redisKey)) {
            throw new RuntimeException("key is empty!");
        }
        if (expireInSecond <= 0) {
            throw new RuntimeException("expireInSecond must be bigger than 0");
        }
        try {
            for (int i = 0; i < this.retryCount; ++i) {
                boolean success = this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)lockValue, (long)expireInSecond, TimeUnit.SECONDS);
                if (success) {
                    flag = true;
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this.waitIntervalInMS);
                    continue;
                }
                catch (Exception ignore) {
                    log.warn("redis lock fail: " + ignore.getMessage());
                }
            }
            if (!flag) {
                throw new RuntimeException(Thread.currentThread().getName() + " cannot acquire lock now ...");
            }
            String i = lockValue;
            return i;
        }
        catch (Exception e) {
            log.warn("get redis lock error, exception: " + e.getMessage());
            throw e;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public String lock(String redisKey, int expireInSecond, int timeoutSecond) {
        String lockValue = UniqueKeyGenerator.generateUUID();
        boolean flag = false;
        if (StringUtils.isEmpty((Object)redisKey)) {
            throw new RuntimeException("key is empty!");
        }
        if (expireInSecond <= 0) {
            throw new RuntimeException("expireInSecond must be greater than 0");
        }
        if (timeoutSecond <= 0) {
            throw new RuntimeException("timeoutSecond must be greater than 0");
        }
        if (timeoutSecond >= expireInSecond) {
            throw new RuntimeException("timeoutSecond must be less than expireInSecond");
        }
        try {
            long timeoutAt = System.currentTimeMillis() + (long)(timeoutSecond * 1000);
            while (true) {
                boolean success;
                if (success = this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)lockValue, (long)expireInSecond, TimeUnit.SECONDS).booleanValue()) {
                    flag = true;
                    break;
                }
                if (System.currentTimeMillis() >= timeoutAt) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.waitIntervalInMS);
                }
                catch (Exception ignore) {
                    log.warn("redis lock fail: " + ignore.getMessage());
                }
            }
            if (!flag) {
                throw new RuntimeException(Thread.currentThread().getName() + " cannot acquire lock now ...");
            }
            String string = lockValue;
            return string;
        }
        catch (Exception e) {
            log.warn("get redis lock error, exception: " + e.getMessage());
            throw e;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String redisKey, String lockValue) {
        if (StringUtils.isEmpty((Object)redisKey)) {
            return;
        }
        if (StringUtils.isEmpty((Object)lockValue)) {
            return;
        }
        try {
            String currLockVal = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
            if (currLockVal != null && currLockVal.equals(lockValue)) {
                boolean result = this.redisTemplate.delete((Object)redisKey);
                if (!result) {
                    log.warn(Thread.currentThread().getName() + " unlock redis lock fail");
                } else {
                    log.info(Thread.currentThread().getName() + " unlock redis lock:" + redisKey + " successfully!");
                }
            }
        }
        catch (Exception je) {
            log.warn(Thread.currentThread().getName() + " unlock redis lock error:" + je.getMessage());
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }
}

