/*
 * Decompiled with CFR 0.152.
 */
package com.igoodsale.ucetner.utils;

import com.igoodsale.ucetner.utils.CallBack;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class UcSpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UcSpringContextHolder.class);
    private static ApplicationContext applicationContext = null;
    private static final List<CallBack> CALL_BACKS = new ArrayList<CallBack>();
    private static boolean addCallback = true;

    public static synchronized void addCallBacks(CallBack callBack) {
        if (addCallback) {
            CALL_BACKS.add(callBack);
        } else {
            log.warn("CallBack\uff1a{} \u5df2\u65e0\u6cd5\u6dfb\u52a0\uff01\u7acb\u5373\u6267\u884c", (Object)callBack.getCallBackName());
            callBack.executor();
        }
    }

    public static <T> T getBean(String name) {
        UcSpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        UcSpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T getProperties(String property, T defaultValue, Class<T> requiredType) {
        Object result = defaultValue;
        try {
            result = UcSpringContextHolder.getBean(Environment.class).getProperty(property, requiredType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getProperties(String property) {
        return UcSpringContextHolder.getProperties(property, null, String.class);
    }

    public static <T> T getProperties(String property, Class<T> requiredType) {
        return UcSpringContextHolder.getProperties(property, null, requiredType);
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder\u6216\u5728SpringBoot\u542f\u52a8\u7c7b\u4e2d\u6ce8\u518cSpringContextHolder.");
        }
    }

    private static void clearHolder() {
        log.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        applicationContext = null;
    }

    public void destroy() {
        UcSpringContextHolder.clearHolder();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (UcSpringContextHolder.applicationContext != null) {
            log.warn("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + UcSpringContextHolder.applicationContext);
        }
        UcSpringContextHolder.applicationContext = applicationContext;
        if (addCallback) {
            for (CallBack callBack : CALL_BACKS) {
                callBack.executor();
            }
            CALL_BACKS.clear();
        }
        addCallback = false;
    }
}

