/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.basedata.api.utils;

import com.doctor.basedata.api.annotation.validate.MaxSize;
import com.doctor.basedata.api.annotation.validate.MinSize;
import com.doctor.basedata.api.annotation.validate.NotEmpty;
import com.doctor.basedata.api.annotation.validate.NotNull;
import com.doctor.basedata.api.utils.ValidateResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidPropertyUtil.class);

    public static ValidateResult validate(Object bean) {
        ValidateResult result = new ValidateResult().initSuccess();
        Class<?> cls = bean.getClass();
        try {
            Field[] fields;
            for (Field f : fields = cls.getDeclaredFields()) {
                Annotation[] arrayAno;
                f.setAccessible(true);
                Object value = f.get(bean);
                for (Annotation annotation : arrayAno = f.getAnnotations()) {
                    Method[] methodArray;
                    Class<? extends Annotation> clazz = annotation.annotationType();
                    for (Method method : methodArray = clazz.getDeclaredMethods()) {
                        String methodName = method.getName();
                        if ("message".equals(methodName)) continue;
                        Object obj = ValidPropertyUtil.class.newInstance();
                        try {
                            Method m = obj.getClass().getDeclaredMethod(methodName, Object.class, Field.class);
                            result = (ValidateResult)m.invoke(obj, value, f);
                            if (result.isSuccess()) continue;
                            return result;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.info("\u627e\u4e0d\u5230\u8be5\u65b9\u6cd5:" + methodName);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9a8c\u8bc1\u51fa\u9519");
        }
        return result;
    }

    public ValidateResult isEmpty(Object value, Field field) {
        ValidateResult validateResult = new ValidateResult().initSuccess();
        NotEmpty annotation = field.getAnnotation(NotEmpty.class);
        if (value == null || value.equals("")) {
            validateResult.setMessage(field.getName() + annotation.message());
            validateResult.setSuccess(false);
        }
        return validateResult;
    }

    public ValidateResult min(Object value, Field field) {
        ValidateResult validateResult = new ValidateResult().initSuccess();
        MinSize annotation = field.getAnnotation(MinSize.class);
        if (value != null && value.toString().length() < annotation.min()) {
            validateResult.setMessage(field.getName() + annotation.message());
            validateResult.setSuccess(false);
        }
        return validateResult;
    }

    public ValidateResult max(Object value, Field field) {
        ValidateResult validateResult = new ValidateResult().initSuccess();
        MaxSize annotation = field.getAnnotation(MaxSize.class);
        if (value != null && value.toString().length() > annotation.max()) {
            validateResult.setMessage(field.getName() + annotation.message());
            validateResult.setSuccess(false);
        }
        return validateResult;
    }

    public ValidateResult isNull(Object value, Field field) {
        ValidateResult validateResult = new ValidateResult().initSuccess();
        NotNull annotation = field.getAnnotation(NotNull.class);
        if (Objects.isNull(value)) {
            validateResult.setMessage(field.getName() + annotation.message());
            validateResult.setSuccess(false);
        }
        return validateResult;
    }
}

