/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.api.pojo.base.vo.basedata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.util.Objects;

public class GuideBaseResponse<T> {
    public static final String QUERY_SUCCESS_MESSAGE = "\u67e5\u8be2\u6210\u529f\uff0c\u5171\u67e5\u8be2{0}\u6761\u6570\u636e";
    public static final String DEFAULT_SUCCESS_MESSAGE = "\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a";
    public static final String DEFAULT_ERROR_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    public static final String DEFAULT_SUCCESS_CODE = "0";
    public static final String DEFAULT_ERROR_CODE = "1";
    private String code;
    private String message;
    private T data;

    public GuideBaseResponse() {
    }

    public GuideBaseResponse(String code, String message, T data) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public static <T> GuideBaseResponse<T> success(T t, String message) {
        GuideBaseResponse<T> res = new GuideBaseResponse<T>();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMessage(message);
        res.setData(t);
        return res;
    }

    public static <T> GuideBaseResponse<T> success() {
        GuideBaseResponse<T> res = new GuideBaseResponse<T>();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMessage(DEFAULT_SUCCESS_MESSAGE);
        res.setData(null);
        return res;
    }

    public static <T> GuideBaseResponse<T> error(String msg) {
        GuideBaseResponse<T> res = new GuideBaseResponse<T>();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setMessage(msg);
        res.setData(null);
        return res;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Transient
    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(this.code, DEFAULT_SUCCESS_MESSAGE);
    }

    public String toString() {
        return "GuideBaseResponse [code=" + this.code + ", msg=" + this.message + ", data=" + this.data + "]";
    }
}

