/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.HLZDServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctor.basedata.api.vo.ServiceNursingConfigReqVo;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.utils.HttpClientUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="hlzd")
public class HLZDServiceHandler
implements DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(HLZDServiceHandler.class);
    @Value(value="${domainName}")
    private String NodeDomainName;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        log.info("\u8fdb\u5165\u540c\u6b65\u533b\u751f\u670d\u52a1\u8bbe\u7f6e\u5230\u5728\u7ebf\u590d\u8bca,\u670d\u52a1\u53c2\u6570:{},\u533b\u751fid\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)serviceSetParam), doctorIds);
        HLZDServiceBo serviceInfo = (HLZDServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), HLZDServiceBo.class);
        ArrayList<ServiceNursingConfigReqVo> serviceNursingConfigReqList = new ArrayList<ServiceNursingConfigReqVo>();
        for (Long doctorId : doctorIds) {
            ServiceNursingConfigReqVo serviceNursingConfig = new ServiceNursingConfigReqVo();
            serviceNursingConfig.setAmPrice(serviceInfo.getDayServicePrice());
            serviceNursingConfig.setAmTimeEnd(serviceInfo.getMorningEndTime());
            serviceNursingConfig.setAmTimeStart(serviceInfo.getMorningStartTime());
            serviceNursingConfig.setPmPrice(serviceInfo.getNightServicePrice());
            serviceNursingConfig.setNightTimeEnd(serviceInfo.getNightEndTime());
            serviceNursingConfig.setNightTimeStart(serviceInfo.getNightStartTime());
            serviceNursingConfig.setPmTimeEnd(serviceInfo.getNoonEndTime());
            serviceNursingConfig.setPmTimeStart(serviceInfo.getNoonStartTime());
            serviceNursingConfig.setServTime(serviceInfo.getEffectiveTime());
            serviceNursingConfig.setNumLimit(serviceInfo.getReplyLimit());
            serviceNursingConfig.setDailyLimit(serviceInfo.getNumLimit());
            serviceNursingConfig.setAppCode(serviceSetParam.getAppCode());
            serviceNursingConfig.setCreateTime(new Date());
            serviceNursingConfig.setDeptId(serviceSetParam.getRemark());
            serviceNursingConfig.setDoctorId(String.valueOf(doctorId));
            serviceNursingConfig.setOrganId(String.valueOf(serviceSetParam.getOrganId()));
            serviceNursingConfig.setWeekendPrice(serviceInfo.getWeekendServicePrice());
            serviceNursingConfigReqList.add(serviceNursingConfig);
        }
        if (!serviceNursingConfigReqList.isEmpty()) {
            log.info("\u8c03\u7528\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u5165\u53c2:{}", (Object)JSON.toJSONString(serviceNursingConfigReqList));
            BaseResponse baseResponse = HttpClientUtil.doJsonPost(serviceNursingConfigReqList, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/nursingguidance/advisory/saveListServiceInfo"));
            if (!baseResponse.isSuccess()) {
                throw new RuntimeException("\u540c\u6b65\u62a4\u7406\u6307\u5bfc\u670d\u52a1\u5931\u8d25");
            }
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        HLZDServiceBo hlzdServiceBO = (HLZDServiceBo)JSON.parseObject((String)serviceConfig, HLZDServiceBo.class);
        if (Objects.isNull(hlzdServiceBO)) {
            return ServiceCodeEnum.HLZD.getServiceConfig();
        }
        return JSON.toJSONString((Object)hlzdServiceBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        HLZDServiceBo hlzdServiceBO = (HLZDServiceBo)JSON.parseObject((String)serviceConfig, HLZDServiceBo.class);
        if (Objects.isNull(hlzdServiceBO)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return ValidPropertyUtil.validate((Object)hlzdServiceBO);
    }
}

