/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.mapper.DocPatientRelationMapper;
import com.doctoruser.doctor.mapper.DocRelationGroupMapper;
import com.doctoruser.doctor.pojo.entity.DocPatientRelationEntity;
import com.doctoruser.doctor.pojo.entity.DocRelationGroupEntity;
import com.doctoruser.doctor.pojo.vo.DocRelationGroupReqVo;
import com.doctoruser.doctor.pojo.vo.DocRelationGroupRespVo;
import com.doctoruser.doctor.pojo.vo.QueryRelationGroupVo;
import com.doctoruser.doctor.service.DocRelationGroupService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DocRelationGroupServiceImpl
implements DocRelationGroupService {
    private static final Logger log = LoggerFactory.getLogger(DocRelationGroupServiceImpl.class);
    @Autowired
    private DocRelationGroupMapper docRelationGroupMapper;
    @Autowired
    private DocPatientRelationMapper docPatientRelationMapper;

    public BaseResponse<DocRelationGroupRespVo> addDocRelationGroup(DocRelationGroupReqVo reqVo) {
        DocRelationGroupEntity docRelationGroup = this.docRelationGroupMapper.getByNameAndDoctor(reqVo.getAppCode(), reqVo.getDoctorId(), reqVo.getName(), 1);
        if (Objects.nonNull(docRelationGroup)) {
            return BaseResponse.error((IError)EHErrorEnum.SAME_NAME_GROUP_EXISTS);
        }
        DocRelationGroupEntity relationGroupEntity = new DocRelationGroupEntity();
        BeanUtils.copyProperties((Object)reqVo, (Object)relationGroupEntity);
        relationGroupEntity.setStatus(Byte.valueOf((byte)1));
        relationGroupEntity.setIsDefault(Byte.valueOf((byte)0));
        int insert = this.docRelationGroupMapper.insertSelective(relationGroupEntity);
        if (insert != 1) {
            return BaseResponse.error((IError)EHErrorEnum.ADD_GROUP_FAIL);
        }
        DocRelationGroupRespVo respVo = new DocRelationGroupRespVo();
        BeanUtils.copyProperties((Object)relationGroupEntity, (Object)respVo);
        return BaseResponse.success((Object)respVo);
    }

    public BaseResponse<List<DocRelationGroupRespVo>> getDocRelationGroupList(Long doctorId, String appCode) {
        List groupData = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        List defaultGroupList = groupData.stream().filter(item -> item.getIsDefault().intValue() == 1).collect(Collectors.toList());
        if (defaultGroupList.isEmpty()) {
            DocRelationGroupEntity defaultRelationGroup = this.createDefaultRelationGroup(doctorId, appCode);
            groupData.add(defaultRelationGroup);
        }
        ArrayList resultData = new ArrayList();
        groupData.stream().map(group -> {
            DocRelationGroupRespVo respVo = new DocRelationGroupRespVo();
            BeanUtils.copyProperties((Object)group, (Object)respVo);
            return respVo;
        }).forEach(resultData::add);
        return BaseResponse.success(resultData);
    }

    public BaseResponse deleteDocRelationGroup(Long groupId) {
        DocRelationGroupEntity relationGroup = this.docRelationGroupMapper.selectByPrimaryKey(groupId);
        if (Objects.isNull(relationGroup)) {
            return BaseResponse.error((IError)EHErrorEnum.GROUP_NON_EXISTENT);
        }
        if (relationGroup.getIsDefault() == 1) {
            return BaseResponse.error((IError)EHErrorEnum.DEFAULT_CONCERNS_GROUP);
        }
        List groupPatient = this.docPatientRelationMapper.getGroupPatient(groupId, Byte.valueOf((byte)2), 1);
        if (!groupPatient.isEmpty()) {
            QueryRelationGroupVo queryGroupVo = new QueryRelationGroupVo();
            queryGroupVo.setAppCode(relationGroup.getAppCode());
            queryGroupVo.setDoctorId(relationGroup.getDoctorId());
            queryGroupVo.setIsDefault(Integer.valueOf(1));
            queryGroupVo.setStatus(Integer.valueOf(1));
            DocRelationGroupEntity defaultRelationGroup = this.getDocDefaultRelationGroup(queryGroupVo);
            List recordIdList = groupPatient.stream().map(DocPatientRelationEntity::getId).collect(Collectors.toList());
            int moveCount = this.docPatientRelationMapper.movePatientToDefaultGroup(recordIdList, defaultRelationGroup.getId());
            log.info("\u5220\u9664\u5206\u7ec4\u5b58\u5728\u60a3\u8005,\u79fb\u52a8\u5230\u9ed8\u8ba4\u5206\u7ec4,\u79fb\u52a8\u60a3\u8005\u6570\u91cf:{}", (Object)moveCount);
        }
        DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
        docRelationGroupEntity.setId(groupId);
        docRelationGroupEntity.setStatus(Byte.valueOf((byte)-1));
        int update = this.docRelationGroupMapper.updateByPrimaryKeySelective(docRelationGroupEntity);
        return BaseResponse.success((Object)update);
    }

    private DocRelationGroupEntity createDefaultRelationGroup(Long doctorId, String appCode) {
        DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
        docRelationGroupEntity.initDefaultGroup();
        docRelationGroupEntity.setAppCode(appCode);
        docRelationGroupEntity.setDoctorId(doctorId);
        this.docRelationGroupMapper.insertSelective(docRelationGroupEntity);
        return docRelationGroupEntity;
    }

    public BaseResponse updateRelationGroupName(Long groupId, String groupName) {
        DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
        docRelationGroupEntity.setId(groupId);
        docRelationGroupEntity.setName(groupName);
        int update = this.docRelationGroupMapper.updateByPrimaryKeySelective(docRelationGroupEntity);
        return BaseResponse.success((Object)update);
    }

    public BaseResponse<DocRelationGroupRespVo> addDocRelationGroupNew(DocRelationGroupReqVo docRelationGroupReqVo) {
        DocRelationGroupEntity docRelationGroup = this.docRelationGroupMapper.getByNameAndDoctor(docRelationGroupReqVo.getAppCode(), docRelationGroupReqVo.getDoctorId(), docRelationGroupReqVo.getName(), 1);
        if (Objects.nonNull(docRelationGroup)) {
            return BaseResponse.error((IError)EHErrorEnum.SAME_NAME_GROUP_EXISTS);
        }
        DocRelationGroupEntity relationGroupEntity = new DocRelationGroupEntity();
        BeanUtils.copyProperties((Object)docRelationGroupReqVo, (Object)relationGroupEntity);
        relationGroupEntity.setStatus(Byte.valueOf((byte)1));
        relationGroupEntity.setIsDefault(Byte.valueOf((byte)0));
        if (StringUtils.isEmpty((String)docRelationGroupReqVo.getSeq())) {
            relationGroupEntity.setSeq(Byte.valueOf((byte)3));
        } else {
            relationGroupEntity.setSeq(Byte.valueOf(Byte.parseByte(docRelationGroupReqVo.getSeq())));
        }
        int insert = this.docRelationGroupMapper.insertSelective(relationGroupEntity);
        if (insert != 1) {
            return BaseResponse.error((IError)EHErrorEnum.ADD_GROUP_FAIL);
        }
        DocRelationGroupRespVo respVo = new DocRelationGroupRespVo();
        BeanUtils.copyProperties((Object)relationGroupEntity, (Object)respVo);
        return BaseResponse.success((Object)respVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<List<DocRelationGroupRespVo>> getDocRelationGroupListNew(Long doctorId, String appCode) {
        List groupData = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        List defaultGroupList = groupData.stream().filter(item -> item.getIsDefault().intValue() == 1).collect(Collectors.toList());
        if (defaultGroupList.isEmpty()) {
            List defaultRelationGroup = this.createDefaultRelationGroupNew(doctorId, appCode);
            for (DocRelationGroupEntity docRelationGroupEntity : defaultRelationGroup) {
                groupData.add(docRelationGroupEntity);
            }
        }
        ArrayList resultData = new ArrayList();
        groupData.stream().map(group -> {
            DocRelationGroupRespVo respVo = new DocRelationGroupRespVo();
            BeanUtils.copyProperties((Object)group, (Object)respVo);
            return respVo;
        }).forEach(resultData::add);
        return BaseResponse.success(resultData);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteDocRelationGroupNew(Long groupId) {
        DocRelationGroupEntity relationGroup = this.docRelationGroupMapper.selectByPrimaryKey(groupId);
        if (Objects.isNull(relationGroup)) {
            return BaseResponse.error((IError)EHErrorEnum.GROUP_NON_EXISTENT);
        }
        if (relationGroup.getIsDefault() == 1 || relationGroup.getIsDefault() == 2) {
            return BaseResponse.error((IError)EHErrorEnum.DEFAULT_CONCERNS_GROUP);
        }
        List groupPatient = this.docPatientRelationMapper.getGroupPatient(groupId, Byte.valueOf((byte)2), 1);
        if (!groupPatient.isEmpty()) {
            QueryRelationGroupVo queryGroupVo = new QueryRelationGroupVo();
            queryGroupVo.setAppCode(relationGroup.getAppCode());
            queryGroupVo.setDoctorId(relationGroup.getDoctorId());
            queryGroupVo.setIsDefault(Integer.valueOf(1));
            queryGroupVo.setStatus(Integer.valueOf(1));
            DocRelationGroupEntity defaultRelationGroup = this.getDocDefaultRelationGroup(queryGroupVo);
            List recordIdList = groupPatient.stream().map(DocPatientRelationEntity::getId).collect(Collectors.toList());
            int moveCount = this.docPatientRelationMapper.movePatientToDefaultGroup(recordIdList, defaultRelationGroup.getId());
            log.info("\u5220\u9664\u5206\u7ec4\u5b58\u5728\u60a3\u8005,\u79fb\u52a8\u5230\u9ed8\u8ba4\u5206\u7ec4,\u79fb\u52a8\u60a3\u8005\u6570\u91cf:{}", (Object)moveCount);
        }
        DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
        docRelationGroupEntity.setId(groupId);
        docRelationGroupEntity.setStatus(Byte.valueOf((byte)-1));
        int update = this.docRelationGroupMapper.updateByPrimaryKeySelective(docRelationGroupEntity);
        return BaseResponse.success((Object)update);
    }

    public BaseResponse updateRelationGroupNameNew(Long groupId, String groupName) {
        DocRelationGroupEntity docRelationGroupEntityDb = this.docRelationGroupMapper.selectByPrimaryKey(groupId);
        if (docRelationGroupEntityDb.getIsDefault() != 0) {
            return BaseResponse.error((IError)EHErrorEnum.DEFAULT_CONCERNS_GROUP);
        }
        DocRelationGroupEntity docRelationGroup = this.docRelationGroupMapper.getByNameAndDoctor(docRelationGroupEntityDb.getAppCode(), docRelationGroupEntityDb.getDoctorId(), groupName, 1);
        if (Objects.nonNull(docRelationGroup)) {
            return BaseResponse.error((IError)EHErrorEnum.SAME_NAME_GROUP_EXISTS);
        }
        DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
        docRelationGroupEntity.setId(groupId);
        docRelationGroupEntity.setName(groupName);
        this.docRelationGroupMapper.updateByPrimaryKeySelective(docRelationGroupEntity);
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse sortRelationGroup(List<Long> groupIdList) {
        byte seq = 1;
        for (int i = 0; i < groupIdList.size(); ++i) {
            DocRelationGroupEntity docRelationGroupEntity = new DocRelationGroupEntity();
            docRelationGroupEntity.setId(groupIdList.get(i));
            docRelationGroupEntity.setSeq(Byte.valueOf(seq));
            this.docRelationGroupMapper.updateByPrimaryKeySelective(docRelationGroupEntity);
            seq = (byte)(seq + 1);
        }
        return BaseResponse.success();
    }

    public BaseResponse<DocRelationGroupEntity> getDoctorDefaultGroup(Long doctorId, String appCode) {
        QueryRelationGroupVo queryRelationGroupVo = new QueryRelationGroupVo();
        queryRelationGroupVo.setAppCode(appCode);
        queryRelationGroupVo.setDoctorId(doctorId);
        queryRelationGroupVo.setStatus(Integer.valueOf(1));
        queryRelationGroupVo.setIsDefault(Integer.valueOf(1));
        DocRelationGroupEntity docDefaultRelationGroup = this.docRelationGroupMapper.getDocDefaultRelationGroup(queryRelationGroupVo);
        return BaseResponse.success((Object)docDefaultRelationGroup);
    }

    public BaseResponse<DocRelationGroupRespVo> getChronicGroup(Long doctorId, String appCode) {
        List groupData = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        if (CollectionUtils.isEmpty((Collection)groupData)) {
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
        DocRelationGroupRespVo docRelationGroupRespVo = new DocRelationGroupRespVo();
        for (DocRelationGroupEntity groupDatum : groupData) {
            if (!"\u6162\u75c5\u7ba1\u7406".equals(groupDatum.getName())) continue;
            BeanUtils.copyProperties((Object)groupDatum, (Object)docRelationGroupRespVo);
            return BaseResponse.success((Object)docRelationGroupRespVo);
        }
        DocRelationGroupEntity docRelationMyPatientGroupEntity = new DocRelationGroupEntity();
        docRelationMyPatientGroupEntity.initDefaultChronicOnGroup();
        docRelationMyPatientGroupEntity.setAppCode(appCode);
        docRelationMyPatientGroupEntity.setDoctorId(doctorId);
        Integer id = this.docRelationGroupMapper.insertSelective(docRelationMyPatientGroupEntity);
        docRelationMyPatientGroupEntity.setId(Long.valueOf(id.longValue()));
        BeanUtils.copyProperties((Object)docRelationMyPatientGroupEntity, (Object)docRelationGroupRespVo);
        return BaseResponse.success((Object)docRelationGroupRespVo);
    }

    private List<DocRelationGroupEntity> createDefaultRelationGroupNew(Long doctorId, String appCode) {
        ArrayList<DocRelationGroupEntity> docRelationGroupEntityList = new ArrayList<DocRelationGroupEntity>();
        try {
            DocRelationGroupEntity docRelationMyPatientGroupEntity = new DocRelationGroupEntity();
            docRelationMyPatientGroupEntity.initDefaultMyPatientGroup();
            docRelationMyPatientGroupEntity.setAppCode(appCode);
            docRelationMyPatientGroupEntity.setDoctorId(doctorId);
            this.docRelationGroupMapper.insertSelective(docRelationMyPatientGroupEntity);
            docRelationGroupEntityList.add(docRelationMyPatientGroupEntity);
            DocRelationGroupEntity docRelationFucosOnGroupEntity = new DocRelationGroupEntity();
            docRelationFucosOnGroupEntity.initDefaultFocusOnGroup();
            docRelationFucosOnGroupEntity.setAppCode(appCode);
            docRelationFucosOnGroupEntity.setDoctorId(doctorId);
            this.docRelationGroupMapper.insertSelective(docRelationFucosOnGroupEntity);
            docRelationGroupEntityList.add(docRelationFucosOnGroupEntity);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u521d\u59cb\u5206\u7ec4\u5931\u8d25!!!");
            throw new RuntimeException(e.getMessage());
        }
        return docRelationGroupEntityList;
    }

    public DocRelationGroupEntity getDocDefaultRelationGroup(QueryRelationGroupVo queryGroupVo) {
        DocRelationGroupEntity defaultRelationGroup = this.docRelationGroupMapper.getDocDefaultRelationGroup(queryGroupVo);
        if (Objects.isNull(defaultRelationGroup)) {
            defaultRelationGroup = this.createDefaultRelationGroup(queryGroupVo.getDoctorId(), queryGroupVo.getAppCode());
        }
        return defaultRelationGroup;
    }
}

