/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctor.basedata.api.vo.GetOrganByParamDto;
import com.doctoruser.api.pojo.base.dto.orgnazition.ListDeptDoctorDTO;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.entity.StandardDepartmentEntity;
import com.doctoruser.api.pojo.base.vo.OrganizationEntity;
import com.doctoruser.api.pojo.base.vo.OrganizationVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorDetailsVO;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorListInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.api.pojo.base.vo.organization.ListOrganParamVO;
import com.doctoruser.api.pojo.base.vo.organization.OrganizationVO;
import com.doctoruser.api.pojo.base.vo.standardept.StandardDeptVO;
import com.doctoruser.api.pojo.dto.organization.DeptByParamDTO;
import com.doctoruser.api.pojo.dto.organization.DoctorByParamDTO;
import com.doctoruser.api.pojo.dto.organization.OrganizationByParamDTO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.mapper.DepartmentStandardMapper;
import com.doctoruser.doctor.mapper.DocDepartmentMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.vo.OrganizationInfoVo;
import com.doctoruser.doctor.pojo.vo.PlatformOrganizationVo;
import com.doctoruser.doctor.service.IOrganInfoService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganInfoServiceImpl
implements IOrganInfoService {
    private static final Logger log = LoggerFactory.getLogger(OrganInfoServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private DocDepartmentMapper docDepartmentMapper;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private DepartmentStandardMapper departmentStandardMapper;

    public List<OrganWorkingServiceEntity> queryOrganServiceByOrganId(String organId) {
        return this.organWorkingServiceMapper.queryOrganServiceByOrganId(organId, String.valueOf(1));
    }

    public List<OrganizationVo> queryOrganization(OrganizationByParamDTO dto) {
        return this.organizationMapper.selectByParam(dto);
    }

    public List<StandardDeptResVO> queryStandDeptByOrganId(int organId, String standName) {
        List departmentVOS = this.docDepartmentMapper.queryDeptByOrganId(organId, standName, null);
        ArrayList<StandardDeptResVO> deptResVOList = new ArrayList<StandardDeptResVO>();
        if (departmentVOS.isEmpty()) {
            return deptResVOList;
        }
        Map<Integer, List<DepartmentVO>> listMap = departmentVOS.stream().collect(Collectors.groupingBy(DepartmentVO::getFirstDeptId));
        ArrayList<Integer> stdDeptIds = new ArrayList<Integer>(listMap.keySet());
        List stdDeptList = this.departmentStandardMapper.selectOrderByOrganSeq(stdDeptIds, Long.valueOf(organId));
        for (StandardDepartmentEntity standardDepartmentEntity : stdDeptList) {
            StandardDeptResVO standardDeptResVOS = new StandardDeptResVO();
            standardDeptResVOS.setDisplayName(standardDepartmentEntity.getDisplayName());
            standardDeptResVOS.setShortName(standardDepartmentEntity.getShortName());
            standardDeptResVOS.setIconUrl(standardDepartmentEntity.getIconUrl());
            int stdDeptId = Integer.valueOf(standardDepartmentEntity.getxId());
            standardDeptResVOS.setStandDeptId(stdDeptId);
            standardDeptResVOS.setStatus(standardDepartmentEntity.getStatus());
            standardDeptResVOS.setEnglishName(standardDepartmentEntity.getEnglishName());
            List<DepartmentVO> departmentVOList = listMap.get(stdDeptId);
            for (DepartmentVO departmentVO : departmentVOList) {
                StandardDeptResVO deptResVO = this.docDepartmentMapper.queryFirstDeptById(departmentVO.getSecondDeptId());
                departmentVO.setSecondDeptName(deptResVO.getDisplayName());
                departmentVO.setFirstDeptName(standardDeptResVOS.getDisplayName());
            }
            standardDeptResVOS.setDeptList(departmentVOList);
            deptResVOList.add(standardDeptResVOS);
        }
        return deptResVOList;
    }

    public List<DepartmentVO> listNetworkClinicDepartment(String organId) {
        return this.docDepartmentMapper.listNetWorkDeptInfo(organId);
    }

    public BaseResponse<PageResult<OrganizationVO>> fuzzyQueryOrganizationsPage(ListOrganParamVO param) {
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        Page info = this.organizationMapper.fuzzyQueryOrganizationsPage(param);
        if (info.isEmpty()) {
            return BaseResponse.success((Object)result);
        }
        result.setContent(info.getResult());
        result.setPageNum(info.getPageNum());
        result.setPageSize(info.getPageSize());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public List<DepartmentVO> queryDeptByParam(DeptByParamDTO dto) {
        return this.docDepartmentMapper.queryDeptByParam(dto);
    }

    public List<DoctorDetailsVO> listDeptDoctorInfo(DoctorByParamDTO dto) {
        return this.doctorMapper.listDoctorByParam(dto);
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> pageListDeptDoctorInfo(ListDeptDoctorDTO dto) {
        PageResult result = new PageResult();
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        Page info = this.doctorMapper.pageListDoctorByParam(dto);
        if (info.isEmpty()) {
            return BaseResponse.success((Object)result);
        }
        result.setContent(info.getResult());
        result.setPageNum(info.getPageNum());
        result.setPageSize(info.getPageSize());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<DoctorListInfoVO>> queryDoctorInfoByDeptId(int deptId, String doctorName) {
        List doctorDetailsInfoBOS = this.docDepartmentMapper.queryDoctorInfoByDeptId(deptId, doctorName);
        if (doctorDetailsInfoBOS.isEmpty()) {
            return BaseResponse.success(null);
        }
        ArrayList doctorBaseInfoVOS = new ArrayList();
        doctorDetailsInfoBOS.forEach(e -> {
            DoctorListInfoVO doctorListInfoVO = new DoctorListInfoVO();
            BeanUtils.copyProperties((Object)e, (Object)doctorListInfoVO);
            doctorBaseInfoVOS.add(doctorListInfoVO);
        });
        return BaseResponse.success(doctorBaseInfoVOS);
    }

    public StandDeptInfoVO queryStandDeptInfoById(int standDeptId) {
        StandardDeptVO standardDeptVO = this.docDepartmentMapper.queryStandDeptInfoById(standDeptId);
        StandDeptInfoVO resVo = new StandDeptInfoVO();
        if (standardDeptVO != null) {
            BeanUtils.copyProperties((Object)standardDeptVO, (Object)resVo);
        }
        return resVo;
    }

    public BaseResponse<OrganizationEntity> getOrganInfoById(Long organId) {
        com.doctoruser.doctor.pojo.entity.OrganizationEntity organizationEntity = (com.doctoruser.doctor.pojo.entity.OrganizationEntity)this.organizationMapper.selectById((Serializable)organId);
        OrganizationEntity organization = new OrganizationEntity();
        if (Objects.nonNull(organizationEntity)) {
            BeanUtils.copyProperties((Object)organizationEntity, (Object)organization);
            return BaseResponse.success((Object)organization);
        }
        return BaseResponse.success(null);
    }

    public BaseResponse<List<OrganizationVo>> getOrganInfoByIds(String appCode, List<String> organIdList) {
        if (organIdList.isEmpty()) {
            OrganizationByParamDTO param = new OrganizationByParamDTO();
            param.setAppCode(appCode);
            param.setOrganType(Integer.valueOf(1));
            List organizationVos = this.organizationMapper.selectByParam(param);
            return BaseResponse.success((Object)organizationVos);
        }
        List organInfoList = this.organizationMapper.getOrganInfoByIds(appCode, organIdList);
        return BaseResponse.success((Object)organInfoList);
    }

    public BaseResponse savePlatformOrganization(PlatformOrganizationVo platformOrganizationVo) {
        com.doctoruser.doctor.pojo.entity.OrganizationEntity organization = this.organizationMapper.getOrganByName(platformOrganizationVo.getOrganName(), "1,2");
        if (Objects.nonNull(organization)) {
            return BaseResponse.error((IError)EHErrorEnum.ORGAN_NAME_EXISTS);
        }
        com.doctoruser.doctor.pojo.entity.OrganizationEntity organizationEntity = new com.doctoruser.doctor.pojo.entity.OrganizationEntity();
        organizationEntity.setOrganName(platformOrganizationVo.getOrganName());
        organizationEntity.setLogo(platformOrganizationVo.getLogo());
        organizationEntity.setLevel(platformOrganizationVo.getLevel());
        organizationEntity.setLevelName(platformOrganizationVo.getLevelName());
        organizationEntity.setOrganCategory(platformOrganizationVo.getOrganCategory());
        organizationEntity.setCategoryName(platformOrganizationVo.getCategoryName());
        organizationEntity.setAppCode(platformOrganizationVo.getAppCode());
        organizationEntity.setProvince(platformOrganizationVo.getProvince());
        organizationEntity.setCity(platformOrganizationVo.getCity());
        organizationEntity.setCreateTime(new Date());
        organizationEntity.setUpdateTime(new Date());
        organizationEntity.setOrganAddress(platformOrganizationVo.getAddress());
        organizationEntity.setDistrict(platformOrganizationVo.getDistrict());
        organizationEntity.setAddress(platformOrganizationVo.getAddress());
        organizationEntity.setStatus(Integer.valueOf(1));
        organizationEntity.setLongitude(platformOrganizationVo.getLongitude());
        organizationEntity.setLatitude(platformOrganizationVo.getLatitude());
        int insert = this.organizationMapper.insertSelective(organizationEntity);
        if (insert != 0) {
            organizationEntity.setOrganCode(String.valueOf(organizationEntity.getId()));
            int update = this.organizationMapper.updateByPrimaryKeySelective(organizationEntity);
            return BaseResponse.success((Object)update);
        }
        return BaseResponse.error((IError)EHErrorEnum.ADD_ORGAN_FAIL);
    }

    public List<OrganizationInfoVo> queryOrganizationListIteration(GetOrganByParamDto dto) {
        return this.organizationMapper.selectOpenServiceOrganIteration(dto);
    }

    public List<OrganizationVo> queryOrganizationList(OrganizationByParamDTO dto) {
        return this.organizationMapper.selectOpenServiceOrgan(dto);
    }
}

