/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUtils {
    private static final Logger log = LoggerFactory.getLogger(DataUtils.class);
    public static final String DEFALT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_CHANGE = "\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38";

    public static String getWeek(String time) {
        SimpleDateFormat format = new SimpleDateFormat(DEFALT_DATE_FORMAT);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(time));
        }
        catch (ParseException e) {
            log.error(TIME_CHANGE, (Throwable)e);
        }
        c.add(5, -6);
        Date y = c.getTime();
        return format.format(y);
    }

    public static String getLastDay(String time) {
        SimpleDateFormat format = new SimpleDateFormat(DEFALT_DATE_FORMAT);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(time));
        }
        catch (ParseException e) {
            log.error(TIME_CHANGE, (Throwable)e);
        }
        c.add(5, -1);
        Date y = c.getTime();
        return format.format(y);
    }

    public static String getLastThreeMonthDay(String time) {
        SimpleDateFormat format = new SimpleDateFormat(DEFALT_DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(time));
        }
        catch (ParseException e) {
            log.error(TIME_CHANGE, (Throwable)e);
        }
        calendar.add(2, -3);
        Date y = calendar.getTime();
        return format.format(y);
    }

    public static String getLastThreeDay(String time) {
        SimpleDateFormat format = new SimpleDateFormat(DEFALT_DATE_FORMAT);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(time));
        }
        catch (ParseException e) {
            log.error(TIME_CHANGE, (Throwable)e);
        }
        c.add(5, -2);
        Date y = c.getTime();
        return format.format(y);
    }

    public static String getLastSevenDay(String time) {
        SimpleDateFormat format = new SimpleDateFormat(DEFALT_DATE_FORMAT);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(time));
        }
        catch (ParseException e) {
            log.error(TIME_CHANGE, (Throwable)e);
        }
        c.add(5, -7);
        Date y = c.getTime();
        return format.format(y);
    }
}

