/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.aop;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    @Pointcut(value="execution(public * com.doctoruser.doctor.controller..*.*(..))")
    public void pointcut() {
        log.debug("");
    }

    @Before(value="pointcut()")
    public void doBefore(JoinPoint joinPoint) {
        this.startTime.set(System.currentTimeMillis());
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        log.info("Request URL: " + request.getRequestURL().toString());
        log.info("Request Method: " + request.getMethod());
        log.info("User-Agent: " + request.getHeader("User-Agent"));
        log.info("Class Method: " + joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName());
        log.info("Cookies: " + request.getCookies());
        log.info("Params: " + Arrays.toString(joinPoint.getArgs()));
    }

    @AfterReturning(returning="ret", pointcut="pointcut()")
    public void doAfterReturning(Object ret) {
        log.info("\u8017\u65f6 : " + (System.currentTimeMillis() - (Long)this.startTime.get()) + "ms");
        log.info("Response: " + ret);
        log.info("AppLogAspect.doAfterReturning()");
    }
}

