/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.DepartmentInfoApi;
import com.doctor.basedata.api.vo.ClassifyReqVO;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.DepartmentRespVO;
import com.doctor.basedata.api.vo.DepartmentRespVO2;
import com.doctor.basedata.api.vo.DeptWebPageBoxReqVO;
import com.doctor.basedata.api.vo.GetStandDeptVo;
import com.doctor.basedata.api.vo.UpdateDeptReqVO;
import com.doctoruser.api.DepartmentApi;
import com.doctoruser.api.pojo.base.dto.OrganCodeReq;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.dto.dept.FetchAdvisoryDeptReq;
import com.doctoruser.api.pojo.base.dto.dept.SynHisDeptReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.FetchAdvisoryDeptRes;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.vo.DeptDeleteReqVO;
import com.doctoruser.api.pojo.vo.StdFirstDeptRespVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListStdDeptVO;
import com.doctoruser.api.pojo.vo.basedata.organization.StdSecondDeptVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.pojo.vo.DepartmentLabelVo;
import com.doctoruser.doctor.pojo.vo.OrganDeptReqVo;
import com.doctoruser.doctor.pojo.vo.OrganDeptSaveReqVo;
import com.doctoruser.doctor.pojo.vo.SortDepartmentVo;
import com.doctoruser.doctor.pojo.vo.StandardDepartmentVo;
import com.doctoruser.doctor.service.DepartmentService;
import com.doctoruser.doctor.service.IOrganizationService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u9662\u79d1\u5ba4\u63a5\u53e3"})
public class DepartmentController
implements DepartmentApi,
DepartmentInfoApi {
    @Autowired
    private DepartmentService deptService;
    @Autowired
    private IOrganizationService organizationService;

    public BaseResponse<List<DepartmentEntity>> findPopByOrganCode(@RequestBody OrganCodeReq reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getOrganCode())) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        return this.deptService.findPopByOrganCode(reqVo);
    }

    public BaseResponse<List<DepartmentEntity>> listAllOrganDept(@RequestBody OrganIdReq req) {
        if (StringUtils.isEmpty((Object)req.getOrganCode()) && StringUtils.isEmpty((Object)req.getOrganId())) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        return this.deptService.listAllDeptByOrganId(req.getOrganId(), req.getOrganCode());
    }

    public BaseResponse<List<FetchAdvisoryDeptRes>> fetchAdvisoryDept(@RequestBody FetchAdvisoryDeptReq param) {
        return this.deptService.fetchAdvisoryDept(param);
    }

    public BaseResponse<List<OrganDeptInfoVO>> listOrganDept(@RequestBody OrganIdReq req) {
        return this.deptService.listOrganDept(req);
    }

    public BaseResponse<Object> synchronizeHisDeptInfo(@RequestBody SynHisDeptReq synHisDeptReq) {
        return this.deptService.synchronizeHisDeptInfo(synHisDeptReq);
    }

    public BaseResponse<List<DepartmentEntity>> getHotDepartmentList(Long organId) {
        return this.deptService.getHotDepartmentList(organId);
    }

    @PostMapping(value={"/save_organ_department"})
    @ApiOperation(value="\u4fdd\u5b58\u533b\u9662\u79d1\u5ba4\u4fe1\u606f")
    @Deprecated
    public BaseResponse saveOrganDepartment(@RequestBody OrganDeptReqVo organDeptReqVo) {
        return this.deptService.saveOrganDepartment(organDeptReqVo);
    }

    @GetMapping(value={"/get_dept_by_second_std_dept"})
    @ApiOperation(value="\u6839\u636e\u4e8c\u7ea7\u6807\u79d1\u67e5\u8be2\u533b\u9662\u79d1\u5ba4")
    public BaseResponse getOrganDeptBySecondStdDeptId(@RequestParam(value="organId") Long organId, @RequestParam(value="secondStdDeptId") Long secondStdDeptId) {
        return this.deptService.getOrganDeptBySecondStdDeptId(organId, secondStdDeptId);
    }

    @GetMapping(value={"/get_std_first_dept"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u4e0b\u6240\u6709\u4e00\u7ea7\u79d1\u5ba4", notes="\u67e5\u8be2\u533b\u9662\u4e0b\u6240\u6709\u4e00\u7ea7\u79d1\u5ba4")
    public BaseResponse<List<StdFirstDeptRespVO>> getStdFirstDeptByOrganId(@RequestParam(value="organId") Long organId) {
        return this.deptService.getStdFirstDeptByOrganId(organId);
    }

    @PostMapping(value={"/delete_organ_department"})
    @ApiOperation(value="\u5220\u9664\u533b\u9662\u79d1\u5ba4\u4fe1\u606f-\u8d85\u7ba1\u63a5\u53e3")
    public BaseResponse<String> deleteDeptById(@RequestBody DeptDeleteReqVO reqVO) {
        return this.deptService.deleteDeptById(reqVO);
    }

    @PostMapping(value={"/sort_organ_department"})
    @ApiOperation(value="\u533b\u9662\u79d1\u5ba4\u6392\u5e8f\u63a5\u53e3")
    public BaseResponse sortOrganDepartment(@RequestBody SortDepartmentVo sortDepartmentVo) {
        return this.deptService.sortOrganDepartment(sortDepartmentVo);
    }

    @PostMapping(value={"/save_department_label"})
    @ApiOperation(value="\u79d1\u5ba4\u6807\u7b7e\u4fdd\u5b58\u63a5\u53e3")
    public BaseResponse saveDepartmentLabel(@RequestBody DepartmentLabelVo departmentLabelVo) {
        return this.deptService.saveDepartmentLabel(departmentLabelVo);
    }

    @GetMapping(value={"/getDepartmentById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f")
    public BaseResponse<DepartmentEntity> getDepartmentById(@RequestParam(value="deptId") Long deptId) {
        return this.deptService.getDepartmentById(deptId);
    }

    @GetMapping(value={"/getDepartmentByName"})
    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f")
    public BaseResponse<StandardDepartmentVo> getDepartmentByName(@RequestParam(value="deptName") String deptName) {
        return this.deptService.getDepartmentByName(deptName);
    }

    public BaseResponse<DepartmentDetailVo> getDepartmentDetail(@RequestParam(value="deptId") Long deptId) {
        return this.deptService.getDepartmentDetail(deptId);
    }

    @ApiOperation(value="\u901a\u8fc7\u81ea\u5b9a\u4e49\u5206\u7c7b\u67e5\u8be2\u79d1\u5ba4", notes="\u901a\u8fc7\u81ea\u5b9a\u4e49\u5206\u7c7b\u67e5\u8be2\u79d1\u5ba4")
    @RequestMapping(value={"/findDeptByClassifyReqVO"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<DepartmentRespVO2>> findDeptByClassifyReqVO(@RequestBody @Validated ClassifyReqVO classifyReqVO) {
        PageResult pageResult = this.deptService.findDeptByClassifyReqVO(classifyReqVO);
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<List<DepartmentRespVO>> findDeptWebPageBoxList(@RequestBody @Validated DeptWebPageBoxReqVO deptWebPageBoxReqVO) {
        List departmentRespVOList = this.deptService.findDeptWebPageBoxList(deptWebPageBoxReqVO);
        return BaseResponse.success((Object)departmentRespVOList);
    }

    @PostMapping(value={"/v2/save_organ_department"})
    @ApiOperation(value="\u4fdd\u5b58\u533b\u9662\u79d1\u5ba4\u4fe1\u606f")
    public BaseResponse saveOrganDepartment(@RequestBody OrganDeptSaveReqVo organDeptSaveReqVo) {
        return this.deptService.saveOrganDepartment(organDeptSaveReqVo);
    }

    public BaseResponse updateDept(@RequestBody @Validated UpdateDeptReqVO updateDeptReqVO) {
        return this.deptService.updateDept(updateDeptReqVO);
    }

    public BaseResponse getByOrganIdAndHosDeptId(@RequestBody @Validated GetStandDeptVo getStandDeptVo) {
        return this.deptService.getByOrganIdAndHosDeptId(getStandDeptVo);
    }

    @GetMapping(value={"/get_by_classify_code"})
    @ApiOperation(value="\u6839\u636e\u79d1\u5ba4\u5206\u7c7bcode\u67e5\u8be2\u533b\u9662\u79d1\u5ba4")
    public BaseResponse<List<FetchAdvisoryDeptRes>> getByClassifyCode(@RequestParam(value="classifyCode") String classifyCode, @RequestParam(value="organId") Long organId) {
        return this.deptService.getByClassifyCode(classifyCode, organId);
    }

    @GetMapping(value={"/get_dept_by_classify"})
    @ApiOperation(value="\u67e5\u8be2\u7279\u5b9a\u5206\u7c7b\u4e00\u7ea7\u5d4c\u5957\u533b\u9662\u79d1\u5ba4")
    public BaseResponse<List<StandardDeptResVO>> getOrganDeptByClassifyCode(@RequestParam(value="classifyCode") String classifyCode, @RequestParam(value="organId") Long organId, @RequestParam(value="likeSecondName", required=false) String likeSecondName) {
        return this.deptService.getOrganDeptByClassifyCode(classifyCode, likeSecondName, organId);
    }

    @GetMapping(value={"/get_dept_by_organId_deptName"})
    @ApiOperation(value="\u641c\u7d22\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u5217\u8868")
    public BaseResponse<List<DepartmentRespVO>> getDepyByOrganIdAndDeptName(@RequestParam(value="organId") String organId, @RequestParam(value="deptName") String deptName) {
        return this.deptService.getOrganDeptByOrganIdAndDeptName(organId, deptName);
    }

    @GetMapping(value={"/getListFirstStdDeptInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6807\u51c6\u4e00\u7ea7\u79d1\u5ba4\u5217\u8868")
    public BaseResponse<List<ListStdDeptVO>> getListFirstStdDeptInfo() {
        List listFirstStdDeptInfo = this.organizationService.getListFirstStdDeptInfo();
        return BaseResponse.success((Object)listFirstStdDeptInfo);
    }

    @GetMapping(value={"/getListSecondStdDeptInfoByRelDeptId"})
    @ApiOperation(value="\u6839\u636e\u4e00\u7ea7\u6807\u51c6\u79d1\u5ba4\u83b7\u53d6\u6807\u51c6\u4e8c\u7ea7\u79d1\u5ba4\u5217\u8868")
    BaseResponse<List<StdSecondDeptVO>> getListSecondStdDeptInfoByRelDeptId(@RequestParam(value="relDeptId") Integer relDeptId) {
        List listSecondStdDeptInfoByRelDeptId = this.organizationService.getListSecondStdDeptInfoByRelDeptId(relDeptId);
        return BaseResponse.success((Object)listSecondStdDeptInfoByRelDeptId);
    }

    @GetMapping(value={"/getListSecondStdDeptInfo"})
    @ApiOperation(value="\u641c\u7d22\u4e8c\u7ea7\u79d1\u5ba4\u5217\u8868")
    public BaseResponse<List<StdSecondDeptVO>> getListSecondStdDeptInfo(@RequestParam(value="search", required=false) String search) {
        List listSecondStdDeptInfo = this.organizationService.getListSecondStdDeptInfo(search);
        return BaseResponse.success((Object)listSecondStdDeptInfo);
    }
}

