/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.DoctorBaseApi;
import com.doctor.basedata.api.vo.BaseDoctorInfoRespVO;
import com.doctor.basedata.api.vo.DoctorInfoHomeVo;
import com.doctor.basedata.api.vo.DoctorPostRepVO;
import com.doctor.basedata.api.vo.GetBusinessDoctorListVo;
import com.doctor.basedata.api.vo.RetBusinessDoctorListVo;
import com.doctoruser.api.DoctorApi;
import com.doctoruser.api.pojo.base.query.BusinessDoctorListQuery;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.DoctorDictionaryQueryReq;
import com.doctoruser.api.pojo.dto.doctor.AreaInfoDTO;
import com.doctoruser.api.pojo.dto.doctor.DoctorNetworkClinicDTO;
import com.doctoruser.api.pojo.dto.doctor.DoctorSearchDTO;
import com.doctoruser.api.pojo.dto.doctor.FuzzyQueryDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.ListCityDTO;
import com.doctoruser.api.pojo.dto.doctor.ListDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.ListFamousDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.QueryDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.QueryPiontServiceDTO;
import com.doctoruser.api.pojo.dto.doctor.SaveDoctorInfoDTO;
import com.doctoruser.api.pojo.dto.doctor.UpdateBalanceDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.AreaInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorDetailVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorDetailsInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorServicesRes;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorUserInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.InDoServiceStatus;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListAreaVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListCityVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListDoctReq;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListDoctorVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListProvinceVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ManagerDoctorListVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ParentCodeVo;
import com.doctoruser.api.pojo.vo.basedata.doctor.PointDoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.UserDoctorVo;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.vo.SortOrganDoctorVo;
import com.doctoruser.doctor.service.IDoctorService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e91\u4e0a\u533b\u751f\u76f8\u5173\u63a5\u53e3"})
public class DoctorController
implements DoctorApi,
DoctorBaseApi {
    @Autowired
    private IDoctorService doctorService;

    public BaseResponse<Integer> saveDoctorInfo(@RequestBody SaveDoctorInfoDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.saveDoctorInfo(dto);
    }

    public BaseResponse<DoctorUserInfoVO> queryDoctorUserInfo(@RequestBody BaseDTO dto) {
        if (null == dto || dto.getId() == null) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorUserInfo(dto.getId());
    }

    public BaseResponse<PageResult<ListDoctorVO>> queryDoctorList(@RequestBody ListDoctorDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.listDoctorInfo(dto);
    }

    public BaseResponse<PageResult<ListDoctorVO>> queryClcDoctorList(@RequestBody ListDoctorDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.listClcDoctorInfo(dto);
    }

    public BaseResponse<List<ManagerDoctorListVO>> queryOrganDoctorList(@RequestBody BaseDTO dto) {
        if (null == dto || dto.getId() == null) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryOrganDoctorList(dto.getId());
    }

    public BaseResponse<List<ListDoctorVO>> queryDoctorListByNameOrTelphone(@RequestBody FuzzyQueryDoctorDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.fuzzyQueryDoctorList(dto);
    }

    public BaseResponse<PageResult<ListDoctorVO>> queryFamousDoctorList(@RequestBody ListFamousDoctorDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.listFamousDoctorInfo(dto);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listConsultationDoctor(@RequestBody DoctorNetworkClinicDTO dto) {
        return this.doctorService.listSurgeryDoctor(dto);
    }

    public BaseResponse<List<ListDoctorVO>> listConsultationDoctor(@RequestBody BaseDTO dto) {
        if (null == dto.getId()) {
            return BaseResponse.error((IError)EHErrorEnum.LACK_DEPT_ID);
        }
        if (null == dto.getCode() || "".equals(dto.getCode())) {
            return BaseResponse.error((IError)EHErrorEnum.LACK_QUERY_PARAMETER);
        }
        return this.doctorService.listDoctorByConsultationType(dto);
    }

    public BaseResponse<DoctorDetailVO> queryDoctorDetail(@RequestBody QueryDoctorDTO dto) {
        if (null == dto || null == dto.getDoctorId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorDetails(dto);
    }

    public BaseResponse<DoctorDetailsInfoVO> queryDoctorDetailInfo(@RequestBody QueryDoctorDTO dto) {
        if (null == dto || null == dto.getDoctorId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorDetailsInfo(dto.getDoctorId());
    }

    public BaseResponse<DoctorEntityInfoVO> endQueryDoctorDetailInfo(@RequestBody BaseDTO dto) {
        if (null == dto || null == dto.getId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorAllInfo(dto.getId());
    }

    public BaseResponse<List<Integer>> endQueryDoctorInfo(@RequestBody DoctorSearchDTO dto) {
        if (null == dto.getType()) {
            return BaseResponse.error((IError)EHErrorEnum.TYPE_NOT_NULL);
        }
        return this.doctorService.searchDoctorIds(dto);
    }

    public BaseResponse<List<ListProvinceVO>> queryRegionList() {
        return this.doctorService.queryRegionInfo();
    }

    public BaseResponse<List<ListCityVO>> queryCityList(@RequestBody ListCityDTO dto) {
        if (null == dto || null == dto.getProvinceCode()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryCityInfoByProvince(dto.getProvinceCode());
    }

    public BaseResponse<List<ListAreaVO>> queryAreaList() {
        return this.doctorService.queryAreaListInfo();
    }

    public BaseResponse<List<ListAreaVO>> queryDistrictList() {
        return this.doctorService.queryDistrictInfo();
    }

    public BaseResponse<AreaInfoVO> queryAreaNameByDistrictCode(@RequestBody AreaInfoDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryAreaByDistrictCode(dto);
    }

    public BaseResponse<List<DoctorServiceInfoVO>> queryDoctorServiceInfo(@RequestBody BaseDTO dto) {
        if (null == dto || null == dto.getId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorServiceInfo(dto.getId());
    }

    public BaseResponse<List<PointDoctorServiceInfoVO>> queryDoctorPointServiceInfo(@RequestBody List<QueryPiontServiceDTO> dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.queryDoctorServInfoByServCode(dto);
    }

    public BaseResponse<String> synchronousDoctorData() {
        return null;
    }

    public BaseResponse<String> updateDoctorBalance(@RequestBody UpdateBalanceDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.updateDoctorBalanceInfo(dto);
    }

    public BaseResponse<List<DoctorServicesRes>> queryDictionaryByParentCode(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="parentCode") String parentCode) {
        return this.doctorService.queryDictionaryByParentCode(doctorId, parentCode);
    }

    public BaseResponse<List<DoctorServicesRes>> queryDictionaryByParentCodev2(@RequestBody DoctorDictionaryQueryReq doctorDictionaryQueryReq) {
        if (Objects.isNull(doctorDictionaryQueryReq.getDoctorId())) {
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)doctorDictionaryQueryReq.getParentCode())) {
            return BaseResponse.error((String)"\u5b57\u5178\u7236code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.queryDictionaryByParentCode(doctorDictionaryQueryReq.getDoctorId(), doctorDictionaryQueryReq.getParentCode());
    }

    public BaseResponse<List<DoctorServicesRes>> dictionaryByParentCodeWeb(@RequestBody ParentCodeVo parentCodeVo) {
        return this.doctorService.queryDictionaryByParentCode(parentCodeVo.getDoctorId(), parentCodeVo.getParentCode());
    }

    public BaseResponse doctorServiceSynchro(@RequestBody InDoServiceStatus inDoServiceStatus) {
        if (1 != inDoServiceStatus.getStatus() && -1 != inDoServiceStatus.getStatus()) {
            return BaseResponse.error((IError)EHErrorEnum.STATUS_RANGE);
        }
        if (null == inDoServiceStatus.getDoctorId()) {
            return BaseResponse.error((IError)EHErrorEnum.DOCTOR_ID_MUST);
        }
        if (null == inDoServiceStatus.getGroupCode()) {
            return BaseResponse.error((IError)EHErrorEnum.SERVICE_CODE_MUST);
        }
        return this.doctorService.doctorServiceSynchro(inDoServiceStatus);
    }

    public BaseResponse<DoctorServiceInfoVO> queryAllServiceInfo(@RequestBody QueryPiontServiceDTO dto) {
        return this.doctorService.queryAllServiceInfo(dto);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorInfoByNameAndCode(@RequestBody ListDoctReq req) {
        return this.doctorService.getListDoctorInfoByNameAndCode(req);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCode(@RequestBody ListDoctReq req) {
        return this.doctorService.getListDoctorByNameAndCode(req);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeHy(@RequestBody ListDoctReq req) {
        return this.doctorService.getListDoctorByNameAndCodeHy(req);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listConsultationDoctorHy(@RequestBody DoctorNetworkClinicDTO dto) {
        return this.doctorService.listSurgeryDoctorHy(dto);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeNy(@RequestBody ListDoctReq req) {
        return this.doctorService.getListDoctorByNameAndCodeNy(req);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeZryh(@RequestBody ListDoctReq req) {
        return this.doctorService.getListDoctorByNameAndCodeZryh(req);
    }

    public BaseResponse<List<DoctorBasicInfoVo>> getBusinessDoctorList(@RequestBody BusinessDoctorListQuery businessDoctorListQuery) {
        if (StringUtils.isNotBlank((String)businessDoctorListQuery.getServiceCodes())) {
            List<String> serviceCodeList = Arrays.asList(businessDoctorListQuery.getServiceCodes().split(","));
            if (serviceCodeList.isEmpty()) {
                businessDoctorListQuery.setServiceCodes("");
            } else {
                String serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'"));
                businessDoctorListQuery.setServiceCodes(serviceCodes);
            }
        }
        return this.doctorService.getBusinessDoctorList(businessDoctorListQuery);
    }

    @PostMapping(value={"/sort_organ_doctor"})
    @ApiOperation(value="\u533b\u9662\u533b\u751f\u6392\u5e8f\u63a5\u53e3")
    public BaseResponse sortOrganDoctor(@RequestBody SortOrganDoctorVo sortOrganDoctorVo) {
        return this.doctorService.sortOrganDoctor(sortOrganDoctorVo);
    }

    @PostMapping(value={"/get_sorted_organ_doctor"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u533b\u751f\u6392\u5e8f\u4fe1\u606f")
    public BaseResponse<List<DoctorBasicInfoVo>> getSortedOrganDoctor(@RequestParam(value="organId") Long organId, @RequestParam(value="serviceCode") String serviceCode) {
        return this.doctorService.getSortedOrganDoctor(organId, serviceCode);
    }

    @GetMapping(value={"/get_doctor_info_home"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u4e3b\u9875\u4fe1\u606f")
    public BaseResponse<DoctorInfoHomeVo> getDoctorInfoHome(@RequestParam(value="doctorId") Long doctorId) {
        return this.doctorService.getDoctorInfoHome(doctorId);
    }

    @GetMapping(value={"/get_doctor_by_occupation"})
    @ApiOperation(value="\u67e5\u8be2\u7279\u5b9a\u804c\u4e1a\u533b\u751f")
    public BaseResponse<List<BaseDoctorInfoRespVO>> getDoctorByOccupation(@RequestParam(value="organId") Long organId, @RequestParam(value="occupationCode") String occupationCode) {
        return this.doctorService.getDoctorByOccupation(organId, occupationCode);
    }

    @GetMapping(value={"/check_health"})
    @ApiOperation(value="\u670d\u52a1\u5065\u5eb7\u68c0\u67e5")
    public BaseResponse<DoctorInfoEntity> checkHealthDocService() {
        return this.doctorService.checkHealthDocService();
    }

    public BaseResponse doctorOffline(Long id) {
        return this.doctorService.doctorOffline(id);
    }

    public BaseResponse doctorOnline(Long id) {
        return this.doctorService.doctorOnline(id);
    }

    public BaseResponse<Integer> updateInfoMsg(@RequestBody SaveDoctorInfoDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.doctorService.updateInfoMsg(dto);
    }

    @ApiOperation(value="\u533b\u751f\u662f\u5426\u9700\u8981\u8865\u5145\u4fe1\u606f\u68c0\u67e5")
    @GetMapping(value={"/doctorAddInfoCheck"})
    public BaseResponse<Boolean> doctorAddInfoCheck(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") Long organId) {
        return this.doctorService.doctorAddInfoCheck(doctorId, organId);
    }

    @ApiOperation(value="\u4e2d\u65e5\u533b\u751f\u662f\u5426\u9700\u8981\u8865\u5145\u4fe1\u606f\u68c0\u67e5")
    @GetMapping(value={"/zr/doctorAddInfoCheck"})
    public BaseResponse<Boolean> ZrDoctorAddInfoCheck(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") Long organId) {
        return this.doctorService.ZrDoctorAddInfoCheck(doctorId, organId);
    }

    public BaseResponse<BaseDoctorInfoRespVO> getDoctorInfoByCode(@RequestParam(value="doctorCode") String doctorCode, @RequestParam(value="organId") Long organId) {
        return this.doctorService.getDoctorInfoByCode(doctorCode, organId);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751fID\u83b7\u53d6\u533b\u751f\u624b\u673a\u53f7")
    @GetMapping(value={"/getDoctorPhone"})
    public BaseResponse<String> getDoctorPhone(@RequestParam(value="doctorId") Long doctorId) {
        return this.doctorService.getDoctorPhone(doctorId);
    }

    public BaseResponse<List<DoctorPostRepVO>> getDoctorPostByDoctorIds(@RequestParam(value="doctorIds") List<String> doctorIds) {
        return BaseResponse.success((Object)this.doctorService.getDoctorPostAndCreditCardByDoctorIds(doctorIds));
    }

    public BaseResponse<List<DoctorPostRepVO>> getDoctorPostByDoctorIdsIM(@RequestParam(value="doctorIds") List<String> doctorIds) {
        return BaseResponse.success((Object)this.doctorService.getDoctorPostAndCreditCardByDoctorIdsIM(doctorIds));
    }

    public BaseResponse updateDoctorPostById(@RequestParam(value="post", required=false, defaultValue="") String post, @RequestParam(value="doctorId") String doctorId, @RequestParam(value="creditCard", required=false, defaultValue="") String creditCard) {
        return this.doctorService.updateDoctorPostAndCreditCardById(post, creditCard, doctorId);
    }

    public BaseResponse<PageResult<RetBusinessDoctorListVo>> getMedicalDoctorList(@RequestBody GetBusinessDoctorListVo getBusinessDoctorListVo) {
        return this.doctorService.getMedicalDoctorList(getBusinessDoctorListVo);
    }

    public BaseResponse<PageResult<RetBusinessDoctorListVo>> getExpertsDoctorList(@RequestBody GetBusinessDoctorListVo getBusinessDoctorListVo) {
        return this.doctorService.getExpertsDoctorList(getBusinessDoctorListVo);
    }

    @GetMapping(value={"/getByHospitalDeptId"})
    @ApiOperation(value="\u540d\u533b\u699c-\u6839\u636e\u533b\u9662\u79d1\u5ba4\u83b7\u53d6\u533b\u751f\u5217\u8868\u4fe1\u606f")
    public BaseResponse getByHospitalDeptId(@RequestParam(value="hospitalDeptId") Long hospitalDeptId, @RequestParam(value="organId") Long organId, @RequestParam(value="search", required=false, defaultValue="") String search) {
        List byHospitalDeptId = this.doctorService.getByHospitalDeptId(hospitalDeptId, organId, search);
        return BaseResponse.success((Object)byHospitalDeptId);
    }
}

