/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.UcHospitalInfoApi;
import com.doctor.basedata.api.vo.UcAppCodeHospitalInfoVO;
import com.doctoruser.api.pojo.dto.UcHospitalInfoDTO;
import com.doctoruser.api.pojo.dto.UcHospitalInfoReq;
import com.doctoruser.api.pojo.dto.UpdateHospitalInfoReq;
import com.doctoruser.api.pojo.dto.organization.OrganizationByParamDTO;
import com.doctoruser.api.pojo.vo.BeanRespVO;
import com.doctoruser.api.pojo.vo.UcHospitalInfoVO;
import com.doctoruser.api.pojo.vo.pushcenter.OrganNumberVO;
import com.doctoruser.doctor.pojo.entity.UcHospitalInfoEntity;
import com.doctoruser.doctor.pojo.vo.PlatformActiveReq;
import com.doctoruser.doctor.service.UcHospitalInfoService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bca\u7597\u5e73\u53f0-\u8d85\u7ba1\u7ba1\u7406"})
public class UcHospitalInfoController
implements UcHospitalInfoApi {
    @Autowired
    private UcHospitalInfoService ucHospitalInfoService;

    @PostMapping(value={"/save_hospital"})
    @ApiOperation(value="\u6dfb\u52a0\u8bca\u7597\u5e73\u53f0", notes="\u65b0\u589e\u4e00\u4e2a\u8bca\u7597\u5e73\u53f0")
    public BaseResponse<String> saveHospitalInfo(@RequestBody UcHospitalInfoReq query) {
        return this.ucHospitalInfoService.saveHospitalInfo(query);
    }

    @GetMapping(value={"/update_status"})
    @ApiOperation(value="\u5220\u9664\u5e73\u53f0,\u6216\u4e0a\u4e0b\u7ebf\u5e73\u53f0", notes="1:\u4e0a\u7ebf,2:\u4e0b\u7ebf,-1:\u5220\u9664")
    public BaseResponse<String> deleteHospitalInfo(@RequestParam(value="hospitalId") int hospitalId, @RequestParam(value="status") int status) {
        return this.ucHospitalInfoService.updateHospitalInfoStatus(hospitalId, status);
    }

    @PostMapping(value={"/select_list"})
    @ApiOperation(value="\u6309\u6761\u4ef6\u7b5b\u9009\u5e73\u53f0\u96c6\u5408", notes="\u6309\u6761\u4ef6\u7b5b\u9009\u5e73\u53f0\u96c6\u5408")
    public BaseResponse<BeanRespVO> selectHospitalList(@RequestBody UcHospitalInfoDTO ucHospitalInfoDTO) {
        return this.ucHospitalInfoService.selectHospitalList(ucHospitalInfoDTO);
    }

    @GetMapping(value={"/get_info"})
    @ApiOperation(value="\u6839\u636e\u5e73\u53f0id\u83b7\u53d6\u5e73\u53f0\u6570\u636e", notes="\u6839\u636e\u5e73\u53f0id\u83b7\u53d6\u5e73\u53f0\u6570\u636e")
    public BaseResponse<OrganNumberVO> getTotalByAppCode(@RequestParam(value="hospitalId") Integer hospitalId) {
        return this.ucHospitalInfoService.getTotalByAppCode(hospitalId);
    }

    @PostMapping(value={"/update_info"})
    @ApiOperation(value="\u6839\u636e\u5e73\u53f0id\u4fee\u6539\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636e\u5e73\u53f0id\u4fee\u6539\u5e73\u53f0\u4fe1\u606f")
    public BaseResponse<String> updateHospitalById(@RequestBody UpdateHospitalInfoReq hospitalInfoReq) {
        return this.ucHospitalInfoService.updateHospitalById(hospitalInfoReq);
    }

    @GetMapping(value={"/query_List"})
    @ApiOperation(value="\u8d85\u7ba1\u7aef-\u4e0b\u62c9\u6846\u5e73\u53f0\u4fe1\u606f", notes="\u4e0b\u62c9\u6846\u5e73\u53f0\u4fe1\u606f")
    public BaseResponse<List<UcHospitalInfoVO>> queryHospitalList() {
        return this.ucHospitalInfoService.queryHospitalList();
    }

    @GetMapping(value={"/query_hospital_info"})
    @ApiOperation(value="\u7efc\u5408\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636eappcode,\u7efc\u5408\u5e73\u53f0\u4fe1\u606f")
    public BaseResponse<UcHospitalInfoEntity> queryHospitalInfo(@RequestParam(value="appCode") String appCode) {
        return this.ucHospitalInfoService.queryHospitalInfo(appCode);
    }

    public BaseResponse<List<UcAppCodeHospitalInfoVO>> queryAppCodeHospitalList(@RequestParam(value="cityCode", required=false) String cityCode, @RequestParam(value="serviceCode", required=false) String serviceCode, @RequestParam(value="appCode", required=false) String appCode) {
        if (StringUtils.isNotBlank((String)serviceCode)) {
            String[] split = serviceCode.split(",");
            serviceCode = Arrays.stream(split).collect(Collectors.joining("','", "'", "'"));
        }
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setCityCode(cityCode);
        dto.setServCode(serviceCode);
        dto.setAppCode(appCode);
        return this.ucHospitalInfoService.queryAppCodeHospitalList(dto);
    }

    @PostMapping(value={"/activation_platform"})
    @ApiOperation(value="\u8d85\u7ba1\u7aef-\u6fc0\u6d3b\u5e73\u53f0", notes="\u8c03\u5ea6\u4e2d\u5fc3\u914d\u7f6e\u8def\u7531")
    public BaseResponse activationPlatform(@RequestBody PlatformActiveReq platformActiveReq) {
        return this.ucHospitalInfoService.activationPlatform(platformActiveReq);
    }
}

