/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.YLTHZServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.api.pojo.vo.basedata.doctor.InDoServiceStatus;
import com.doctoruser.api.pojo.vo.basedata.doctor.ServiceCodeAndAmount;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.service.IDoctorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="51110")
public class YLTTWServiceHandler
implements DocServiceHandler {
    private final String ACCOMPANY_PRICE_CODE = "111";
    private final String SERVICE_PRICE_CODE = "101";
    @Autowired
    private IDoctorService doctorService;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        for (Long doctorId : doctorIds) {
            InDoServiceStatus inDoServiceStatus = new InDoServiceStatus();
            inDoServiceStatus.setDoctorId(doctorId);
            inDoServiceStatus.setGroupCode(serviceSetParam.getServiceCode());
            inDoServiceStatus.setStatus(Integer.valueOf(serviceSetParam.getStatus() == 0 ? -1 : 1));
            YLTHZServiceBo serviceInfo = (YLTHZServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), YLTHZServiceBo.class);
            if (Objects.isNull(serviceInfo)) {
                serviceInfo = new YLTHZServiceBo();
                serviceInfo.initZero();
            }
            ArrayList<ServiceCodeAndAmount> list = new ArrayList<ServiceCodeAndAmount>();
            ServiceCodeAndAmount serviceAmount = new ServiceCodeAndAmount();
            serviceAmount.setAmount(serviceInfo.getServicePrice());
            serviceAmount.setServiceCode("101");
            ServiceCodeAndAmount accompanyAmount = new ServiceCodeAndAmount();
            accompanyAmount.setAmount(serviceInfo.getAccompanyPrice());
            accompanyAmount.setServiceCode("111");
            list.add(accompanyAmount);
            list.add(serviceAmount);
            inDoServiceStatus.setList(list);
            this.doctorService.doctorServiceSynchro(inDoServiceStatus);
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        YLTHZServiceBo ylthzServiceBo = (YLTHZServiceBo)JSON.parseObject((String)serviceConfig, YLTHZServiceBo.class);
        if (Objects.isNull(ylthzServiceBo)) {
            return ServiceCodeEnum.YLTTWHZ.getServiceConfig();
        }
        return JSON.toJSONString((Object)ylthzServiceBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        YLTHZServiceBo ylthzServiceBo = (YLTHZServiceBo)JSON.parseObject((String)serviceConfig, YLTHZServiceBo.class);
        if (Objects.isNull(ylthzServiceBo)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return ValidPropertyUtil.validate((Object)ylthzServiceBo);
    }
}

