/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.dto.DoctorBalanceDTO;
import com.doctor.basedata.api.vo.ConsultationRemunerationReqVO;
import com.doctor.basedata.api.vo.UpdateBalanceReq;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.pojo.entity.DocBalanceLogEntity;
import com.doctoruser.doctor.service.DocBalanceOperateService;
import com.doctoruser.doctor.service.impl.DoctorServiceImpl;
import com.doctoruser.doctor.utils.RedissonLockUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocBalanceOperateServiceImpl
implements DocBalanceOperateService {
    private static final Logger log = LoggerFactory.getLogger(DocBalanceOperateServiceImpl.class);
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private DoctorServiceImpl doctorService;
    @Lazy
    @Autowired
    private RedissonClient redissonClient;
    @Lazy
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public int updateDoctorBalance(UpdateBalanceReq updateReq) {
        DoctorBalanceDTO doctorBalance = this.doctorMapper.getDocBalanceInfo(updateReq.getDoctorId());
        if (Objects.nonNull(doctorBalance)) {
            BigDecimal balance = doctorBalance.getBalance();
            balance = Objects.isNull(balance) ? BigDecimal.ZERO : balance;
            BigDecimal computeResult = balance.add(updateReq.getUpdateAmount());
            int update = this.doctorMapper.updateDoctorBalance(doctorBalance.getDoctorId(), computeResult, doctorBalance.getBalanceMark());
            DocBalanceLogEntity docBalanceLogEntity = new DocBalanceLogEntity();
            docBalanceLogEntity.setDoctorId(doctorBalance.getDoctorId());
            docBalanceLogEntity.setBalance(doctorBalance.getBalance());
            docBalanceLogEntity.setModifyBalance(computeResult);
            this.doctorService.saveDocBalanceLog(docBalanceLogEntity);
            return update;
        }
        log.error("\u533b\u751f\u4f59\u989d\u4fe1\u606f\u4e0d\u5b58\u5728");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={RuntimeException.class})
    public void transferConsultationRemuneration(ConsultationRemunerationReqVO remunerationReqVO) {
        RLock lock = null;
        try {
            lock = this.redissonClient.getLock("doctorBalanceOperateLock");
            lock.lock();
            Boolean orderExist = this.redisTemplate.opsForSet().isMember((Object)"doctorBalanceOperateSyncSet", (Object)remunerationReqVO.getOrderNo());
            if (Objects.isNull(orderExist)) {
                throw new RuntimeException("\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u4ee4\u724c\u9a8c\u8bc1\u9519\u8bef");
            }
            if (!orderExist.booleanValue()) {
                UpdateBalanceReq treatmentDoctor = new UpdateBalanceReq();
                treatmentDoctor.setDoctorId(remunerationReqVO.getTreatmentDoctorId());
                treatmentDoctor.setUpdateAmount(remunerationReqVO.getServicePrice());
                log.info("\u63a5\u8bca\u533b\u751f\u5165\u8d26\u64cd\u4f5c,\u64cd\u4f5c\u53c2\u6570{}", (Object)JSON.toJSONString((Object)treatmentDoctor));
                int treatmentResult = this.updateDoctorBalance(treatmentDoctor);
                if (treatmentResult == 0) {
                    throw new RuntimeException("\u63a5\u8bca\u533b\u751f\u5165\u8d26\u5931\u8d25");
                }
                UpdateBalanceReq accompanyDoctor = new UpdateBalanceReq();
                accompanyDoctor.setDoctorId(remunerationReqVO.getAccompanyDoctorId());
                accompanyDoctor.setUpdateAmount(remunerationReqVO.getAccompanyPrice());
                log.info("\u966a\u8bca\u533b\u751f\u5165\u8d26\u64cd\u4f5c,\u64cd\u4f5c\u53c2\u6570{}", (Object)JSON.toJSONString((Object)accompanyDoctor));
                int accompanyResult = this.updateDoctorBalance(accompanyDoctor);
                if (accompanyResult == 0) {
                    throw new RuntimeException("\u966a\u8bca\u533b\u751f\u5165\u8d26\u5931\u8d25");
                }
                this.redisTemplate.opsForSet().add((Object)"doctorBalanceOperateSyncSet", (Object[])new String[]{remunerationReqVO.getOrderNo()});
                this.redisTemplate.expire((Object)"doctorBalanceOperateSyncSet", 12L, TimeUnit.HOURS);
            }
        }
        catch (Throwable throwable) {
            RedissonLockUtil.unRedisLock(lock);
            throw throwable;
        }
        RedissonLockUtil.unRedisLock((RLock)lock);
    }

    public Map<Long, DoctorBalanceDTO> getDoctorBalance(List<Long> doctorIds) {
        HashMap<Long, DoctorBalanceDTO> balanceMap = new HashMap<Long, DoctorBalanceDTO>();
        for (Long doctorId : doctorIds) {
            DoctorBalanceDTO doctorBalance = this.doctorMapper.getDocBalanceInfo(doctorId);
            balanceMap.put(doctorBalance.getDoctorId(), doctorBalance);
        }
        return balanceMap;
    }
}

