/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctoruser.doctor.mapper.DocCommonWordsMapper;
import com.doctoruser.doctor.pojo.vo.DocCommonWordsVO;
import com.doctoruser.doctor.service.DocCommonWordsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocCommonWordsServiceImpl
implements DocCommonWordsService {
    private static final Logger log = LoggerFactory.getLogger(DocCommonWordsServiceImpl.class);
    String[] initCommonWords = new String[]{"\u60a8\u597d\uff0c\u6211\u6b63\u5728\u5fd9\uff0c\u8bf7\u5c3d\u91cf\u5177\u4f53\u63cf\u8ff0\u60a8\u7684\u75c7\u72b6\u53ca\u95ee\u9898\uff0c\u4ee5\u4fbf\u4e8e\u968f\u540e\u8bca\u65ad\uff01", "\u60a8\u662f\u5426\u613f\u610f\u63a5\u6536\u8bed\u97f3\u56de\u8bbf\uff1f", "\u611f\u8c22\u54a8\u8be2\uff0c\u795d\u60a8\u8eab\u4f53\u5065\u5eb7\uff01"};
    @Resource
    private DocCommonWordsMapper docCommonWordsMapper;

    public DocCommonWordsVO saveCommonWords(DocCommonWordsVO docCommonWordsVO) {
        if (Objects.isNull(docCommonWordsVO.getXId())) {
            this.docCommonWordsMapper.insert(docCommonWordsVO);
        } else {
            this.docCommonWordsMapper.updateByPrimaryKey(docCommonWordsVO);
        }
        return docCommonWordsVO;
    }

    public void deleteCommonWords(Long id) {
        this.docCommonWordsMapper.deleteById(id);
    }

    public List<DocCommonWordsVO> queryByDoctorId(String doctorId) {
        Integer initCount = this.docCommonWordsMapper.queryIsInitByDoctorId(doctorId);
        if (initCount == 0) {
            log.info("\u6267\u884c\u533b\u751fid{}\u7684\u5e38\u7528\u8bed\u521d\u59cb\u5316", (Object)doctorId);
            ArrayList<DocCommonWordsVO> docCommonWordsVOList = new ArrayList<DocCommonWordsVO>();
            for (String words : this.initCommonWords) {
                DocCommonWordsVO docCommonWordsVO = new DocCommonWordsVO();
                docCommonWordsVO.setDoctorId(doctorId);
                docCommonWordsVO.setCommonWords(words);
                docCommonWordsVOList.add(docCommonWordsVO);
            }
            this.docCommonWordsMapper.batchInsert(docCommonWordsVOList);
        }
        return this.docCommonWordsMapper.queryByDoctorId(doctorId);
    }
}

