/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctor.basedata.api.vo.UserPatientListRespVO;
import com.doctoruser.api.pojo.vo.DoctorPatientRelationVo;
import com.doctoruser.api.pojo.vo.basedata.doctor.UserDoctorRelationVo;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.listener.EventManager;
import com.doctoruser.doctor.listener.event.SmsPatientEvent;
import com.doctoruser.doctor.mapper.DocPatientRelationMapper;
import com.doctoruser.doctor.mapper.DocPatientReportLogMapper;
import com.doctoruser.doctor.mapper.DocRelationGroupMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.entity.DocPatientRelationEntity;
import com.doctoruser.doctor.pojo.entity.DocRelationGroupEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.DocPatientRelationRepVo;
import com.doctoruser.doctor.pojo.vo.DoctorFocusQuery;
import com.doctoruser.doctor.pojo.vo.DoctorPatientFocusInfoVo;
import com.doctoruser.doctor.pojo.vo.DoctorPatientQuery;
import com.doctoruser.doctor.pojo.vo.DoctorRelationGroupRepVo;
import com.doctoruser.doctor.pojo.vo.FocusPatientVo;
import com.doctoruser.doctor.pojo.vo.GetPatientInfoVo;
import com.doctoruser.doctor.pojo.vo.GetPatientReqVo;
import com.doctoruser.doctor.pojo.vo.ManagerRelationReqVo;
import com.doctoruser.doctor.pojo.vo.ManagerRelationVo;
import com.doctoruser.doctor.pojo.vo.PatientLabelVO;
import com.doctoruser.doctor.pojo.vo.QueryDoctorParam;
import com.doctoruser.doctor.pojo.vo.QueryRelationGroupVo;
import com.doctoruser.doctor.pojo.vo.RegisterPatientVO;
import com.doctoruser.doctor.pojo.vo.RelationGroupReqVo;
import com.doctoruser.doctor.pojo.vo.RelationInfoVo;
import com.doctoruser.doctor.pojo.vo.RemoveRelationVo;
import com.doctoruser.doctor.pojo.vo.SaveDoctorRelationReqVo;
import com.doctoruser.doctor.pojo.vo.SummaryRelationVo;
import com.doctoruser.doctor.pojo.vo.UcCardListReqVO;
import com.doctoruser.doctor.pojo.vo.UnRegisterPatientReqVO;
import com.doctoruser.doctor.pojo.vo.UserFocusVo;
import com.doctoruser.doctor.service.DocPatientRelationService;
import com.doctoruser.doctor.service.IUserEvaluationService;
import com.doctoruser.doctor.service.impl.DocRelationGroupServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.GenderUtils;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocPatientRelationServiceImpl
implements DocPatientRelationService {
    private static final Logger log = LoggerFactory.getLogger(DocPatientRelationServiceImpl.class);
    @Autowired
    private DocPatientRelationMapper docPatientRelationMapper;
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private DocRelationGroupMapper docRelationGroupMapper;
    @Value(value="${domainName}")
    private String domainName;
    @Autowired
    private IUserEvaluationService userEvaluationService;
    @Autowired
    private DocRelationGroupServiceImpl docRelationGroupService;
    public static final String GET_PATIENT_INFO_FOR_CARD_SERVICE = "/cardservice/getpatientinfobycrednoAndType";
    public static final String GET_PATIENT_INFO_FOR_CARD_SERVICE_BY_ID = "/cardservice/getpatientinfobyid";
    @Autowired
    private EventManager eventManager;
    @Autowired
    private DocPatientReportLogMapper docPatientReportLogMapper;

    public BaseResponse saveUserDoctorRelation(UserDoctorRelationVo userDoctorRelationVo) {
        if (userDoctorRelationVo.getDoctorId() == 0L) {
            return BaseResponse.error((IError)EHErrorEnum.DOCTOR_ID_MUST);
        }
        DocPatientRelationEntity docPatientRelationEntity = this.docPatientRelationMapper.selectByDoctorIdAndUserIdAndCode(userDoctorRelationVo.getAppCode(), userDoctorRelationVo.getDoctorId(), userDoctorRelationVo.getUserId(), Byte.valueOf((byte)1));
        log.info("\u67e5\u8be2\u5230\u7684\u7528\u6237\u533b\u751f\u5173\u7cfb\u6570\u636e:[{}]", (Object)JSON.toJSONString((Object)docPatientRelationEntity));
        if (Objects.isNull(docPatientRelationEntity)) {
            DocPatientRelationEntity docPatientRelation = new DocPatientRelationEntity();
            docPatientRelation.setUserId(userDoctorRelationVo.getUserId());
            docPatientRelation.setAppCode(userDoctorRelationVo.getAppCode());
            docPatientRelation.setDoctorId(userDoctorRelationVo.getDoctorId());
            docPatientRelation.setStatus(userDoctorRelationVo.getStatus());
            docPatientRelation.setVisited(userDoctorRelationVo.getVisited());
            docPatientRelation.setFocusType(Byte.valueOf((byte)1));
            int insert = this.docPatientRelationMapper.insertSelective(docPatientRelation);
            return BaseResponse.success((Object)insert);
        }
        docPatientRelationEntity.setStatus(userDoctorRelationVo.getStatus());
        docPatientRelationEntity.setVisited(userDoctorRelationVo.getVisited());
        int update = this.docPatientRelationMapper.updateByPrimaryKeySelective(docPatientRelationEntity);
        return BaseResponse.success((Object)update);
    }

    public BaseResponse<List<UserFocusVo>> getUserDoctorRelationList(String appCode, String userId) {
        List relationList = this.docPatientRelationMapper.getUserDoctorRelation(appCode, userId, Byte.valueOf((byte)1), Integer.valueOf(1));
        ArrayList<UserFocusVo> userFocusList = new ArrayList<UserFocusVo>();
        if (relationList.isEmpty()) {
            return BaseResponse.success(userFocusList);
        }
        List doctorIds = relationList.stream().map(DocPatientRelationEntity::getDoctorId).collect(Collectors.toList());
        List doctorInfoList = this.doctorMapper.getDoctorListByIds(doctorIds);
        Map doctorInfoMap = doctorInfoList.stream().filter(item -> 1 == item.getStatus()).collect(Collectors.toMap(DoctorInfoEntity::getId, Function.identity()));
        List organIds = doctorInfoList.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organInfoMap = this.organizationMapper.getOrgansByIds(organIds);
        for (DocPatientRelationEntity relationEntity : relationList) {
            DoctorInfoEntity doctorInfo = (DoctorInfoEntity)doctorInfoMap.get(relationEntity.getDoctorId());
            if (!Objects.nonNull(doctorInfo)) continue;
            UserFocusVo userFocus = new UserFocusVo();
            userFocus.setDeptName(doctorInfo.getHospitalDeptName());
            userFocus.setDoctorId(relationEntity.getDoctorId());
            userFocus.setDoctorName(doctorInfo.getName());
            Integer organId = doctorInfo.getOrganId();
            userFocus.setOrganId(Long.valueOf(Objects.isNull(organId) ? 0L : organId.longValue()));
            OrganizationEntity organization = (OrganizationEntity)organInfoMap.get(doctorInfo.getOrganId());
            userFocus.setOrganName(Objects.isNull(organization) ? "" : organization.getOrganName());
            userFocus.setPortrait(doctorInfo.getHeadPortrait());
            userFocus.setProfession(doctorInfo.getProfession());
            userFocus.setVisited(relationEntity.getVisited());
            BaseResponse doctorAverageScoreData = this.userEvaluationService.getDoctorAverageScore(String.valueOf(relationEntity.getDoctorId()));
            String score = (String)doctorAverageScoreData.getData();
            log.info("======\u83b7\u53d6\u5230\u7684\u533b\u751f\u5206\u6570[{}]", (Object)score);
            userFocus.setDoctorScore(Objects.isNull(score) ? "5.0" : score);
            userFocus.setStatus(relationEntity.getStatus());
            userFocusList.add(userFocus);
        }
        return BaseResponse.success(userFocusList);
    }

    public BaseResponse<Boolean> getUserDoctorRelation(String appCode, String userId, Long doctorId) {
        UserDoctorRelationVo userDoctorRelationVo = new UserDoctorRelationVo();
        userDoctorRelationVo.setAppCode(appCode);
        userDoctorRelationVo.setDoctorId(doctorId);
        userDoctorRelationVo.setUserId(userId);
        DocPatientRelationEntity docPatientRelation = this.docPatientRelationMapper.selectByDoctorIdAndUserIdAndCode(userDoctorRelationVo.getAppCode(), userDoctorRelationVo.getDoctorId(), userDoctorRelationVo.getUserId(), Byte.valueOf((byte)1));
        Boolean isFocused = !Objects.isNull(docPatientRelation) && 1 == docPatientRelation.getStatus();
        return BaseResponse.success((Object)isFocused);
    }

    public BaseResponse<ManagerRelationVo> getManagerRelationList(ManagerRelationReqVo managerRelationReq) {
        Page page = new Page();
        page.setCurrent((long)managerRelationReq.getPageNum());
        page.setSize((long)managerRelationReq.getPageSize());
        managerRelationReq.setStatus(Byte.valueOf((byte)1));
        IPage iPage = this.docPatientRelationMapper.getManagerRelationPage(page, managerRelationReq);
        List pageRecords = iPage.getRecords();
        List organIds = pageRecords.stream().map(RelationInfoVo::getOrganId).collect(Collectors.toList());
        Map organMap = this.organizationMapper.getOrgansByIds(organIds);
        Iterator iterator = pageRecords.iterator();
        while (iterator.hasNext()) {
            RelationInfoVo pageRecord;
            OrganizationEntity organizationEntity = (OrganizationEntity)organMap.get((pageRecord = (RelationInfoVo)iterator.next()).getOrganId().intValue());
            pageRecord.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
        }
        SummaryRelationVo summaryData = this.docPatientRelationMapper.getSummaryRelation(managerRelationReq);
        ManagerRelationVo managerRelationVo = new ManagerRelationVo();
        managerRelationVo.setSummaryRelationVo(summaryData);
        managerRelationVo.setPageData(pageRecords);
        managerRelationVo.setTotal(Long.valueOf(iPage.getTotal()));
        return BaseResponse.success((Object)managerRelationVo);
    }

    public BaseResponse saveDoctorPatientRelation(DoctorPatientRelationVo reqVo) {
        DocPatientRelationEntity docPatientRelationEntity = this.queryDoctorFocus(reqVo);
        if (Objects.nonNull(docPatientRelationEntity)) {
            log.info("\u60a3\u8005\u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0,{}", (Object)JSON.toJSONString((Object)docPatientRelationEntity));
            return BaseResponse.error((IError)EHErrorEnum.PATIENT_EXISTS);
        }
        int insert = this.insertDoctorFocus(reqVo);
        return BaseResponse.success((Object)insert);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteDoctorPatientRelation(RemoveRelationVo removeRelationVo) {
        int update = this.docPatientRelationMapper.removeDoctorPatientRelation(removeRelationVo);
        this.docPatientReportLogMapper.deleteByRelation(removeRelationVo);
        return BaseResponse.success((Object)update);
    }

    public BaseResponse<List<DoctorPatientFocusInfoVo>> getDoctorFocusPatientInfo(String appCode, Long doctorId) {
        List docRelationGroupList = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        DoctorFocusQuery doctorFocusQuery = new DoctorFocusQuery();
        doctorFocusQuery.setAppCode(appCode);
        doctorFocusQuery.setDoctorId(doctorId);
        doctorFocusQuery.setFocusType(Byte.valueOf((byte)2));
        doctorFocusQuery.setStatus(Byte.valueOf((byte)1));
        List focusList = this.docPatientRelationMapper.getDoctorFocusList(doctorFocusQuery);
        Map<Long, List<FocusPatientVo>> groupFocusList = focusList.stream().collect(Collectors.groupingBy(FocusPatientVo::getGroupId));
        ArrayList<DoctorPatientFocusInfoVo> resultList = new ArrayList<DoctorPatientFocusInfoVo>();
        for (DocRelationGroupEntity docRelationGroupEntity : docRelationGroupList) {
            DoctorPatientFocusInfoVo doctorPatientFocusInfoVo = new DoctorPatientFocusInfoVo();
            BeanUtils.copyProperties((Object)docRelationGroupEntity, (Object)doctorPatientFocusInfoVo);
            ArrayList focusPatientVos = groupFocusList.get(docRelationGroupEntity.getId());
            doctorPatientFocusInfoVo.setFocusPatientList((List)(Objects.isNull(focusPatientVos) ? new ArrayList() : focusPatientVos));
            resultList.add(doctorPatientFocusInfoVo);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<List<FocusPatientVo>> queryDoctorFocusInfo(String appCode, Long doctorId, String searchParam) {
        DoctorFocusQuery doctorFocusQuery = new DoctorFocusQuery();
        doctorFocusQuery.setAppCode(appCode);
        doctorFocusQuery.setDoctorId(doctorId);
        doctorFocusQuery.setFocusType(Byte.valueOf((byte)2));
        doctorFocusQuery.setStatus(Byte.valueOf((byte)1));
        doctorFocusQuery.setSearchParam(searchParam);
        List doctorFocusList = this.docPatientRelationMapper.getDoctorFocusList(doctorFocusQuery);
        return BaseResponse.success((Object)doctorFocusList);
    }

    public BaseResponse updateRelationGroup(RelationGroupReqVo relationGroupReqVo) {
        DocPatientRelationEntity docPatientRelationEntity = new DocPatientRelationEntity();
        docPatientRelationEntity.setId(relationGroupReqVo.getRelationId());
        docPatientRelationEntity.setGroupId(relationGroupReqVo.getGroupId());
        int update = this.docPatientRelationMapper.updateByPrimaryKeySelective(docPatientRelationEntity);
        return BaseResponse.success((Object)update);
    }

    public BaseResponse<Long> getDoctorFocusCount(String appCode, Long doctorId) {
        DoctorPatientQuery doctorFocusQuery = new DoctorPatientQuery();
        doctorFocusQuery.setAppCode(appCode);
        doctorFocusQuery.setDoctorId(doctorId);
        doctorFocusQuery.setStatus(Byte.valueOf((byte)1));
        Long doctorFocusCount = this.docPatientRelationMapper.getFocusCountWithGroup(doctorFocusQuery);
        return BaseResponse.success((Object)doctorFocusCount);
    }

    public BaseResponse savePatientDoctorRelation(SaveDoctorRelationReqVo saveDoctorRelationReqVo) {
        BaseResponse patientInfoDb;
        String code = "0";
        GetPatientInfoVo patientInfo = new GetPatientInfoVo();
        if (StringUtil.isEmpty((String)saveDoctorRelationReqVo.getPatientId())) {
            patientInfoDb = this.getPatientInfo(saveDoctorRelationReqVo.getCardNo(), saveDoctorRelationReqVo.getAppCode());
            if (code.equals(patientInfoDb.getCode())) {
                return patientInfoDb;
            }
            patientInfo = (GetPatientInfoVo)patientInfoDb.getData();
            if (Objects.isNull(patientInfo)) {
                return BaseResponse.error((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u60a3\u8005,\u8bf7\u6838\u5bf9\u4fe1\u606f\u540e\u91cd\u65b0\u8f93\u5165");
            }
        } else {
            patientInfoDb = this.getPatientInfoByPatientId(saveDoctorRelationReqVo.getPatientId(), saveDoctorRelationReqVo.getAppCode());
            if (code.equals(patientInfoDb.getCode())) {
                return patientInfoDb;
            }
            patientInfo = (GetPatientInfoVo)patientInfoDb.getData();
            if (Objects.isNull(patientInfo)) {
                return BaseResponse.error((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u60a3\u8005,\u8bf7\u6838\u5bf9\u4fe1\u606f\u540e\u91cd\u65b0\u8f93\u5165");
            }
        }
        log.info("\u8c03\u7528\u5361\u670d\u52a1\u83b7\u53d6\u7684\u60a3\u8005\u4fe1\u606f\u662f:{}", (Object)patientInfo);
        DocPatientRelationEntity byCardNoAndDoctorIdAndAppCode = this.docPatientRelationMapper.getByCardNoAndDoctorIdAndAppCode(Long.valueOf(Long.parseLong(saveDoctorRelationReqVo.getGroupId())), saveDoctorRelationReqVo.getCardNo(), saveDoctorRelationReqVo.getDoctorId(), saveDoctorRelationReqVo.getAppCode(), (byte)2);
        if (Objects.nonNull(byCardNoAndDoctorIdAndAppCode)) {
            return BaseResponse.error((String)"\u8be5\u60a3\u8005\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        DocPatientRelationEntity docPatientRelationEntity = new DocPatientRelationEntity();
        docPatientRelationEntity.setPatientId(Long.valueOf(patientInfo.getPatientId()));
        docPatientRelationEntity.setPatientName(patientInfo.getName());
        docPatientRelationEntity.setCardNo(patientInfo.getCredNo());
        docPatientRelationEntity.setUserId(saveDoctorRelationReqVo.getUserId());
        docPatientRelationEntity.setGroupId(Long.valueOf(saveDoctorRelationReqVo.getGroupId()));
        docPatientRelationEntity.setStatus(Byte.valueOf((byte)1));
        docPatientRelationEntity.setAppCode(saveDoctorRelationReqVo.getAppCode());
        docPatientRelationEntity.setDoctorId(Long.valueOf(saveDoctorRelationReqVo.getDoctorId()));
        docPatientRelationEntity.setFocusType(Byte.valueOf((byte)2));
        docPatientRelationEntity.setLabel(saveDoctorRelationReqVo.getLabel());
        docPatientRelationEntity.setPhone(saveDoctorRelationReqVo.getPhone());
        docPatientRelationEntity.setVisited(Byte.valueOf((byte)0));
        this.docPatientRelationMapper.insert(docPatientRelationEntity);
        return BaseResponse.success((Object)docPatientRelationEntity);
    }

    public BaseResponse myGroupPatientInfo(String appCode, Long doctorId) {
        List groupData = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        List defaultGroupList = groupData.stream().filter(item -> item.getIsDefault().intValue() == 1).collect(Collectors.toList());
        if (defaultGroupList.isEmpty()) {
            List defaultRelationGroup = this.docRelationGroupService.createDefaultRelationGroupNew(doctorId, appCode);
            for (DocRelationGroupEntity docRelationGroupEntity : defaultRelationGroup) {
                groupData.add(docRelationGroupEntity);
            }
        }
        List docRelationGroupList = this.docRelationGroupMapper.getDocRelationGroupList(doctorId, appCode, 1);
        ArrayList<DoctorRelationGroupRepVo> doctorRelationGroupRepVoList = new ArrayList<DoctorRelationGroupRepVo>();
        for (DocRelationGroupEntity docRelationGroupEntity : docRelationGroupList) {
            ArrayList<DocPatientRelationRepVo> docPatientRelationRepVoList = new ArrayList<DocPatientRelationRepVo>();
            List groupPatient = this.docPatientRelationMapper.getGroupPatient(docRelationGroupEntity.getId(), Byte.valueOf((byte)2), 1);
            for (DocPatientRelationEntity docPatientRelationEntity : groupPatient) {
                DocPatientRelationRepVo docPatientRelationRepVo = new DocPatientRelationRepVo();
                BeanUtils.copyProperties((Object)docPatientRelationEntity, (Object)docPatientRelationRepVo);
                if (!"".equals(docPatientRelationRepVo.getCardNo())) {
                    docPatientRelationRepVo.setPatientAge(Byte.valueOf((byte)GenderUtils.getAgeByIdCard((String)docPatientRelationEntity.getCardNo())));
                    docPatientRelationRepVo.setPatientHeadPortrait("");
                    docPatientRelationRepVo.setPatientSexCode(Byte.valueOf(GenderUtils.getSexCode((String)IdCardUtil.getGenderByIdCard((String)docPatientRelationEntity.getCardNo()))));
                    docPatientRelationRepVo.setPatientSexName(GenderUtils.getSexName((String)IdCardUtil.getGenderByIdCard((String)docPatientRelationEntity.getCardNo())));
                }
                docPatientRelationRepVoList.add(docPatientRelationRepVo);
            }
            DoctorRelationGroupRepVo doctorRelationGroupRepVo = new DoctorRelationGroupRepVo();
            BeanUtils.copyProperties((Object)docRelationGroupEntity, (Object)doctorRelationGroupRepVo);
            doctorRelationGroupRepVo.setPatientCount(Long.valueOf(groupPatient.size()));
            doctorRelationGroupRepVo.setDocPatientRelationRepVoList(docPatientRelationRepVoList);
            doctorRelationGroupRepVoList.add(doctorRelationGroupRepVo);
        }
        return BaseResponse.success(doctorRelationGroupRepVoList);
    }

    public BaseResponse getPatientByName(String name, Long doctorId) {
        List byLikeNameAndDoctorId = this.docPatientRelationMapper.getByLikeNameAndDoctorId(name, doctorId, (byte)2);
        return BaseResponse.success((Object)byLikeNameAndDoctorId);
    }

    public BaseResponse getPatientByPatientIdAndDoctorId(Long doctorId, Long patientId) {
        DocPatientRelationEntity byPatientIdAndDoctorId = this.docPatientRelationMapper.getByPatientIdAndDoctorId(patientId, doctorId, (byte)2);
        if (Objects.isNull(byPatientIdAndDoctorId)) {
            return BaseResponse.success(null);
        }
        DocPatientRelationRepVo docPatientRelationRepVo = new DocPatientRelationRepVo();
        BeanUtils.copyProperties((Object)byPatientIdAndDoctorId, (Object)docPatientRelationRepVo);
        if (!"".equals(docPatientRelationRepVo.getCardNo())) {
            docPatientRelationRepVo.setPatientAge(Byte.valueOf((byte)GenderUtils.getAgeByIdCard((String)byPatientIdAndDoctorId.getCardNo())));
            docPatientRelationRepVo.setPatientHeadPortrait("");
            docPatientRelationRepVo.setPatientSexCode(Byte.valueOf(GenderUtils.getSexCode((String)IdCardUtil.getGenderByIdCard((String)byPatientIdAndDoctorId.getCardNo()))));
            docPatientRelationRepVo.setPatientSexName(GenderUtils.getSexName((String)IdCardUtil.getGenderByIdCard((String)byPatientIdAndDoctorId.getCardNo())));
        }
        return BaseResponse.success((Object)docPatientRelationRepVo);
    }

    public BaseResponse getPatientLabelByPatientId(Long patientId) {
        return BaseResponse.success((Object)this.docPatientRelationMapper.getPatientLabelByPatientId(patientId));
    }

    public BaseResponse<Long> getUserFocusCount(String appCode, Long doctorId) {
        DoctorPatientQuery doctorFocusQuery = new DoctorPatientQuery();
        doctorFocusQuery.setAppCode(appCode);
        doctorFocusQuery.setDoctorId(doctorId);
        doctorFocusQuery.setFocusType(Byte.valueOf((byte)1));
        doctorFocusQuery.setStatus(Byte.valueOf((byte)1));
        Long doctorFocusCount = this.docPatientRelationMapper.getFocusCount(doctorFocusQuery);
        return BaseResponse.success((Object)doctorFocusCount);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse saveUnRegisterPatient(UnRegisterPatientReqVO reqVO) {
        DocPatientRelationEntity docPatientRelationEntity = new DocPatientRelationEntity();
        docPatientRelationEntity.setPatientName(reqVO.getPatientName());
        docPatientRelationEntity.setGroupId(reqVO.getGroupId());
        docPatientRelationEntity.setStatus(Byte.valueOf((byte)0));
        docPatientRelationEntity.setAppCode(reqVO.getAppCode());
        docPatientRelationEntity.setDoctorId(reqVO.getDoctorId());
        docPatientRelationEntity.setFocusType(Byte.valueOf((byte)2));
        docPatientRelationEntity.setLabel(reqVO.getLabel());
        docPatientRelationEntity.setPhone(reqVO.getPhone());
        docPatientRelationEntity.setVisited(Byte.valueOf((byte)0));
        this.docPatientRelationMapper.insertSelective(docPatientRelationEntity);
        if (!StringUtils.isEmpty((CharSequence)reqVO.getPhone())) {
            QueryDoctorParam param = new QueryDoctorParam();
            param.setDoctorId(reqVO.getDoctorId());
            DoctorInfoEntity doctorInfo = this.doctorMapper.querySingleDoctor(param);
            SmsPatientEvent event = new SmsPatientEvent(doctorInfo.getName(), reqVO.getAppCode(), reqVO.getPhone(), "open");
            log.info("\u60a3\u8005\u62a5\u9053-\u9080\u8bf7\u60a3\u8005\u5f00\u901a\u5c31\u8bca\u5361-\u77ed\u4fe1\u901a\u77e5\u5165\u53c2: {}", (Object)event);
            this.eventManager.post((Object)event);
        }
        return BaseResponse.success();
    }

    public BaseResponse updateUnRegisterPatient(RegisterPatientVO reqVO) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse updatePatientLabel(PatientLabelVO labelVO) {
        this.docPatientRelationMapper.updatePatientLabel(labelVO);
        return BaseResponse.success();
    }

    private void insertDoctorFocusPatient(DocPatientRelationEntity docPatientRelation) {
        UcCardListReqVO ucCardListReqVO = new UcCardListReqVO();
        ucCardListReqVO.setChannelCode("cloud_doctor");
        ucCardListReqVO.setUserId(docPatientRelation.getUserId());
        ucCardListReqVO.setAppCode(docPatientRelation.getAppCode());
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)ucCardListReqVO, (String)(this.domainName + docPatientRelation.getAppCode() + "/usercenter/card/cardlist"));
        String json = JSON.toJSONString((Object)baseResponse.getData());
        List userPatientList = JSONArray.parseArray((String)json, UserPatientListRespVO.class);
        log.info("\u7528\u6237\u7ed1\u5b9a\u7684\u60a3\u8005\u4fe1\u606f:{}", (Object)userPatientList);
        QueryRelationGroupVo queryGroupVo = new QueryRelationGroupVo();
        queryGroupVo.setAppCode(docPatientRelation.getAppCode());
        queryGroupVo.setDoctorId(docPatientRelation.getDoctorId());
        queryGroupVo.setIsDefault(Integer.valueOf(1));
        queryGroupVo.setStatus(Integer.valueOf(1));
        DocRelationGroupEntity docDefaultRelationGroup = this.docRelationGroupService.getDocDefaultRelationGroup(queryGroupVo);
        for (UserPatientListRespVO userPatient : userPatientList) {
            log.info("\u6821\u9a8c\u533b\u751f\u5173\u6ce8\u60a3\u8005,\u60a3\u8005\u6570\u636e:{}", (Object)JSON.toJSONString((Object)userPatient));
            DoctorPatientRelationVo docPatientRelationVo = new DoctorPatientRelationVo();
            docPatientRelationVo.setAppCode(docPatientRelation.getAppCode());
            docPatientRelationVo.setDoctorId(docPatientRelation.getDoctorId());
            docPatientRelationVo.setGroupId(docDefaultRelationGroup.getId());
            docPatientRelationVo.setPatientId(Long.valueOf(userPatient.getPatientId()));
            docPatientRelationVo.setPatientName(userPatient.getPatientName());
            docPatientRelationVo.setStatus(Byte.valueOf((byte)1));
            docPatientRelationVo.setUserId(docPatientRelation.getUserId());
            DocPatientRelationEntity relationEntity = this.queryDoctorFocus(docPatientRelationVo);
            if (!Objects.isNull(relationEntity)) continue;
            this.insertDoctorFocus(docPatientRelationVo);
        }
    }

    private DocPatientRelationEntity queryDoctorFocus(DoctorPatientRelationVo reqVo) {
        DoctorPatientQuery doctorPatientQuery = new DoctorPatientQuery();
        doctorPatientQuery.setAppCode(reqVo.getAppCode());
        doctorPatientQuery.setDoctorId(reqVo.getDoctorId());
        doctorPatientQuery.setFocusType(Byte.valueOf((byte)2));
        doctorPatientQuery.setPatientId(reqVo.getPatientId());
        doctorPatientQuery.setStatus(Byte.valueOf((byte)1));
        DocPatientRelationEntity docPatientRelationEntity = this.docPatientRelationMapper.selectByDoctorIdAndPatientIdAndCode(doctorPatientQuery);
        log.info("\u67e5\u8be2\u5230\u7684\u533b\u751f\u60a3\u8005\u5173\u7cfb\u6570\u636e:[{}]", (Object)JSON.toJSONString((Object)docPatientRelationEntity));
        return docPatientRelationEntity;
    }

    private int insertDoctorFocus(DoctorPatientRelationVo reqVo) {
        DocPatientRelationEntity docPatientRelation = new DocPatientRelationEntity();
        docPatientRelation.setDoctorId(reqVo.getDoctorId());
        docPatientRelation.setPatientId(reqVo.getPatientId());
        docPatientRelation.setPatientName(reqVo.getPatientName());
        docPatientRelation.setGroupId(reqVo.getGroupId());
        docPatientRelation.setFocusType(Byte.valueOf((byte)2));
        docPatientRelation.setStatus(reqVo.getStatus());
        docPatientRelation.setAppCode(reqVo.getAppCode());
        docPatientRelation.setUserId(reqVo.getUserId());
        log.info("\u6dfb\u52a0\u533b\u751f\u5173\u6ce8\u60a3\u8005\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)docPatientRelation));
        return this.docPatientRelationMapper.insertSelective(docPatientRelation);
    }

    private BaseResponse<GetPatientInfoVo> getPatientInfo(String cardNo, String appCode) {
        GetPatientReqVo getPatientReqVo = new GetPatientReqVo();
        getPatientReqVo.setCredNo(cardNo);
        getPatientReqVo.setCredTypeCode("01");
        getPatientReqVo.setAppCode(appCode);
        log.info("\u6839\u636e\u60a3\u8005\u8eab\u4efd\u8bc1\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8c03\u7528\u5361\u670d\u52a1\u53c2\u6570\u4e3a:{}", (Object)getPatientReqVo);
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)getPatientReqVo, (String)(this.domainName + appCode + GET_PATIENT_INFO_FOR_CARD_SERVICE));
        if (Objects.isNull(baseResponse)) {
            return BaseResponse.error((String)"\u5361\u670d\u52a1\u8c03\u7528\u5931\u8d25");
        }
        if (Objects.isNull(baseResponse.getData())) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        String json = JSON.toJSONString((Object)baseResponse.getData());
        GetPatientInfoVo getPatientInfoVo = (GetPatientInfoVo)JSONArray.parseObject((String)json, GetPatientInfoVo.class);
        return BaseResponse.success((Object)getPatientInfoVo);
    }

    public BaseResponse<GetPatientInfoVo> getPatientInfoByPatientId(String patientId, String appCode) {
        GetPatientReqVo getPatientReqVo = new GetPatientReqVo();
        getPatientReqVo.setPatientId(patientId);
        getPatientReqVo.setAppCode(appCode);
        getPatientReqVo.setChannelCode("PATIENT_IOS");
        log.info("\u6839\u636e\u60a3\u8005ID\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8c03\u7528\u5361\u670d\u52a1\u53c2\u6570\u4e3a:{}", (Object)getPatientReqVo);
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)getPatientReqVo, (String)(this.domainName + appCode + GET_PATIENT_INFO_FOR_CARD_SERVICE_BY_ID));
        if (Objects.isNull(baseResponse)) {
            return BaseResponse.error((String)"\u5361\u670d\u52a1\u8c03\u7528\u5931\u8d25");
        }
        if (Objects.isNull(baseResponse.getData())) {
            return BaseResponse.error((String)"\u5361\u670d\u52a1\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38");
        }
        String json = JSON.toJSONString((Object)baseResponse.getData());
        GetPatientInfoVo getPatientInfoVo = (GetPatientInfoVo)JSONArray.parseObject((String)json, GetPatientInfoVo.class);
        return BaseResponse.success((Object)getPatientInfoVo);
    }
}

