/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctoruser.api.pojo.base.dto.AppealAllInfoDTO;
import com.doctoruser.api.pojo.base.dto.AppealDetailDTO;
import com.doctoruser.api.pojo.base.dto.manager.UpdateDealStatusDTO;
import com.doctoruser.api.pojo.base.entity.AppealEntity;
import com.doctoruser.api.pojo.base.vo.AppealDetailVO;
import com.doctoruser.api.pojo.base.vo.DocAppealRemarkVo;
import com.doctoruser.api.pojo.base.vo.QueryAppealTotalVo;
import com.doctoruser.doctor.enums.AppealStatusEnum;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.mapper.DocAppealMapper;
import com.doctoruser.doctor.mapper.DocAppealRemarkMapper;
import com.doctoruser.doctor.pojo.entity.DocAppealEntity;
import com.doctoruser.doctor.pojo.entity.DocAppealRemarkEntity;
import com.doctoruser.doctor.service.DoctorAppealService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DoctorAppealServiceImpl
implements DoctorAppealService {
    private static final Logger log = LoggerFactory.getLogger(DoctorAppealServiceImpl.class);
    @Resource
    private DocAppealMapper docAppealMapper;
    @Resource
    private DocAppealRemarkMapper docAppealRemarkMapper;

    public BaseResponse<String> queryAppealEntity(AppealEntity entity) {
        AppealEntity appealEntity = this.docAppealMapper.queryAppealEntity(entity);
        if (Objects.nonNull(appealEntity)) {
            return BaseResponse.error((IError)EHErrorEnum.APPEAL_EXISTS_ADD_FAIL);
        }
        return BaseResponse.success();
    }

    public BaseResponse<AppealEntity> getAppealByServLogId(String servLogId) {
        AppealEntity appealEntity = this.docAppealMapper.getAppealByServLogId(servLogId);
        return BaseResponse.success((Object)appealEntity);
    }

    public BaseResponse<Map> queryAppealAllInfo(AppealAllInfoDTO appealAllInfoDTO) {
        if (appealAllInfoDTO.getDateType() == 1) {
            appealAllInfoDTO.setCreateTimeEnd(appealAllInfoDTO.getTimeEnd());
            appealAllInfoDTO.setCreateTimeStart(appealAllInfoDTO.getTimeStart());
        }
        if (appealAllInfoDTO.getDateType() == 2) {
            appealAllInfoDTO.setCommentEndTime(appealAllInfoDTO.getTimeEnd());
            appealAllInfoDTO.setCommentStartTime(appealAllInfoDTO.getTimeStart());
        }
        QueryAppealTotalVo queryAppealTotalVo = this.docAppealMapper.countsAmount(appealAllInfoDTO);
        PageHelper.startPage((int)appealAllInfoDTO.getPageNum(), (int)appealAllInfoDTO.getPageSize());
        Page pageData = this.docAppealMapper.queryAppealAllInfo(appealAllInfoDTO);
        PageResult pageResult = new PageResult();
        pageResult.setTotalPages(pageData.getPages());
        pageResult.setTotal((int)pageData.getTotal());
        pageResult.setPageSize(appealAllInfoDTO.getPageSize().intValue());
        pageResult.setPageNum(appealAllInfoDTO.getPageNum().intValue());
        pageResult.setContent(pageData.getResult());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("queryAppealTotalVo", queryAppealTotalVo);
        hashMap.put("result", pageResult);
        return BaseResponse.success(hashMap);
    }

    public BaseResponse<AppealDetailVO> queryAppealDetailInfo(AppealDetailDTO appealDetailDTO) {
        AppealDetailVO appealDetailVO = this.docAppealMapper.queryAppealDetailByOrderNo(appealDetailDTO);
        if (Objects.nonNull(appealDetailVO)) {
            List remarkList = this.docAppealRemarkMapper.queryAppealRemarkByAppealId(appealDetailVO.getAppealId());
            ArrayList<DocAppealRemarkVo> docAppeal = new ArrayList<DocAppealRemarkVo>();
            if (appealDetailVO.getStatus() == 2) {
                DocAppealRemarkVo docAppealRemark = new DocAppealRemarkVo();
                docAppealRemark.setAppealTime(appealDetailVO.getAppealTime());
                docAppealRemark.setProcessTime(appealDetailVO.getProcessTime());
                docAppealRemark.setStatus(appealDetailVO.getStatus());
                docAppealRemark.setRemark(appealDetailVO.getReply());
                docAppealRemark.setRemarkUser(appealDetailVO.getProcessUser());
                docAppeal.add(docAppealRemark);
            }
            docAppeal.addAll(remarkList);
            DocAppealRemarkVo docAppealRemarkVo = new DocAppealRemarkVo();
            docAppealRemarkVo.setAppealTime(appealDetailVO.getAppealTime());
            docAppealRemarkVo.setProcessTime(appealDetailVO.getProcessTime());
            docAppealRemarkVo.setStatus(AppealStatusEnum.TODO.getValue());
            docAppealRemarkVo.setRemark(appealDetailVO.getContent());
            docAppealRemarkVo.setRemarkUser(appealDetailVO.getAppealName());
            docAppeal.add(docAppealRemarkVo);
            appealDetailVO.setRemark(docAppeal);
        }
        return BaseResponse.success((Object)appealDetailVO);
    }

    public BaseResponse<AppealEntity> updateDealStatus(UpdateDealStatusDTO param) {
        if (param.getReply() == null) {
            param.setStatus(AppealStatusEnum.PROCESSING.getValue());
        }
        if (param.getReply() != null) {
            param.setStatus(AppealStatusEnum.COMPLETE.getValue());
        }
        param.setUpdateTime(new Date());
        Integer integer = this.docAppealMapper.updateDealStatus(param);
        AppealEntity appealEntity = this.docAppealMapper.queryByServLogId(param.getAdmissionId());
        DocAppealRemarkEntity entity = new DocAppealRemarkEntity();
        entity.setxCreateTime(new Date());
        entity.setxUpdateTime(new Date());
        entity.setxVersion(Long.valueOf(1L));
        entity.setRemark(param.getDealExplain());
        entity.setRemarkUser(param.getDealUser());
        entity.setAppealId(Long.valueOf(appealEntity.getxId()));
        this.docAppealRemarkMapper.insertSelective(entity);
        if (integer == null) {
            log.error("\u65e0\u6cd5\u67e5\u8be2\u5230\u7533\u8ff0\u4fe1\u606f -> admissionId:{]", (Object)param.getAdmissionId());
            return BaseResponse.error((IError)EHErrorEnum.APPEAL_FAIL);
        }
        AppealEntity appealList = null;
        if (appealEntity.getStatus() == 2) {
            appealList = this.docAppealMapper.queryByServLogId(param.getAdmissionId());
        }
        return BaseResponse.success(appealList);
    }

    public BaseResponse<String> addAppeal(AppealEntity entity) {
        AppealEntity appealEntity = this.docAppealMapper.queryAppealByServIdAndType(entity);
        if (Objects.nonNull(appealEntity)) {
            return BaseResponse.error((IError)EHErrorEnum.APPEAL_EXISTS_ADD_FAIL);
        }
        DocAppealEntity docAppealEntity = new DocAppealEntity();
        BeanUtils.copyProperties((Object)entity, (Object)docAppealEntity);
        docAppealEntity.setServType(Byte.valueOf(entity.getServType().byteValue()));
        docAppealEntity.setStatus(Byte.valueOf(AppealStatusEnum.TODO.getValue().byteValue()));
        int res = this.docAppealMapper.insertSelective(docAppealEntity);
        if (res >= 1) {
            return BaseResponse.success((Object)docAppealEntity.getxId().toString());
        }
        return BaseResponse.error((IError)EHErrorEnum.OPERATION_FAIL);
    }
}

