/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.dto.UcUserEvaluationDTO;
import com.doctor.basedata.api.dto.UserEvaluationDTO;
import com.doctor.basedata.api.vo.DoctorAverageScoreRespVO;
import com.doctor.basedata.api.vo.UcEvaluationTagVO;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.mapper.UcEvaluationTagMapper;
import com.doctoruser.doctor.mapper.UcUserEvaluationMapper;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.entity.UcUserEvaluationEntity;
import com.doctoruser.doctor.pojo.vo.QueryDoctorParam;
import com.doctoruser.doctor.service.IUserEvaluationService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserEvaluationServiceImpl
implements IUserEvaluationService {
    private static final Logger log = LoggerFactory.getLogger(UserEvaluationServiceImpl.class);
    @Autowired
    private UcUserEvaluationMapper ucUserEvaluationMapper;
    @Autowired
    private UcEvaluationTagMapper ucEvaluationTagMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private DoctorMapper doctorMapper;

    public BaseResponse<List<UcEvaluationTagVO>> getEvaluationTag(String servCode) {
        return BaseResponse.success((Object)this.ucEvaluationTagMapper.selectAllTag(servCode, "1"));
    }

    public BaseResponse<Map<String, Object>> getEvaluationMsg(UserEvaluationDTO dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        Page ucUserEvaluationVOS = this.ucUserEvaluationMapper.PageForselectByParameters(dto);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != ucUserEvaluationVOS && ucUserEvaluationVOS.size() > 0) {
            for (UcUserEvaluationVO ucUserEvaluationVO : ucUserEvaluationVOS) {
                ServiceCodeEnum organServiceEnum;
                if (StringUtils.isNotEmpty((CharSequence)ucUserEvaluationVO.getDoctorId())) {
                    QueryDoctorParam queryDoctorParam = new QueryDoctorParam();
                    queryDoctorParam.setDoctorId(Long.valueOf(ucUserEvaluationVO.getDoctorId()));
                    DoctorInfoEntity doctorInfoEntity = this.doctorMapper.querySingleDoctor(queryDoctorParam);
                    if (null != doctorInfoEntity) {
                        ucUserEvaluationVO.setHospitalDeptId(doctorInfoEntity.getHospitalDeptId() + "");
                        ucUserEvaluationVO.setHospitalDeptName(doctorInfoEntity.getHospitalDeptName() + "");
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)ucUserEvaluationVO.getServCode()) || !Objects.nonNull(organServiceEnum = ServiceCodeEnum.getByServiceCode((String)ucUserEvaluationVO.getServCode()))) continue;
                ucUserEvaluationVO.setServName(organServiceEnum.getServiceName());
            }
            map.put("total", ucUserEvaluationVOS.getTotal());
            map.put("pageData", ucUserEvaluationVOS.getResult());
        }
        this.getDisplayEval(dto, map);
        return BaseResponse.success(map);
    }

    private void getDisplayEval(UserEvaluationDTO dto, Map<String, Object> map) {
        List ucUserEvaluationVOS1 = this.ucUserEvaluationMapper.ListForselectByParameters(dto);
        if (null != ucUserEvaluationVOS1) {
            Byte disPlayStatus = 1;
            Byte noDisPlayStatus = 0;
            long disPlay = ucUserEvaluationVOS1.stream().filter(e -> e.getDisplay().equals(disPlayStatus)).count();
            long noDisPlay = ucUserEvaluationVOS1.stream().filter(e -> e.getDisplay().equals(noDisPlayStatus)).count();
            long onetwo = ucUserEvaluationVOS1.stream().filter(e -> e.getDoctorScore() >= 1 && e.getDoctorScore() <= 2).count();
            long threefourfive = ucUserEvaluationVOS1.stream().filter(e -> e.getDoctorScore() >= 3 && e.getDoctorScore() <= 5).count();
            map.put("disPlasy", disPlay);
            map.put("noDisPlasy", noDisPlay);
            map.put("onetwo", onetwo);
            map.put("threefourfive", threefourfive);
        }
    }

    public BaseResponse<List<UcUserEvaluationVO>> getDoctorEvaluationMsg(String doctorId, String servCode, String admId, String productId) {
        List ucUserEvaluationVOS = this.ucUserEvaluationMapper.selectEvaluationByDoctor(doctorId, servCode, admId, productId, null);
        if (StringUtils.isEmpty((CharSequence)doctorId) && StringUtils.isNotEmpty((CharSequence)admId)) {
            return BaseResponse.success((Object)ucUserEvaluationVOS);
        }
        ucUserEvaluationVOS = ucUserEvaluationVOS.stream().filter(e -> e.getDisplay().equals((byte)1)).collect(Collectors.toList());
        for (UcUserEvaluationVO evaluation : ucUserEvaluationVOS) {
            ServiceCodeEnum organService = ServiceCodeEnum.getByServiceCode((String)evaluation.getServCode());
            if (!Objects.nonNull(organService)) continue;
            evaluation.setServName(organService.getServiceName());
        }
        return BaseResponse.success(ucUserEvaluationVOS);
    }

    public BaseResponse<PageResult<UcUserEvaluationVO>> getDoctorEvaluationMsgPage(String doctorId, String servCode, String admId, String productId, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page ucUserEvaluationVOS = (Page)this.ucUserEvaluationMapper.selectEvaluationByDoctor(doctorId, servCode, admId, productId, Integer.valueOf(1));
        PageResult result = new PageResult(pageNum, pageSize);
        result.setContent(ucUserEvaluationVOS.getResult());
        result.setTotal((int)ucUserEvaluationVOS.getTotal());
        result.setTotalPages(ucUserEvaluationVOS.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<Object> saveEvaluationMsg(List<UcUserEvaluationDTO> dto) {
        Date now = new Date();
        if (null != dto && dto.size() > 0) {
            for (UcUserEvaluationDTO uued : dto) {
                UcUserEvaluationEntity ucUserEvaluationEntity = new UcUserEvaluationEntity();
                BeanUtils.copyProperties((Object)uued, (Object)ucUserEvaluationEntity);
                ucUserEvaluationEntity.setCommentTime(now);
                Byte display = 1;
                OrganizationEntity organizationEntity = this.organizationMapper.queryOrganizationInfo(Long.valueOf(uued.getOrganId()));
                Integer evalDisplay = 0;
                if (null != organizationEntity && evalDisplay.equals(organizationEntity.getEvalDisplay())) {
                    display = 0;
                }
                ucUserEvaluationEntity.setDisplay(display);
                if (2 == uued.getEvalType() && null != uued.getTeamEvaluationMemberDTOList() && uued.getTeamEvaluationMemberDTOList().size() > 0) {
                    String jsons = JSON.toJSONString((Object)uued.getTeamEvaluationMemberDTOList());
                    ucUserEvaluationEntity.setTeamMember(jsons);
                }
                this.ucUserEvaluationMapper.insert(ucUserEvaluationEntity);
            }
        }
        return BaseResponse.success();
    }

    public BaseResponse<Object> updateEvaluationMsg(String display, String admId) {
        if (!"1".equals(display) && !"0".equals(display)) {
            return BaseResponse.error((IError)EHErrorEnum.STATUS_ERROR);
        }
        if (StringUtils.isEmpty((CharSequence)admId)) {
            return BaseResponse.error((IError)EHErrorEnum.ADMID_NOT_NULL);
        }
        String[] admIds = admId.split(",");
        return BaseResponse.success((Object)this.ucUserEvaluationMapper.updateByAdmId(display, admIds));
    }

    public BaseResponse<String> getDoctorAverageScore(String doctorId) {
        List ucUserEvaluationVOS = this.ucUserEvaluationMapper.selectEvaluationByDoctor(doctorId, null, null, null, null);
        Byte status = 1;
        OptionalDouble average = ucUserEvaluationVOS.stream().filter(e -> e.getDisplay().equals(status)).mapToInt(UcUserEvaluationVO::getDoctorScore).average();
        if (average.isPresent()) {
            double asDouble = average.getAsDouble();
            double avScore = (asDouble + 500.0) / 101.0;
            return BaseResponse.success((Object)String.format("%.1f", avScore));
        }
        return BaseResponse.success((Object)"5.0");
    }

    @Transactional
    public BaseResponse<Integer> siteEvalDisplay(String organId, String evalDisplay) {
        log.info("organId:{}", (Object)organId);
        log.info("evalDisplay:{}", (Object)evalDisplay);
        if (organId == null || "".equals(organId)) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        if (evalDisplay == null || "".equals(evalDisplay)) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        if ("0".equals(evalDisplay) || "1".equals(evalDisplay)) {
            int i = this.ucUserEvaluationMapper.updateByOrganId(evalDisplay, organId);
            log.info("\u8bc4\u4ef7\u5386\u53f2\u6d88\u606f\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)i);
            OrganizationEntity organizationEntity = new OrganizationEntity();
            organizationEntity.setId(Integer.valueOf(organId));
            organizationEntity.setEvalDisplay(Integer.valueOf(evalDisplay));
            return BaseResponse.success((Object)this.organizationMapper.updateByPrimaryKeySelective(organizationEntity));
        }
        return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
    }

    public Integer getDisplayStatus(String organId) {
        Integer evalDisplay = this.organizationMapper.getEvalDisplayById(organId);
        if (evalDisplay == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\uff01");
        }
        return evalDisplay;
    }

    public BaseResponse<Object> deleteEvaluationMsg(String patientId, String admId) {
        return BaseResponse.success((Object)this.ucUserEvaluationMapper.deleteByPatientIdAndAdmId(patientId, admId));
    }

    public BaseResponse<List<UcEvaluationTagVO>> getEvaluationTagByScore(String servCode, String score) {
        return BaseResponse.success((Object)this.ucEvaluationTagMapper.selectTagByScore(servCode, "1", score));
    }

    public BaseResponse<List<UcUserEvaluationVO>> getEvaluationByDoctorIds(List<String> doctorIds) {
        List result = new ArrayList();
        if (!doctorIds.isEmpty()) {
            result = this.ucUserEvaluationMapper.selectEvaluationByDoctorIds(doctorIds);
        }
        return BaseResponse.success(result);
    }

    public BaseResponse<List<DoctorAverageScoreRespVO>> getDoctorAverageScoreByDoctorIds(List<String> doctorIds) {
        ArrayList<DoctorAverageScoreRespVO> doctorAverageScoreRespVOList = new ArrayList<DoctorAverageScoreRespVO>();
        for (String doctorId : doctorIds) {
            DoctorAverageScoreRespVO doctorAverageScoreRespVO = new DoctorAverageScoreRespVO();
            doctorAverageScoreRespVO.setDoctorId(doctorId);
            List ucUserEvaluationVos = this.ucUserEvaluationMapper.selectEvaluationByDoctor(doctorId, null, null, null, null);
            Byte status = 1;
            OptionalDouble average = ucUserEvaluationVos.stream().filter(e -> e.getDisplay().equals(status)).mapToInt(UcUserEvaluationVO::getDoctorScore).average();
            if (average.isPresent()) {
                double asDouble = average.getAsDouble();
                double avScore = (asDouble + 500.0) / 101.0;
                doctorAverageScoreRespVO.setAverageScore(String.format("%.1f", avScore));
            }
            doctorAverageScoreRespVO.setAverageScore("0.0");
            doctorAverageScoreRespVOList.add(doctorAverageScoreRespVO);
        }
        return BaseResponse.success(doctorAverageScoreRespVOList);
    }
}

