/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.doctor.listener.EventManager;
import com.doctoruser.doctor.listener.event.PatientEvent;
import com.doctoruser.doctor.mapper.DocDepartmentMapper;
import com.doctoruser.doctor.mapper.DocPatientRelationMapper;
import com.doctoruser.doctor.mapper.DocRelationGroupMapper;
import com.doctoruser.doctor.mapper.DoctorTeamInfoMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.dto.BaseTree;
import com.doctoruser.doctor.pojo.dto.DoctorInfoDTO;
import com.doctoruser.doctor.pojo.dto.SessionGroupUser;
import com.doctoruser.doctor.pojo.entity.DocPatientRelationEntity;
import com.doctoruser.doctor.pojo.entity.DocRelationGroupEntity;
import com.doctoruser.doctor.pojo.vo.FocusDoctorVO;
import com.doctoruser.doctor.pojo.vo.GetPatientInfoVo;
import com.doctoruser.doctor.pojo.vo.PatientAttentionVO;
import com.doctoruser.doctor.pojo.vo.PatientRelationVO;
import com.doctoruser.doctor.remote.NodeRemoteService;
import com.doctoruser.doctor.service.DocPatientRelationService;
import com.doctoruser.doctor.service.DocRelationGroupService;
import com.doctoruser.doctor.service.V2DocPatientRelationService;
import com.doctoruser.doctor.utils.TreeUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class V2DocPatientRelationServiceImpl
implements V2DocPatientRelationService {
    private static final Logger log = LoggerFactory.getLogger(V2DocPatientRelationServiceImpl.class);
    @Autowired
    private DocPatientRelationMapper docPatientRelationMapper;
    @Autowired
    private DocRelationGroupMapper docRelationGroupMapper;
    @Autowired
    private NodeRemoteService nodeRemoteService;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private DocPatientRelationService docPatientRelationService;
    @Autowired
    private DocRelationGroupService docRelationGroupService;
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private DocDepartmentMapper docDepartmentMapper;
    @Autowired
    private DoctorTeamInfoMapper doctorTeamInfoMapper;
    private static final String DEFAULT_GROUP = "\u6162\u75c5\u60a3\u8005";

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PatientRelationVO> saveRelation(PatientAttentionVO reqVO) {
        PatientRelationVO relationVO = new PatientRelationVO();
        DocRelationGroupEntity groupEntity = this.docRelationGroupMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(reqVO.getGroupId())));
        if (groupEntity == null) {
            return BaseResponse.error((String)"\u4e8c\u7ef4\u7801\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u626b\u63cf");
        }
        DocPatientRelationEntity relationEntity = this.docPatientRelationMapper.getByPatientIdAndDoctorId(Long.valueOf(Long.parseLong(reqVO.getPatientId())), Long.valueOf(Long.parseLong(reqVO.getDoctorId())), (byte)1);
        if (Objects.nonNull(relationEntity)) {
            relationVO.setAttention(Boolean.valueOf(true));
            return BaseResponse.success((Object)relationVO);
        }
        reqVO.setGroupName(groupEntity.getName());
        BaseResponse baseResponse = this.nodeRemoteService.createSession(reqVO);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        relationVO.setSessionGroupUser((SessionGroupUser)baseResponse.getData());
        relationVO.setAttention(Boolean.valueOf(false));
        DocPatientRelationEntity docPatientRelation = new DocPatientRelationEntity();
        docPatientRelation.setGroupId(Long.valueOf(Long.parseLong(reqVO.getGroupId())));
        docPatientRelation.setPatientId(Long.valueOf(Long.parseLong(reqVO.getPatientId())));
        docPatientRelation.setPatientName(reqVO.getPatientName());
        docPatientRelation.setCardNo(reqVO.getCardNo());
        if (StringUtils.isEmpty((CharSequence)reqVO.getPhone())) {
            GetPatientInfoVo patientInfo = this.getPatientPhone(reqVO.getPatientId(), reqVO.getAppCode());
            reqVO.setPhone(Objects.isNull(patientInfo) ? "" : patientInfo.getContactMobile());
        }
        docPatientRelation.setPhone(reqVO.getPhone());
        docPatientRelation.setUserId(reqVO.getDoctorUserId());
        docPatientRelation.setAppCode(reqVO.getAppCode());
        docPatientRelation.setDoctorId(Long.valueOf(Long.parseLong(reqVO.getDoctorId())));
        docPatientRelation.setStatus(Byte.valueOf((byte)1));
        docPatientRelation.setFocusType(Byte.valueOf((byte)1));
        this.docPatientRelationMapper.insertSelective(docPatientRelation);
        PatientEvent event = new PatientEvent();
        event.setDoctorId(Long.valueOf(Long.parseLong(reqVO.getDoctorId())));
        event.setAppCode(reqVO.getAppCode());
        this.eventManager.post((Object)event);
        return BaseResponse.success((Object)relationVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> focusDoctor(FocusDoctorVO reqVO) {
        GetPatientInfoVo patientInfo = this.getPatientPhone(reqVO.getPatientId(), reqVO.getAppCode());
        log.info("\u60a3\u8005:{},\u5173\u6ce8\u533b\u751f\u5165\u53c2:{}", (Object)patientInfo, (Object)reqVO);
        for (DoctorInfoDTO doctor : reqVO.getDoctorIds()) {
            DocPatientRelationEntity relationEntity = this.docPatientRelationMapper.getByPatientIdAndDoctorId(Long.valueOf(Long.parseLong(reqVO.getPatientId())), doctor.getDoctorId(), (byte)1);
            if (relationEntity != null) {
                log.info("\u60a3\u8005:{}\uff0c\u5df2\u5173\u6ce8\u533b\u751f{}", (Object)reqVO.getPatientId(), (Object)doctor);
                continue;
            }
            DocRelationGroupEntity groupEntity = (DocRelationGroupEntity)this.docRelationGroupService.getDoctorDefaultGroup(doctor.getDoctorId(), reqVO.getAppCode()).getData();
            if (groupEntity == null) {
                groupEntity = this.addDefaultGroup(reqVO.getAppCode(), doctor.getDoctorId());
            }
            DocPatientRelationEntity docPatientRelation = new DocPatientRelationEntity();
            docPatientRelation.setGroupId(groupEntity.getId());
            docPatientRelation.setPatientId(Long.valueOf(Long.parseLong(reqVO.getPatientId())));
            docPatientRelation.setPatientName(Objects.isNull(patientInfo) ? "" : patientInfo.getName());
            docPatientRelation.setCardNo(Objects.isNull(patientInfo) ? "" : patientInfo.getCredNo());
            docPatientRelation.setPhone(Objects.isNull(patientInfo) ? "" : patientInfo.getContactMobile());
            docPatientRelation.setUserId(String.valueOf(doctor.getUserId()));
            docPatientRelation.setAppCode(reqVO.getAppCode());
            docPatientRelation.setDoctorId(doctor.getDoctorId());
            docPatientRelation.setStatus(Byte.valueOf((byte)1));
            docPatientRelation.setFocusType(Byte.valueOf((byte)1));
            this.docPatientRelationMapper.insertSelective(docPatientRelation);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<BaseTree>> getDoctorTeamTree(String appCode) {
        List organList = this.organizationMapper.queryOrganTree(appCode);
        log.info("\u533b\u9662\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{},\u8fd4\u56de\u503c{}", (Object)appCode, (Object)organList);
        if (CollectionUtils.isEmpty((Collection)organList)) {
            return BaseResponse.success(new ArrayList());
        }
        List organIdList = organList.stream().map(BaseTree::getId).collect(Collectors.toList());
        List departmentList = this.docDepartmentMapper.queryDeptByOrganIds(organIdList);
        HashSet deptList = new HashSet(departmentList.size());
        if (CollectionUtils.isEmpty((Collection)departmentList)) {
            return BaseResponse.success((Object)organList);
        }
        departmentList.forEach(dept -> {
            BaseTree parent = new BaseTree().setPid(Integer.valueOf(dept.getOrganId())).setId(Integer.valueOf(dept.getFirstDeptId())).setLabel(dept.getFirstDeptName());
            deptList.add(parent);
        });
        organList.addAll(deptList);
        log.info("\u79d1\u5ba4\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{},\u8fd4\u56de\u503c{}", organIdList, deptList);
        List deptIdList = departmentList.stream().map(DepartmentVO::getSecondDeptId).distinct().collect(Collectors.toList());
        List teamList = this.doctorTeamInfoMapper.getTeamTree(deptIdList);
        organList.addAll(teamList);
        log.info("\u56e2\u961f\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{},\u8fd4\u56de\u503c{}", deptIdList, (Object)teamList);
        return BaseResponse.success((Object)TreeUtils.createTree((List)organList));
    }

    private GetPatientInfoVo getPatientPhone(String patientId, String appCode) {
        BaseResponse baseResponse = this.docPatientRelationService.getPatientInfoByPatientId(patientId, appCode);
        log.info("\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8fd4\u56de\u503c:{}", (Object)baseResponse);
        if (baseResponse.isSuccess() && baseResponse.getData() != null) {
            return (GetPatientInfoVo)baseResponse.getData();
        }
        return null;
    }

    private DocRelationGroupEntity addDefaultGroup(String appCode, Long doctorId) {
        DocRelationGroupEntity docRelationGroup = this.docRelationGroupMapper.getByNameAndDoctor(appCode, doctorId, DEFAULT_GROUP, 1);
        if (Objects.nonNull(docRelationGroup)) {
            return docRelationGroup;
        }
        DocRelationGroupEntity relationGroupEntity = new DocRelationGroupEntity();
        relationGroupEntity.setDoctorId(doctorId);
        relationGroupEntity.setStatus(Byte.valueOf((byte)1));
        relationGroupEntity.setName(DEFAULT_GROUP);
        relationGroupEntity.setAppCode(appCode);
        relationGroupEntity.setSeq(Byte.valueOf((byte)1));
        this.docRelationGroupMapper.insertSelective(relationGroupEntity);
        return relationGroupEntity;
    }
}

