/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.utils;

import com.doctoruser.doctor.enums.EHErrorEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageUtils.class);
    private static MessageSource messageSource;

    public MessageUtils(MessageSource messageSource) {
        MessageUtils.messageSource = messageSource;
    }

    public static String get(String code) {
        try {
            return messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            log.info("\u56fd\u9645\u5316\u8f6c\u5316\u9519\u8bef\u63d0\u793a\u8bed\u62a5\u9519", (Throwable)e);
            EHErrorEnum anEnum = EHErrorEnum.getEnum((String)code);
            return anEnum != null ? anEnum.getMsg() : null;
        }
    }
}

