/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.token;

import com.doctoruser.token.TokenBody;
import com.doctoruser.token.TokenJson;
import com.doctoruser.token.exception.TokenParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class UserCenterTokenParseUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String SPACE_MARK = "***";

    private static Claims parseJWT(String jwt, String secryKey) throws TokenParseException {
        Claims claims;
        try {
            SecretKey key = UserCenterTokenParseUtil.generalKey(secryKey);
            claims = (Claims)Jwts.parser().setSigningKey((Key)key).parseClaimsJws(jwt).getBody();
        }
        catch (Exception e) {
            throw new TokenParseException(e);
        }
        return claims;
    }

    public static TokenBody parse(String token, String secryKey) throws TokenParseException {
        TokenJson tokenJson;
        int i = token.indexOf(SPACE_MARK);
        if (i > 0) {
            token = token.substring(0, i);
        }
        Claims parseJwt = UserCenterTokenParseUtil.parseJWT(token, secryKey);
        String subject = parseJwt.getSubject();
        try {
            tokenJson = (TokenJson)OBJECT_MAPPER.readValue(subject, TokenJson.class);
        }
        catch (Exception e) {
            throw new TokenParseException(e);
        }
        Date expiration = parseJwt.getExpiration();
        TokenBody tokenBody = new TokenBody();
        tokenBody.setTokenJson(tokenJson);
        tokenBody.setTtl(expiration);
        return tokenBody;
    }

    public static boolean validateToken(String accesstoken, String secryKey) {
        try {
            TokenBody tokenBody = UserCenterTokenParseUtil.parse(accesstoken, secryKey);
            if (tokenBody.getTtl().before(new Date())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean validateToken(TokenBody tokenBody) {
        try {
            if (tokenBody.getTtl().before(new Date())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static SecretKey generalKey(String secryKey) {
        Charset charset = Charset.forName("utf-8");
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] encodedKey = encoder.encode(secryKey.getBytes(charset));
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }
}

