/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.decoration.OBrandStoryResponse;
import eleme.openapi.sdk.api.entity.decoration.OGetAccurateCategoryRequest;
import eleme.openapi.sdk.api.entity.decoration.OImage;
import eleme.openapi.sdk.api.entity.decoration.OInvalidPosterRequest;
import eleme.openapi.sdk.api.entity.decoration.OQueryAccurateCategoryRequest;
import eleme.openapi.sdk.api.entity.decoration.OQuerySignRequest;
import eleme.openapi.sdk.api.entity.decoration.OSaveAccurateCategoryRequest;
import eleme.openapi.sdk.api.entity.decoration.OSaveBrandStoryRequest;
import eleme.openapi.sdk.api.entity.decoration.OSavePosterRequest;
import eleme.openapi.sdk.api.entity.decoration.OSaveShopBurstWindow;
import eleme.openapi.sdk.api.entity.decoration.OSaveShopSignRequest;
import eleme.openapi.sdk.api.entity.decoration.OShopAccurateCategory;
import eleme.openapi.sdk.api.entity.decoration.OShopBurstWindow;
import eleme.openapi.sdk.api.entity.decoration.OShopPosterDetailResponse;
import eleme.openapi.sdk.api.entity.decoration.OShopPosterResponse;
import eleme.openapi.sdk.api.entity.decoration.OShopSignDetailResponse;
import eleme.openapi.sdk.api.entity.decoration.OShopSignResponse;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.decoration")
public class DecorationService
extends BaseNopService {
    public DecorationService(Config config, Token token) {
        super(config, token, DecorationService.class);
    }

    public long createSign(OSaveShopSignRequest sign) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sign", sign);
        return (Long)this.call("eleme.decoration.sign.createSign", params);
    }

    public long updateSign(long signId, OSaveShopSignRequest sign) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("signId", signId);
        params.put("sign", sign);
        return (Long)this.call("eleme.decoration.sign.updateSign", params);
    }

    public void invalidSign(long signId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("signId", signId);
        this.call("eleme.decoration.sign.invalidSign", params);
    }

    public List<OImage> getSignHistoryImage(OQuerySignRequest sign) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sign", sign);
        return (List)this.call("eleme.decoration.sign.getSignHistoryImage", params);
    }

    public List<OShopSignResponse> querySign() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (List)this.call("eleme.decoration.sign.querySign", params);
    }

    public OShopSignDetailResponse getSignById(long signId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("signId", signId);
        return (OShopSignDetailResponse)this.call("eleme.decoration.sign.getSignById", params);
    }

    public long createBrandStory(OSaveBrandStoryRequest story) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("story", story);
        return (Long)this.call("eleme.decoration.story.createBrandStory", params);
    }

    public long updateBrandStory(Long brandStoryId, OSaveBrandStoryRequest story) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("brandStoryId", brandStoryId);
        params.put("story", story);
        return (Long)this.call("eleme.decoration.story.updateBrandStory", params);
    }

    public long deleteBrandStory(Long brandStoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("brandStoryId", brandStoryId);
        return (Long)this.call("eleme.decoration.story.deleteBrandStory", params);
    }

    public List<OBrandStoryResponse> queryBrandStoryList() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (List)this.call("eleme.decoration.story.queryBrandStoryList", params);
    }

    public OBrandStoryResponse getBrandStoryById(long brandStoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("brandStoryId", brandStoryId);
        return (OBrandStoryResponse)this.call("eleme.decoration.story.getBrandStoryById", params);
    }

    public void saveCategory(OSaveAccurateCategoryRequest category) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        this.call("eleme.decoration.accurateCategory.saveCategory", params);
    }

    public OShopAccurateCategory getAccurateCategory(OGetAccurateCategoryRequest category) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        return (OShopAccurateCategory)this.call("eleme.decoration.accurateCategory.getAccurateCategory", params);
    }

    public List<OShopAccurateCategory> queryAccurateCategoryList(OQueryAccurateCategoryRequest category) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        return (List)this.call("eleme.decoration.accurateCategory.queryAccurateCategoryList", params);
    }

    public Long createPoster(OSavePosterRequest poster) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("poster", poster);
        return (Long)this.call("eleme.decoration.poster.createPoster", params);
    }

    public void updatePoster(Long posterId, OSavePosterRequest poster) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("posterId", posterId);
        params.put("poster", poster);
        this.call("eleme.decoration.poster.updatePoster", params);
    }

    public void invalidPoster(OInvalidPosterRequest poster) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("poster", poster);
        this.call("eleme.decoration.poster.invalidPoster", params);
    }

    public OShopPosterDetailResponse getPosterDetailById(Long posterId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("posterId", posterId);
        return (OShopPosterDetailResponse)this.call("eleme.decoration.poster.getPosterDetailById", params);
    }

    public List<OShopPosterResponse> queryEffectivePosters() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (List)this.call("eleme.decoration.poster.queryEffectivePosters", params);
    }

    public List<OImage> getPosterHistoryImage() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (List)this.call("eleme.decoration.poster.getPosterHistoryImage", params);
    }

    public void saveBurstWindow(OSaveShopBurstWindow burstWindow) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("burstWindow", burstWindow);
        this.call("eleme.decoration.burstWindow.saveBurstWindow", params);
    }

    public void closeBurstWindowByShopId(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        this.call("eleme.decoration.burstWindow.closeBurstWindowByShopId", params);
    }

    public OShopBurstWindow getBurstWindowByShopId(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OShopBurstWindow)this.call("eleme.decoration.burstWindow.getBurstWindowByShopId", params);
    }

    public List<OShopBurstWindow> queryBurstWindowList(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.decoration.burstWindow.queryBurstWindowList", params);
    }

    public OImage upload(String image) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("image", image);
        return (OImage)this.call("eleme.decoration.image.upload", params);
    }

    public OImage getImage(String hash) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hash", hash);
        return (OImage)this.call("eleme.decoration.image.getImage", params);
    }
}

