/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.order.CommodityInfo;
import eleme.openapi.sdk.api.entity.order.CompensationInfo;
import eleme.openapi.sdk.api.entity.order.CompensationOrder;
import eleme.openapi.sdk.api.entity.order.CompensationRequest;
import eleme.openapi.sdk.api.entity.order.DeliveryRouteInfo;
import eleme.openapi.sdk.api.entity.order.EvaluationInfo;
import eleme.openapi.sdk.api.entity.order.FeeInfo;
import eleme.openapi.sdk.api.entity.order.OCommodity;
import eleme.openapi.sdk.api.entity.order.ODeliveryRecord;
import eleme.openapi.sdk.api.entity.order.OLocationInfo;
import eleme.openapi.sdk.api.entity.order.OOrder;
import eleme.openapi.sdk.api.entity.order.ORefundOrder;
import eleme.openapi.sdk.api.entity.order.ORefundOrderMessage;
import eleme.openapi.sdk.api.entity.order.OReminder;
import eleme.openapi.sdk.api.entity.order.OSelfDeliveryStateInfo;
import eleme.openapi.sdk.api.entity.order.OUserSimpleInfo;
import eleme.openapi.sdk.api.entity.order.OrderList;
import eleme.openapi.sdk.api.enumeration.order.EvaluationStatus;
import eleme.openapi.sdk.api.enumeration.order.OInvalidateType;
import eleme.openapi.sdk.api.enumeration.order.ReplyReminderType;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(value="eleme.order")
public class OrderService
extends BaseNopService {
    public OrderService(Config config, Token token) {
        super(config, token, OrderService.class);
    }

    public DeliveryRouteInfo getDeliveryRoutes(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (DeliveryRouteInfo)this.call("eleme.order.delivery.getDeliveryRoutes", params);
    }

    public OOrder getOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OOrder)this.call("eleme.order.getOrder", params);
    }

    public Map<String, OOrder> mgetOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetOrders", params);
    }

    public void confirmOrderLite(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.confirmOrderLite", params);
    }

    public void cancelOrderLite(String orderId, OInvalidateType type, String remark) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("type", (Object)type);
        params.put("remark", remark);
        this.call("eleme.order.cancelOrderLite", params);
    }

    public void agreeRefundLite(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.agreeRefundLite", params);
    }

    public void disagreeRefundLite(String orderId, String reason) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("reason", reason);
        this.call("eleme.order.disagreeRefundLite", params);
    }

    public List<ODeliveryRecord> getDeliveryStateRecord(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (List)this.call("eleme.order.getDeliveryStateRecord", params);
    }

    public Map<String, ODeliveryRecord> batchGetDeliveryStates(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.batchGetDeliveryStates", params);
    }

    public void deliveryBySelfLite(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.deliveryBySelfLite", params);
    }

    public void noMoreDeliveryLite(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.noMoreDeliveryLite", params);
    }

    public void receivedOrderLite(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.receivedOrderLite", params);
    }

    public void startDeliveryBySelf(String orderId, String phone) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("phone", phone);
        this.call("eleme.order.startDeliveryBySelf", params);
    }

    public void completeDeliveryBySelf(String orderId, String phone) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("phone", phone);
        this.call("eleme.order.completeDeliveryBySelf", params);
    }

    public void replyReminder(String remindId, ReplyReminderType type, String content) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("remindId", remindId);
        params.put("type", (Object)type);
        params.put("content", content);
        this.call("eleme.order.replyReminder", params);
    }

    public Map<String, OCommodity> getCommodities(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (Map)this.call("eleme.order.getCommodities", params);
    }

    public Map<String, Map<String, OCommodity>> mgetCommodities(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetCommodities", params);
    }

    public ORefundOrder getRefundOrder(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (ORefundOrder)this.call("eleme.order.getRefundOrder", params);
    }

    public Map<String, ORefundOrder> mgetRefundOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetRefundOrders", params);
    }

    public void cancelDelivery(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.cancelDelivery", params);
    }

    public void callDelivery(String orderId, Integer fee) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("fee", fee);
        this.call("eleme.order.callDelivery", params);
    }

    public List<OReminder> getUnreplyReminders(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.order.getUnreplyReminders", params);
    }

    public List<String> getUnprocessOrders(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.order.getUnprocessOrders", params);
    }

    public List<String> getCancelOrders(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.order.getCancelOrders", params);
    }

    public List<String> getRefundOrders(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.order.getRefundOrders", params);
    }

    public OrderList getAllOrders(long shopId, int pageNo, int pageSize, String date) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("pageNo", pageNo);
        params.put("pageSize", pageSize);
        params.put("date", date);
        return (OrderList)this.call("eleme.order.getAllOrders", params);
    }

    public Map<String, CompensationOrder> querySupportedCompensationOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.querySupportedCompensationOrders", params);
    }

    public Map<String, Boolean> batchApplyCompensations(List<CompensationRequest> requests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requests", requests);
        return (Map)this.call("eleme.order.batchApplyCompensations", params);
    }

    public Map<String, CompensationInfo> queryCompensationOrders(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.queryCompensationOrders", params);
    }

    public double getDeliveryFeeForCrowd(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (Double)this.call("eleme.order.getDeliveryFeeForCrowd", params);
    }

    public void evaluateRider(String orderId, EvaluationInfo evaluationInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("evaluationInfo", evaluationInfo);
        this.call("eleme.order.evaluateRider", params);
    }

    public Map<String, EvaluationInfo> mgetEvaluationInfos(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetEvaluationInfos", params);
    }

    public Map<String, EvaluationStatus> mgetEvaluationStatus(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetEvaluationStatus", params);
    }

    public Map<String, FeeInfo> mgetDeliveryTipInfos(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetDeliveryTipInfos", params);
    }

    public void addDeliveryTipByOrderId(String orderId, Integer tip) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("tip", tip);
        this.call("eleme.order.addDeliveryTipByOrderId", params);
    }

    public void applyRefund(String orderId, OInvalidateType type, String remark) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("type", (Object)type);
        params.put("remark", remark);
        this.call("eleme.order.applyRefund", params);
    }

    public void setOrderPrepared(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        this.call("eleme.order.setOrderPrepared", params);
    }

    public Map<String, String> getPreparedTimesByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.getPreparedTimesByOrderIds", params);
    }

    public Map<String, OUserSimpleInfo> mgetUserSimpleInfoByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (Map)this.call("eleme.order.mgetUserSimpleInfoByOrderIds", params);
    }

    public void refundPart(String orderId, ORefundOrderMessage refundOrderMessage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("refundOrderMessage", refundOrderMessage);
        this.call("eleme.order.refundPart", params);
    }

    public void setInvoiceUrl(String orderId, String invoiceUrl) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("invoiceUrl", invoiceUrl);
        this.call("eleme.order.setInvoiceUrl", params);
    }

    public void selfDeliveryStateSync(long shopId, OSelfDeliveryStateInfo stateInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("stateInfo", stateInfo);
        this.call("eleme.order.selfDeliveryStateSync", params);
    }

    public void selfDeliveryLocationSync(long shopId, String orderId, OLocationInfo locationInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("orderId", orderId);
        params.put("locationInfo", locationInfo);
        this.call("eleme.order.selfDeliveryLocationSync", params);
    }

    public void orderPredictFinishTime(String orderId, String predictTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("predictTime", predictTime);
        this.call("eleme.order.orderPredictFinishTime", params);
    }

    public void commodityPredictFinishTime(long shopId, CommodityInfo commodityInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("commodityInfo", commodityInfo);
        this.call("eleme.order.commodityPredictFinishTime", params);
    }

    public void commodityActualFinishTime(long shopId, CommodityInfo commodityInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("commodityInfo", commodityInfo);
        this.call("eleme.order.commodityActualFinishTime", params);
    }

    public String queryCallAvailable(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (String)this.call("eleme.order.queryCallAvailable", params);
    }
}

