/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.product.BatchChainGroupResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchChainItemResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchIdResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchReplaceChainItemResultDTO;
import eleme.openapi.sdk.api.entity.product.CategoryWithChildrenIds;
import eleme.openapi.sdk.api.entity.product.ChainGroupBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainGroupDTO;
import eleme.openapi.sdk.api.entity.product.ChainGroupWithItemDTO;
import eleme.openapi.sdk.api.entity.product.ChainItemBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainItemDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuWithGroupDTO;
import eleme.openapi.sdk.api.entity.product.ChainSkuBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainSkuDTO;
import eleme.openapi.sdk.api.entity.product.ClearStock;
import eleme.openapi.sdk.api.entity.product.DayPartingStick;
import eleme.openapi.sdk.api.entity.product.IngredientGroup;
import eleme.openapi.sdk.api.entity.product.MaterialTree;
import eleme.openapi.sdk.api.entity.product.OBackCategory;
import eleme.openapi.sdk.api.entity.product.OBatchModifiedResult;
import eleme.openapi.sdk.api.entity.product.OCategory;
import eleme.openapi.sdk.api.entity.product.OIngredientGroupDTO;
import eleme.openapi.sdk.api.entity.product.OIngredientGroupRelation;
import eleme.openapi.sdk.api.entity.product.OItem;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecIds;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecPrice;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecStock;
import eleme.openapi.sdk.api.entity.product.OPackage;
import eleme.openapi.sdk.api.entity.product.OPackageGroup;
import eleme.openapi.sdk.api.entity.product.OPackageUpdate;
import eleme.openapi.sdk.api.entity.product.QueryPage;
import eleme.openapi.sdk.api.entity.product.SingleShopSkuDTO;
import eleme.openapi.sdk.api.enumeration.product.OCategoryType;
import eleme.openapi.sdk.api.enumeration.product.OItemCreateProperty;
import eleme.openapi.sdk.api.enumeration.product.OItemUpdateProperty;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(value="eleme.product")
public class ProductService
extends BaseNopService {
    public ProductService(Config config, Token token) {
        super(config, token, ProductService.class);
    }

    public ChainMenuWithGroupDTO getMenuWithGroup(String mid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        return (ChainMenuWithGroupDTO)this.call("eleme.product.chain.menu.getMenuWithGroup", params);
    }

    public List<ChainMenuDTO> queryMenuByPage(Long offset, Long limit) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        return (List)this.call("eleme.product.chain.menu.queryMenuByPage", params);
    }

    public ChainMenuDTO createMenu(ChainMenuBaseDTO chainMenuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainMenuBaseDTO", chainMenuBaseDTO);
        return (ChainMenuDTO)this.call("eleme.product.chain.menu.createMenu", params);
    }

    public ChainMenuDTO updateMenu(String mid, ChainMenuBaseDTO chainMenuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainMenuBaseDTO", chainMenuBaseDTO);
        return (ChainMenuDTO)this.call("eleme.product.chain.menu.updateMenu", params);
    }

    public void deleteMenu(String mid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        this.call("eleme.product.chain.menu.deleteMenu", params);
    }

    public ChainGroupDTO getGroup(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.getGroup", params);
    }

    public ChainGroupWithItemDTO getGroupWithItem(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        return (ChainGroupWithItemDTO)this.call("eleme.product.chain.group.getGroupWithItem", params);
    }

    public ChainGroupDTO createGroup(String mid, ChainGroupBaseDTO chainGroupBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainGroupBaseDTO", chainGroupBaseDTO);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.createGroup", params);
    }

    public BatchChainGroupResultDTO batchCreateGroup(String mid, List<ChainGroupBaseDTO> chainGroupBaseDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainGroupBaseDTOs", chainGroupBaseDTOs);
        return (BatchChainGroupResultDTO)this.call("eleme.product.chain.group.batchCreateGroup", params);
    }

    public ChainGroupDTO updateGroup(String gid, ChainGroupBaseDTO chainGroupBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainGroupBaseDTO", chainGroupBaseDTO);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.updateGroup", params);
    }

    public void deleteGroup(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        this.call("eleme.product.chain.group.deleteGroup", params);
    }

    public List<SingleShopSkuDTO> getRelationByPid(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        return (List)this.call("eleme.product.chain.pid.getRelationByPid", params);
    }

    public void setPid(String pId, Long specId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("specId", specId);
        this.call("eleme.product.chain.pid.setPid", params);
    }

    public BatchIdResultDTO batchSetPid(String pId, List<Long> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("specIds", specIds);
        return (BatchIdResultDTO)this.call("eleme.product.chain.pid.batchSetPid", params);
    }

    public void deletePidBySpecId(Long specId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        this.call("eleme.product.chain.pid.deletePidBySpecId", params);
    }

    public BatchIdResultDTO batchDeletePidBySpecId(List<Long> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        return (BatchIdResultDTO)this.call("eleme.product.chain.pid.batchDeletePidBySpecId", params);
    }

    public List<OCategory> getShopCategories(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getShopCategories", params);
    }

    public List<OCategory> getShopCategoriesWithChildren(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getShopCategoriesWithChildren", params);
    }

    public OCategory getCategory(Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.getCategory", params);
    }

    public OCategory getCategoryWithChildren(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.getCategoryWithChildren", params);
    }

    public OCategory createCategory(long shopId, String name, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("name", name);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.createCategory", params);
    }

    public OCategory createCategoryWithChildren(long shopId, String name, long parentId, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("name", name);
        params.put("parentId", parentId);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.createCategoryWithChildren", params);
    }

    public OCategory updateCategory(long categoryId, String name, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("name", name);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.updateCategory", params);
    }

    public OCategory updateCategoryWithChildren(long categoryId, String name, long parentId, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("name", name);
        params.put("parentId", parentId);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.updateCategoryWithChildren", params);
    }

    public OCategory removeCategory(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.removeCategory", params);
    }

    public void invalidCategory(Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        this.call("eleme.product.category.invalidCategory", params);
    }

    public void setCategoryPositions(Long shopId, List<Long> categoryIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryIds", categoryIds);
        this.call("eleme.product.category.setCategoryPositions", params);
    }

    public void setCategorySequence(Long shopId, List<Long> categoryIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryIds", categoryIds);
        this.call("eleme.product.category.setCategorySequence", params);
    }

    public void setCategoryPositionsWithChildren(Long shopId, List<CategoryWithChildrenIds> categoryWithChildrenIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryWithChildrenIds", categoryWithChildrenIds);
        this.call("eleme.product.category.setCategoryPositionsWithChildren", params);
    }

    public List<OBackCategory> getBackCategory(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getBackCategory", params);
    }

    public void setCategoryType(Long shopId, Long categoryId, OCategoryType categoryType) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        params.put("categoryType", (Object)categoryType);
        this.call("eleme.product.category.setCategoryType", params);
    }

    public OCategory setDayPartingStickTime(Long shopId, Long categoryId, DayPartingStick dayPartingStick) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        params.put("dayPartingStick", dayPartingStick);
        return (OCategory)this.call("eleme.product.category.setDayPartingStickTime", params);
    }

    public boolean removeDayPartingStickTime(Long shopId, Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        return (Boolean)this.call("eleme.product.category.removeDayPartingStickTime", params);
    }

    public OItem createPackage(long categoryId, OPackage oPackage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("oPackage", oPackage);
        return (OItem)this.call("eleme.product.package.createPackage", params);
    }

    public OItem updatePackageContent(long itemId, long categoryId, OPackageUpdate update) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("update", update);
        return (OItem)this.call("eleme.product.package.updatePackageContent", params);
    }

    public OItem updatePackageRelation(long itemId, List<OPackageGroup> packages) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("packages", packages);
        return (OItem)this.call("eleme.product.package.updatePackageRelation", params);
    }

    public void removePackage(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.package.removePackage", params);
    }

    public Map<Long, OItem> getItemsByCategoryId(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (Map)this.call("eleme.product.item.getItemsByCategoryId", params);
    }

    public OItem getItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        return (OItem)this.call("eleme.product.item.getItem", params);
    }

    public Map<Long, OItem> batchGetItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchGetItems", params);
    }

    public OItem createItem(long categoryId, Map<OItemCreateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.createItem", params);
    }

    public Map<Long, OItem> batchCreateItems(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateItems", params);
    }

    public Map<Long, OItem> batchCreateItemsIgnoreError(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateItemsIgnoreError", params);
    }

    public OItem updateItem(long itemId, long categoryId, Map<OItemUpdateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.updateItem", params);
    }

    public void batchFillStock(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchFillStock", params);
    }

    public void batchClearStock(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchClearStock", params);
    }

    public void batchOnShelf(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchOnShelf", params);
    }

    public OBatchModifiedResult batchListItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchListItems", params);
    }

    public void batchOffShelf(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchOffShelf", params);
    }

    public OBatchModifiedResult batchDelistItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchDelistItems", params);
    }

    public OItem removeItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        return (OItem)this.call("eleme.product.item.removeItem", params);
    }

    public void invalidItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.invalidItem", params);
    }

    public Map<Long, OItem> batchRemoveItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchRemoveItems", params);
    }

    public void batchUpdateSpecStocks(List<OItemIdWithSpecStock> specStocks) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specStocks", specStocks);
        this.call("eleme.product.item.batchUpdateSpecStocks", params);
    }

    public OBatchModifiedResult batchUpdateStock(Map<Long, Integer> stockMap) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stockMap", stockMap);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchUpdateStock", params);
    }

    public void setItemPositions(Long categoryId, List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("itemIds", itemIds);
        this.call("eleme.product.item.setItemPositions", params);
    }

    public void clearAndTimingMaxStock(List<ClearStock> clearStocks) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clearStocks", clearStocks);
        this.call("eleme.product.item.clearAndTimingMaxStock", params);
    }

    public OItem getItemByShopIdAndExtendCode(Long shopId, String extendCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("extendCode", extendCode);
        return (OItem)this.call("eleme.product.item.getItemByShopIdAndExtendCode", params);
    }

    public List<OItem> getItemsByShopIdAndBarCode(Long shopId, String barCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("barCode", barCode);
        return (List)this.call("eleme.product.item.getItemsByShopIdAndBarCode", params);
    }

    public void batchUpdatePrices(Long shopId, List<OItemIdWithSpecPrice> specPrices) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("specPrices", specPrices);
        this.call("eleme.product.item.batchUpdatePrices", params);
    }

    public List<Long> getItemIdsHasActivityByShopId(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getItemIdsHasActivityByShopId", params);
    }

    public List<Long> getShopSalesItems(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getShopSalesItems", params);
    }

    public void setOrderPackingFee(Long shopId, boolean status, Double packingFee) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("status", status);
        params.put("packingFee", packingFee);
        this.call("eleme.product.item.setOrderPackingFee", params);
    }

    public List<OItem> queryItemByPage(QueryPage queryPage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryPage", queryPage);
        return (List)this.call("eleme.product.item.queryItemByPage", params);
    }

    public List<MaterialTree> getMaterialTree(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getMaterialTree", params);
    }

    public void setIngredient(Long shopId, Long mainItemId, IngredientGroup ingredientGroup) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mainItemId", mainItemId);
        params.put("ingredientGroup", ingredientGroup);
        this.call("eleme.product.item.setIngredient", params);
    }

    public void removeIngredient(Long shopId, Long mainItemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mainItemId", mainItemId);
        this.call("eleme.product.item.removeIngredient", params);
    }

    public void setRelatedItemIds(Long shopId, Long itemId, List<Long> relatedItemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("relatedItemIds", relatedItemIds);
        this.call("eleme.product.item.setRelatedItemIds", params);
    }

    public boolean displayRelatedItemIds(Long shopId, Long itemId, boolean display) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("display", display);
        return (Boolean)this.call("eleme.product.item.displayRelatedItemIds", params);
    }

    public Map<Long, List<Long>> getRelatedItemIds(Long shopId, Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        return (Map)this.call("eleme.product.item.getRelatedItemIds", params);
    }

    public OItem createMultiSpecItem(long categoryId, Map<OItemCreateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.createMultiSpecItem", params);
    }

    public Map<Long, OItem> batchCreateMultiSpecItem(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateMultiSpecItem", params);
    }

    public OItem updateMultiSpecItem(long itemId, long categoryId, Map<OItemUpdateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.updateMultiSpecItem", params);
    }

    public void setIngredientGroup(long itemId, List<OIngredientGroupRelation> groupRelations) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("groupRelations", groupRelations);
        this.call("eleme.product.item.setIngredientGroup", params);
    }

    public void removeIngredientGroup(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.removeIngredientGroup", params);
    }

    public List<MaterialTree> getItemMaterialTree(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getItemMaterialTree", params);
    }

    public OIngredientGroupDTO createIngredientGroup(OIngredientGroupDTO ingredientGroup) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroup", ingredientGroup);
        return (OIngredientGroupDTO)this.call("eleme.product.item.createIngredientGroup", params);
    }

    public List<OIngredientGroupDTO> batchCreateIngredientGroups(List<OIngredientGroupDTO> ingredientGroups) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroups", ingredientGroups);
        return (List)this.call("eleme.product.item.batchCreateIngredientGroups", params);
    }

    public OIngredientGroupDTO getIngredientGroup(Long ingredientGroupId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupId", ingredientGroupId);
        return (OIngredientGroupDTO)this.call("eleme.product.item.getIngredientGroup", params);
    }

    public List<OIngredientGroupDTO> listIngredientGroups(List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupIds", ingredientGroupIds);
        return (List)this.call("eleme.product.item.listIngredientGroups", params);
    }

    public void deleteIngredientGroup(Long ingredientGroupId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupId", ingredientGroupId);
        this.call("eleme.product.item.deleteIngredientGroup", params);
    }

    public void bindIngredientGroups(Long itemId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.bindIngredientGroups", params);
    }

    public void unbindIngredientGroups(Long itemId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.unbindIngredientGroups", params);
    }

    public void removeMainItemIngredientGroups(Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.removeMainItemIngredientGroups", params);
    }

    public void updateItemGroup(Long shopId, Long itemId, Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        this.call("eleme.product.item.updateItemGroup", params);
    }

    public ChainItemDTO getChainItem(String iid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        return (ChainItemDTO)this.call("eleme.product.chain.item.getChainItem", params);
    }

    public List<ChainItemDTO> batchGetChainItem(List<String> iids) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iids", iids);
        return (List)this.call("eleme.product.chain.item.batchGetChainItem", params);
    }

    public ChainItemDTO createChainItem(String gid, ChainItemBaseDTO chainItemBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemBaseDTO", chainItemBaseDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.createChainItem", params);
    }

    public BatchChainItemResultDTO batchCreateChainItem(String gid, List<ChainItemBaseDTO> chainItemBaseDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemBaseDTOs", chainItemBaseDTOs);
        return (BatchChainItemResultDTO)this.call("eleme.product.chain.item.batchCreateChainItem", params);
    }

    public ChainItemDTO replaceChainItem(String gid, ChainItemDTO chainItemDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemDTO", chainItemDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.replaceChainItem", params);
    }

    public BatchReplaceChainItemResultDTO batchReplaceChainItem(String gid, List<ChainItemDTO> chainItemDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemDTOs", chainItemDTOs);
        return (BatchReplaceChainItemResultDTO)this.call("eleme.product.chain.item.batchReplaceChainItem", params);
    }

    public ChainItemDTO updateChainItemWithoutSku(String iid, ChainItemBaseDTO chainItemBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        params.put("chainItemBaseDTO", chainItemBaseDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.updateChainItemWithoutSku", params);
    }

    public void deleteChainItem(String iid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        this.call("eleme.product.chain.item.deleteChainItem", params);
    }

    public ChainSkuDTO getSku(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.getSku", params);
    }

    public ChainSkuDTO addSku(String iid, ChainSkuBaseDTO chainSkuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        params.put("chainSkuBaseDTO", chainSkuBaseDTO);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.addSku", params);
    }

    public ChainSkuDTO updateSku(String pId, ChainSkuBaseDTO chainSkuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("chainSkuBaseDTO", chainSkuBaseDTO);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.updateSku", params);
    }

    public void deleteSku(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        this.call("eleme.product.chain.item.deleteSku", params);
    }

    public String uploadImage(String image) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("image", image);
        return (String)this.call("eleme.file.uploadImage", params);
    }

    public String uploadImageWithRemoteUrl(String url) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        return (String)this.call("eleme.file.uploadImageWithRemoteUrl", params);
    }

    public String getUploadedUrl(String hash) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hash", hash);
        return (String)this.call("eleme.file.getUploadedUrl", params);
    }

    public String getImageUrl(String hash) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hash", hash);
        return (String)this.call("eleme.file.getImageUrl", params);
    }
}

