/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.data.OChainSaleDetail;
import eleme.openapi.sdk.api.entity.data.ORestaurantFlowData;
import eleme.openapi.sdk.api.entity.data.ORestaurantSaleDetail;
import eleme.openapi.sdk.api.entity.data.ORestaurantSaleGrowthRatio;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.data")
public class DataService
extends BaseNopService {
    public DataService(Config config, Token token) {
        super(config, token, DataService.class);
    }

    public ORestaurantSaleDetail getRestaurantSaleDetail(Long shopId, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return (ORestaurantSaleDetail)this.call("eleme.data.single.getRestaurantSaleDetail", params);
    }

    public ORestaurantSaleDetail getRestaurantRealTimeSaleDetail(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ORestaurantSaleDetail)this.call("eleme.data.single.getRestaurantRealTimeSaleDetail", params);
    }

    public ORestaurantSaleGrowthRatio getRestaurantSaleRatio(Long shopId, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return (ORestaurantSaleGrowthRatio)this.call("eleme.data.single.getRestaurantSaleRatio", params);
    }

    public ORestaurantFlowData getRestaurantFlowData(Long shopId, String date) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("date", date);
        return (ORestaurantFlowData)this.call("eleme.data.single.getRestaurantFlowData", params);
    }

    public OChainSaleDetail getChainRestaurantSaleDetail(List<Long> shopIds, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return (OChainSaleDetail)this.call("eleme.data.chain.getChainRestaurantSaleDetail", params);
    }

    public OChainSaleDetail getChainRealTimeSaleDetail(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (OChainSaleDetail)this.call("eleme.data.chain.getChainRealTimeSaleDetail", params);
    }

    public ORestaurantSaleGrowthRatio getChainRestaurantSaleRatio(List<Long> shopIds, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return (ORestaurantSaleGrowthRatio)this.call("eleme.data.chain.getChainRestaurantSaleRatio", params);
    }
}

