/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.finance.AllowanceBillDetails;
import eleme.openapi.sdk.api.entity.finance.AllowanceBills;
import eleme.openapi.sdk.api.entity.finance.BalanceResponse;
import eleme.openapi.sdk.api.entity.finance.Bills;
import eleme.openapi.sdk.api.entity.finance.BillsNew;
import eleme.openapi.sdk.api.entity.finance.BranchQuery;
import eleme.openapi.sdk.api.entity.finance.FinanceOrders;
import eleme.openapi.sdk.api.entity.finance.FinanceOrdersNew;
import eleme.openapi.sdk.api.entity.finance.FundRelationsRequest;
import eleme.openapi.sdk.api.entity.finance.FundRelationsResponse;
import eleme.openapi.sdk.api.entity.finance.HeadQuery;
import eleme.openapi.sdk.api.entity.finance.OBalanceLogResponse;
import eleme.openapi.sdk.api.entity.finance.OQueryBalanceLogRequest;
import eleme.openapi.sdk.api.entity.finance.OQueryBalanceResponse;
import eleme.openapi.sdk.api.entity.finance.TermAndNameQuery;
import eleme.openapi.sdk.api.entity.finance.TermAndNameResult;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.finance")
public class FinanceService
extends BaseNopService {
    public FinanceService(Config config, Token token) {
        super(config, token, FinanceService.class);
    }

    public OQueryBalanceResponse queryBalance(int shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OQueryBalanceResponse)this.call("eleme.finance.queryBalance", params);
    }

    public BalanceResponse queryNewBalance(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (BalanceResponse)this.call("eleme.finance.queryNewBalance", params);
    }

    public OBalanceLogResponse queryBalanceLog(OQueryBalanceLogRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return (OBalanceLogResponse)this.call("eleme.finance.queryBalanceLog", params);
    }

    public Bills queryHeadBills(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (Bills)this.call("eleme.finance.queryHeadBills", params);
    }

    public BillsNew queryHeadBillsNew(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (BillsNew)this.call("eleme.finance.queryHeadBillsNew", params);
    }

    public FinanceOrders queryHeadOrders(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrders)this.call("eleme.finance.queryHeadOrders", params);
    }

    public FinanceOrdersNew queryHeadOrdersNew(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrdersNew)this.call("eleme.finance.queryHeadOrdersNew", params);
    }

    public Bills queryBranchBills(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (Bills)this.call("eleme.finance.queryBranchBills", params);
    }

    public BillsNew queryBranchBillsNew(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (BillsNew)this.call("eleme.finance.queryBranchBillsNew", params);
    }

    public FinanceOrders queryBranchOrders(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrders)this.call("eleme.finance.queryBranchOrders", params);
    }

    public FinanceOrdersNew queryBranchOrdersNew(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (FinanceOrdersNew)this.call("eleme.finance.queryBranchOrdersNew", params);
    }

    public FinanceOrders getOrder(Long shopId, String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("orderId", orderId);
        return (FinanceOrders)this.call("eleme.finance.getOrder", params);
    }

    public FinanceOrdersNew getOrderNew(Long shopId, String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("orderId", orderId);
        return (FinanceOrdersNew)this.call("eleme.finance.getOrderNew", params);
    }

    public AllowanceBills queryAllowanceBills(Long shopId, BranchQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (AllowanceBills)this.call("eleme.finance.queryAllowanceBills", params);
    }

    public AllowanceBillDetails queryAllowanceBillDetail(Long shopId, HeadQuery query) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("query", query);
        return (AllowanceBillDetails)this.call("eleme.finance.queryAllowanceBillDetail", params);
    }

    public TermAndNameResult queryTermAndName(TermAndNameQuery termAndNameQuery) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("termAndNameQuery", termAndNameQuery);
        return (TermAndNameResult)this.call("eleme.finance.queryTermAndName", params);
    }

    public List<FundRelationsResponse> queryBySlave(FundRelationsRequest relationsRequest) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("relationsRequest", relationsRequest);
        return (List)this.call("eleme.finance.queryBySlave", params);
    }
}

