/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.market.FileUploadSignatureInfo;
import eleme.openapi.sdk.api.entity.market.ImageInfo;
import eleme.openapi.sdk.api.entity.market.LogisticInfo;
import eleme.openapi.sdk.api.entity.market.MarketMessages;
import eleme.openapi.sdk.api.entity.market.ODeviceInfo;
import eleme.openapi.sdk.api.entity.market.OrderQueryResponse;
import eleme.openapi.sdk.api.entity.market.OrderRequest;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.market")
public class MarketService
extends BaseNopService {
    public MarketService(Config config, Token token) {
        super(config, token, MarketService.class);
    }

    public MarketMessages syncMarketMessages(Date start, Date end, int offset, int limit) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("start", start);
        params.put("end", end);
        params.put("offset", offset);
        params.put("limit", limit);
        return (MarketMessages)this.call("eleme.market.syncMarketMessages", params);
    }

    public String createOrder(OrderRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return (String)this.call("eleme.market.createOrder", params);
    }

    public OrderQueryResponse queryOrder(String orderNo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderNo", orderNo);
        return (OrderQueryResponse)this.call("eleme.market.queryOrder", params);
    }

    public void confirmOrder(String orderNo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderNo", orderNo);
        this.call("eleme.market.confirmOrder", params);
    }

    public void markFinishCookingTime(ODeviceInfo deviceInfo, String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deviceInfo", deviceInfo);
        params.put("orderId", orderId);
        this.call("eleme.market.markFinishCookingTime", params);
    }

    public void uploadLogisticInfo(List<LogisticInfo> logisticInfos) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logisticInfos", logisticInfos);
        this.call("eleme.market.uploadLogisticInfo", params);
    }

    public FileUploadSignatureInfo getUploadFileSignatureInfo() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (FileUploadSignatureInfo)this.call("eleme.market.getUploadFileSignatureInfo", params);
    }

    public void uploadImageInfo(List<ImageInfo> imageInfos) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageInfos", imageInfos);
        this.call("eleme.market.uploadImageInfo", params);
    }
}

