/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media;

import eleme.openapi.sdk.utils.JacksonUtils;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -6753637594891783185L;
    private String requestId;
    private int httpStatus;
    private String code;
    private String message;
    private boolean success;
    private T data;
    private Throwable t;

    public static <T> Result<T> create(int httpStatus, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setHttpStatus(httpStatus);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> create(int httpStatus, T data, String requestId) {
        Result<T> result = Result.create(httpStatus, data);
        result.setRequestId(requestId);
        return result;
    }

    public static <T> Result<T> create(Throwable t) {
        return Result.create(0, null, "ClientError", t.getMessage());
    }

    public static <T> Result<T> create(int httpStatus, String requestId, String code, String message) {
        Result<T> result = new Result<T>();
        result.setSuccess(false);
        result.setRequestId(requestId);
        result.setHttpStatus(httpStatus);
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Throwable getT() {
        return this.t;
    }

    public void setT(Throwable t) {
        this.t = t;
    }

    public String toString() {
        return JacksonUtils.obj2json(this);
    }
}

