/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eleme.openapi.sdk.api.exception.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtils() {
    }

    public static final ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String obj2json(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T json2pojo(String jsonStr, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> T json2pojo(String jsonStr, JavaType javaType) {
        try {
            return (T)objectMapper.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> Map<String, Object> json2map(String jsonStr) {
        try {
            return (Map)objectMapper.readValue(jsonStr, Map.class);
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
    }

    public static <T> Map<String, T> json2map(String jsonStr, Class<T> clazz) {
        Map map;
        try {
            map = (Map)objectMapper.readValue(jsonStr, new TypeReference<Map<String, T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JacksonUtils.map2pojo((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> json2list(String jsonArrayStr, Class<T> clazz) {
        List list = null;
        try {
            list = (List)objectMapper.readValue(jsonArrayStr, new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            throw new JsonParseException();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JacksonUtils.map2pojo(map, clazz));
        }
        return result;
    }

    public static <T> T map2pojo(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }

    static {
        objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

