/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.utils;

import com.fasterxml.jackson.databind.JavaType;
import eleme.openapi.sdk.api.exception.AccessDeniedException;
import eleme.openapi.sdk.api.exception.BusinessException;
import eleme.openapi.sdk.api.exception.ExceedLimitException;
import eleme.openapi.sdk.api.exception.InvalidSignatureException;
import eleme.openapi.sdk.api.exception.InvalidTimestampException;
import eleme.openapi.sdk.api.exception.MethodNotAllowedException;
import eleme.openapi.sdk.api.exception.PermissionDeniedException;
import eleme.openapi.sdk.api.exception.ServerErrorException;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.api.exception.SourceTimeoutException;
import eleme.openapi.sdk.api.exception.UnauthorizedException;
import eleme.openapi.sdk.api.exception.ValidationFailedException;
import eleme.openapi.sdk.api.protocol.ErrorPayload;
import eleme.openapi.sdk.api.protocol.ResponsePayload;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.JacksonUtils;
import eleme.openapi.sdk.utils.SignatureUtil;
import eleme.openapi.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";

    public static String doPost(Config context, String url, Map<String, String> params, String charset, String rid, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        WebUtils.setLogInfo(context, "request: " + query);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils._doPost(context, url, ctype, content, rid, connectTimeout, readTimeout, headerMap);
    }

    public static String doPost(Config context, String url, String ctype, byte[] content, String rid, int connectTimeout, int readTimeout) throws SocketTimeoutException, IOException {
        return WebUtils._doPost(context, url, ctype, content, rid, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPost(Config context, String url, String ctype, byte[] content, String rid, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws SocketTimeoutException, IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap, rid);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        WebUtils.setLogInfo(context, "response: " + rsp);
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, String rid) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("Content-Type", ctype);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        conn.setRequestProperty("User-Agent", "eleme-openapi-java-sdk");
        String elemeRequestId = rid;
        conn.setRequestProperty("x-eleme-requestid", elemeRequestId);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset, conn);
        }
        String msg = WebUtils.getStreamAsString(es, charset, conn);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset, HttpURLConnection conn) throws IOException {
        try {
            InputStreamReader reader = "gzip".equals(conn.getContentEncoding()) ? new InputStreamReader((InputStream)new GZIPInputStream(stream), charset) : new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getReqID() {
        String reqId = WebUtils.generateUUID() + "|" + System.currentTimeMillis();
        return reqId;
    }

    public static String generateUUID() {
        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            if (uuid.length() > 32) {
                uuid = uuid.substring(0, 32);
            }
            return uuid.toUpperCase();
        }
        catch (Exception e) {
            return "00112233445566778899AABBCCDDEEFF";
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static <T> T call(Config context, String action, Map<String, Object> parameters, Token token, Type type) throws ServiceException {
        ResponsePayload responsePayload;
        long timestamp = System.currentTimeMillis();
        String appKey = context.getApp_key();
        String secret = context.getApp_secret();
        String accessToken = token.getAccessToken();
        String requestId = WebUtils.getReqID();
        System.out.println("requestId: " + requestId);
        HashMap<String, Object> requestPayload = new HashMap<String, Object>();
        requestPayload.put("nop", "1.0.0");
        requestPayload.put("id", requestId);
        requestPayload.put("action", action);
        requestPayload.put("token", accessToken);
        HashMap<String, Object> metasHashMap = new HashMap<String, Object>();
        metasHashMap.put("app_key", appKey);
        metasHashMap.put("timestamp", timestamp);
        requestPayload.put("metas", metasHashMap);
        requestPayload.put("params", parameters);
        String signature = SignatureUtil.generateSignature(appKey, secret, timestamp, action, accessToken, parameters);
        requestPayload.put("signature", signature);
        String requestJson = JacksonUtils.obj2json(requestPayload);
        try {
            responsePayload = WebUtils.doRequest(context, requestJson, requestId);
        }
        catch (SocketTimeoutException ex) {
            throw new SourceTimeoutException();
        }
        catch (IOException ex) {
            throw new ServiceException(ex.getClass().getName(), ex);
        }
        WebUtils.setLogInfo(context, "request: " + requestJson);
        if (responsePayload != null && null != responsePayload.getError()) {
            ServiceException serviceException = WebUtils.toException(responsePayload.getError());
            if (serviceException != null) {
                WebUtils.setLogError(context, "error: " + serviceException.getMessage());
                throw serviceException;
            }
            throw new ServerErrorException();
        }
        if (type == Void.TYPE) {
            return null;
        }
        String s2 = JacksonUtils.obj2json(responsePayload.getResult());
        JavaType javaType = JacksonUtils.getInstance().getTypeFactory().constructType(type);
        return JacksonUtils.json2pojo(s2, javaType);
    }

    private static ResponsePayload doRequest(Config context, String requestJson, String rid) throws SocketTimeoutException, IOException {
        String response = WebUtils.doPost(context, context.getApiUrl(), "application/json; charset=utf-8", requestJson.getBytes(DEFAULT_CHARSET), rid, 15000, 15000);
        WebUtils.setLogInfo(context, "response: " + response);
        return JacksonUtils.json2pojo(response, ResponsePayload.class);
    }

    private static ServiceException toException(ErrorPayload error) throws ServiceException {
        String code = error.getCode();
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        String message = error.getMessage();
        if ("ACCESS_DENIED".equals(code)) {
            return new AccessDeniedException(message);
        }
        if ("EXCEED_LIMIT".equals(code)) {
            return new ExceedLimitException(message);
        }
        if ("INVALID_SIGNATURE".equals(code)) {
            return new InvalidSignatureException(message);
        }
        if ("INVALID_TIMESTAMP".equals(code)) {
            return new InvalidTimestampException(message);
        }
        if ("METHOD_NOT_ALLOWED".equals(code)) {
            return new MethodNotAllowedException(message);
        }
        if ("PERMISSION_DENIED".equals(code)) {
            return new PermissionDeniedException(message);
        }
        if ("UNAUTHORIZED".equals(code)) {
            return new UnauthorizedException(message);
        }
        if ("VALIDATION_FAILED".equals(code)) {
            return new ValidationFailedException(message);
        }
        if ("BUSINESS_ERROR".equals(code) || code.startsWith("BIZ_")) {
            return new BusinessException(code, error.getMessage());
        }
        return new ServiceException(message);
    }

    private static void setLogInfo(Config context, String msg) {
        if (null != context.getElemeSdkLogger()) {
            context.getElemeSdkLogger().info(msg);
        }
    }

    private static void setLogError(Config context, String msg) {
        if (null != context.getElemeSdkLogger()) {
            context.getElemeSdkLogger().error(msg);
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

