/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.mailsender;

import javax.annotation.Nullable;

public class ProxyConfig {
    private final String remoteProxyHost;
    private final Integer remoteProxyPort;
    private final String username;
    private final String password;
    private final Integer proxyBridgePort;

    public ProxyConfig(@Nullable String remoteProxyHost, @Nullable Integer remoteProxyPort, @Nullable String username, @Nullable String password, @Nullable Integer proxyBridgePort) {
        this.remoteProxyHost = remoteProxyHost;
        this.remoteProxyPort = remoteProxyPort;
        this.username = username;
        this.password = password;
        this.proxyBridgePort = proxyBridgePort;
    }

    public boolean requiresProxy() {
        return this.remoteProxyHost != null;
    }

    public boolean requiresAuthentication() {
        return this.username != null;
    }

    public String toString() {
        if (!this.requiresProxy()) {
            return "no-proxy";
        }
        String str = String.format("%s:%s", this.remoteProxyHost, this.remoteProxyPort);
        if (this.requiresAuthentication()) {
            str = str + String.format(", username: %s", this.username);
            str = str + String.format(", proxy bridge @ localhost:%s", this.proxyBridgePort);
        }
        return str;
    }

    public int getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    public String getRemoteProxyHost() {
        return this.remoteProxyHost;
    }

    public Integer getRemoteProxyPort() {
        return this.remoteProxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

