/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.simplejavamail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookFieldInformation;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMessage;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMessageProperty;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMsgAttachment;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookRecipient;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.RTF2HTMLConverter;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.SimpleRTF2HTMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookMessageParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookMessageParser.class);
    private static final String PROPS_KEY = "__properties_version1.0";
    private static final String PROPERTY_STREAM_PREFIX = "__substg1.0_";
    private RTF2HTMLConverter rtf2htmlConverter = new SimpleRTF2HTMLConverter();

    public OutlookMessage parseMsg(@Nonnull File msgFile) throws IOException {
        return this.parseMsg(new FileInputStream(msgFile));
    }

    public OutlookMessage parseMsg(@Nonnull String msgFile) throws IOException {
        return this.parseMsg(new FileInputStream(msgFile));
    }

    public OutlookMessage parseMsg(@Nonnull InputStream msgFileStream) throws IOException {
        OutlookMessage msg = new OutlookMessage(this.rtf2htmlConverter);
        try {
            this.checkDirectoryEntry((DirectoryEntry)new POIFSFileSystem(msgFileStream).getRoot(), msg);
        }
        finally {
            msgFileStream.close();
        }
        this.convertHeaders(msg);
        return msg;
    }

    private void convertHeaders(@Nonnull OutlookMessage msg) {
        String allHeaders = msg.getHeaders();
        if (allHeaders != null) {
            OutlookMessageParser.extractReplyToHeader(msg, allHeaders);
        }
    }

    static void extractReplyToHeader(@Nonnull OutlookMessage msg, @Nonnull String allHeaders) {
        Matcher m = Pattern.compile("^Reply-To:\\s*(?:<?(?<nameOrAddress>.*?)>?)?\\s*(?:<(?<address>.*?)>)?$", 8).matcher(allHeaders);
        if (m.find()) {
            if (m.group("address") != null) {
                msg.setReplyToName(m.group("nameOrAddress"));
                msg.setReplyToEmail(m.group("address"));
            } else if (m.group("nameOrAddress") != null) {
                msg.setReplyToName(m.group("nameOrAddress"));
                msg.setReplyToEmail(m.group("nameOrAddress"));
            }
        }
    }

    private void checkDirectoryEntry(DirectoryEntry dir, OutlookMessage msg) throws IOException {
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            DirectoryEntry de;
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry()) {
                de = (DirectoryEntry)entry;
                if (de.getName().startsWith("__attach_version1.0")) {
                    this.parseAttachment(de, msg);
                    continue;
                }
                if (de.getName().startsWith("__recip_version1.0")) {
                    this.checkRecipientDirectoryEntry(de, msg);
                    continue;
                }
                this.checkDirectoryEntry(de, msg);
                continue;
            }
            if (!entry.isDocumentEntry()) continue;
            de = (DocumentEntry)entry;
            this.checkDirectoryDocumentEntry((DocumentEntry)de, msg);
        }
    }

    private void checkRecipientDirectoryEntry(DirectoryEntry dir, OutlookMessage msg) throws IOException {
        OutlookRecipient recipient = new OutlookRecipient();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry() || !entry.isDocumentEntry()) continue;
            DocumentEntry de = (DocumentEntry)entry;
            this.checkRecipientDocumentEntry(de, recipient);
        }
        msg.addRecipient(recipient);
    }

    private void checkDirectoryDocumentEntry(DocumentEntry de, OutlookMessage msg) throws IOException {
        if (de.getName().startsWith(PROPS_KEY)) {
            List<DocumentEntry> deList = this.getDocumentEntriesFromPropertiesStream(de);
            for (DocumentEntry deFromProps : deList) {
                OutlookMessageProperty msgProp = this.getMessagePropertyFromDocumentEntry(deFromProps);
                msg.setProperty(msgProp);
            }
        } else {
            msg.setProperty(this.getMessagePropertyFromDocumentEntry(de));
        }
    }

    private void checkRecipientDocumentEntry(DocumentEntry de, OutlookRecipient recipient) throws IOException {
        if (de.getName().startsWith(PROPS_KEY)) {
            List<DocumentEntry> deList = this.getDocumentEntriesFromPropertiesStream(de);
            for (DocumentEntry deFromProps : deList) {
                OutlookMessageProperty msgProp = this.getMessagePropertyFromDocumentEntry(deFromProps);
                recipient.setProperty(msgProp);
            }
        } else {
            recipient.setProperty(this.getMessagePropertyFromDocumentEntry(de));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocumentEntry> getDocumentEntriesFromPropertiesStream(DocumentEntry de) throws IOException {
        ArrayList<DocumentEntry> result = new ArrayList<DocumentEntry>();
        try (DocumentInputStream dstream = null;){
            dstream = new DocumentInputStream(de);
            int headerLength = 4;
            int flagsLength = 4;
            byte[] bytes = new byte[headerLength];
            while (dstream.read(bytes) == headerLength) {
                StringBuilder header = new StringBuilder();
                for (int i = bytes.length - 1; i >= 0; --i) {
                    header.append(this.bytesToHex(new byte[]{bytes[i]}));
                }
                String type = header.substring(4);
                String clazz = header.substring(0, 4);
                int typeNumber = -1;
                try {
                    typeNumber = Integer.parseInt(type, 16);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Unexpected type: {}", (Object)type, (Object)e);
                }
                if (!clazz.equals("0000")) {
                    bytes = new byte[flagsLength];
                    dstream.read(bytes);
                    if (typeNumber == 72 || typeNumber == 30 || typeNumber == 31 || typeNumber == 13 || typeNumber == 258) {
                        bytes = null;
                        dstream.read(new byte[4]);
                    } else if (typeNumber == 3 || typeNumber == 4 || typeNumber == 10 || typeNumber == 11 || typeNumber == 2) {
                        bytes = new byte[4];
                        dstream.read(bytes);
                        dstream.read(bytes);
                    } else if (typeNumber == 5 || typeNumber == 7 || typeNumber == 6 || typeNumber == 20 || typeNumber == 64) {
                        bytes = new byte[8];
                        dstream.read(bytes);
                    }
                    if (bytes != null) {
                        POIFSFileSystem poifs = new POIFSFileSystem();
                        result.add(poifs.createDocument((InputStream)new ByteArrayInputStream(bytes), PROPERTY_STREAM_PREFIX + header));
                    }
                }
                bytes = new byte[headerLength];
            }
            ArrayList<DocumentEntry> arrayList = result;
            return arrayList;
        }
    }

    private OutlookMessageProperty getMessagePropertyFromDocumentEntry(DocumentEntry de) throws IOException {
        OutlookFieldInformation info = this.analyzeDocumentEntry(de);
        Object data = this.getData(de, info);
        LOGGER.trace("  Document data: {}", data);
        return new OutlookMessageProperty(info.getClazz(), data, de.getSize());
    }

    private Object getData(DocumentEntry de, OutlookFieldInformation info) throws IOException {
        if (info == null) {
            return null;
        }
        int mapiType = info.getMapiType();
        switch (mapiType) {
            case -1: {
                return null;
            }
            case 30: {
                byte[] textBytes1e = this.getBytesFromDocumentEntry(de);
                return new String(textBytes1e, "ISO-8859-1");
            }
            case 31: {
                byte[] textBytes1f = this.getBytesFromDocumentEntry(de);
                char[] characters = new char[textBytes1f.length / 2];
                int c = 0;
                for (int i = 0; i < textBytes1f.length - 1; i += 2) {
                    byte ch = textBytes1f[i + 1];
                    int cl = textBytes1f[i] & 0xFF;
                    characters[c++] = (char)((ch << 8) + cl);
                }
                return new String(characters);
            }
            case 258: {
                try {
                    return this.getBytesFromDocumentEntry(de);
                }
                catch (IOException e) {
                    LOGGER.error("Could not get content of byte array of field 0x102", (Throwable)e);
                    return new byte[0];
                }
            }
            case 64: {
                byte[] bytes = this.getBytesFromDocumentEntry(de);
                ByteBuffer buff = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
                buff.put(bytes);
                Long timeLong = buff.getLong(0);
                timeLong = timeLong / 10000L;
                timeLong = timeLong - 11644473600000L;
                return new Date(timeLong);
            }
        }
        LOGGER.trace("Unknown field type {}", (Object)mapiType);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromDocumentEntry(DocumentEntry de) throws IOException {
        DocumentInputStream is = null;
        try {
            is = new DocumentInputStream(de);
            byte[] byArray = this.getBytesFromStream((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error("Could not close input stream for document entry", (Throwable)e);
                }
            }
        }
    }

    private byte[] getBytesFromStream(InputStream dstream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = dstream.read(buffer)) > 0) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder byteStr = new StringBuilder();
        for (byte aByte : bytes) {
            byteStr.append(String.format("%02X", aByte & 0xFF));
        }
        return byteStr.toString();
    }

    private OutlookFieldInformation analyzeDocumentEntry(DocumentEntry de) {
        String name = de.getName();
        LOGGER.trace("Document entry: {}", (Object)name);
        if (name.startsWith(PROPERTY_STREAM_PREFIX)) {
            int mapiType;
            String clazz;
            try {
                String val = name.substring(PROPERTY_STREAM_PREFIX.length()).toLowerCase();
                clazz = val.substring(0, 4);
                String type = val.substring(4);
                LOGGER.trace("  Found document entry: class={}, type={}", (Object)clazz, (Object)type);
                mapiType = Integer.parseInt(type, 16);
            }
            catch (RuntimeException re) {
                LOGGER.error("Could not parse directory entry {}", (Object)name, (Object)re);
                return new OutlookFieldInformation();
            }
            return new OutlookFieldInformation(clazz, mapiType);
        }
        LOGGER.trace("Ignoring entry with name {}", (Object)name);
        return new OutlookFieldInformation();
    }

    private void parseAttachment(DirectoryEntry dir, OutlookMessage msg) throws IOException {
        OutlookFileAttachment attachment = new OutlookFileAttachment();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.isDocumentEntry()) {
                DocumentEntry de = (DocumentEntry)entry;
                OutlookMessageProperty msgProp = this.getMessagePropertyFromDocumentEntry(de);
                attachment.setProperty(msgProp);
                continue;
            }
            OutlookMessage attachmentMsg = new OutlookMessage();
            OutlookMsgAttachment msgAttachment = new OutlookMsgAttachment(attachmentMsg);
            msg.addAttachment(msgAttachment);
            this.checkDirectoryEntry((DirectoryEntry)entry, attachmentMsg);
        }
        if (attachment.getSize() > -1L) {
            msg.addAttachment(attachment);
        }
    }

    public void setRtf2htmlConverter(RTF2HTMLConverter rtf2htmlConverter) {
        this.rtf2htmlConverter = rtf2htmlConverter;
    }
}

