/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.simplejavamail.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMessageProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookRecipient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookRecipient.class);
    private final Map<Integer, Object> properties = new TreeMap<Integer, Object>();
    private String name;
    private String address;

    public void setProperty(OutlookMessageProperty msgProp) {
        String name = msgProp.getClazz();
        Object value = msgProp.getData();
        if (name == null || value == null) {
            return;
        }
        name = name.intern();
        int mapiClass = -1;
        try {
            mapiClass = Integer.parseInt(name, 16);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Unexpected mapi class: {}", (Object)name, (Object)e);
        }
        switch (mapiClass) {
            case 12291: 
            case 14846: {
                this.setAddress((String)value);
                break;
            }
            case 12289: {
                this.setName((String)value);
            }
        }
        this.properties.put(mapiClass, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlookRecipient that = (OutlookRecipient)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (sb.length() > 0) {
            sb.append(" ");
        }
        if (this.address != null && this.address.length() > 0) {
            sb.append("<").append(this.address).append(">");
        }
        return sb.toString();
    }

    @Deprecated
    public Set<String> getProperties() {
        return this.getPropertiesAsHex();
    }

    private Set<String> getPropertiesAsHex() {
        Set<Integer> keySet = this.properties.keySet();
        HashSet<String> result = new HashSet<String>();
        for (Integer k : keySet) {
            String s = String.format("%04x", k);
            result.add(s);
        }
        return result;
    }

    @Deprecated
    public Object getProperty(String name) {
        return this.getPropertyFromHex(name);
    }

    private Object getPropertyFromHex(String name) {
        Integer i = -1;
        try {
            i = Integer.parseInt(name, 16);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse integer {}", (Object)name, (Object)e);
        }
        return this.getPropertyValue(i);
    }

    public Set<Integer> getPropertyCodes() {
        return this.properties.keySet();
    }

    private Object getPropertyValue(Integer code) {
        return this.properties.get(code);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (this.address == null && address != null && address.contains("@")) {
            this.address = address;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }
}

