/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.simplejavamail.rtf;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simplejavamail.outlookmessageparser.simplejavamail.rtf.RTF2HTMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRTF2HTMLConverter
implements RTF2HTMLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRTF2HTMLConverter.class);
    private static final String[] HTML_START_TAGS = new String[]{"<html ", "<Html ", "<HTML "};
    private static final String[] HTML_END_TAGS = new String[]{"</html>", "</Html>", "</HTML>"};
    private static final String WINDOWS_CHARSET = "CP1252";

    @Override
    public String rtf2html(String rtf) {
        if (rtf != null) {
            String plain = this.fetchHtmlSection(rtf);
            plain = this.replaceHexSequences(plain);
            plain = this.replaceSpecialSequences(plain);
            plain = this.replaceRemainingControlSequences(plain);
            plain = this.replaceLineBreaks(plain);
            return plain;
        }
        return null;
    }

    private String replaceLineBreaks(String text) {
        text = text.replaceAll("( <br/> ( <br/> )+)", " <br/> ");
        text = text.replaceAll("[\\n\\r]+", "");
        return text;
    }

    private String replaceHexSequences(String text) {
        Matcher m = Pattern.compile("\\\\'(..)").matcher(text);
        while (m.find()) {
            for (int g = 1; g <= m.groupCount(); ++g) {
                String hex = m.group(g);
                String hexToString = SimpleRTF2HTMLConverter.hexToString(hex);
                if (hexToString == null) continue;
                text = text.replaceAll("\\\\'" + hex, hexToString);
            }
        }
        return text;
    }

    private String fetchHtmlSection(String text) {
        int i;
        int htmlStart = -1;
        int htmlEnd = -1;
        for (i = 0; i < HTML_START_TAGS.length && htmlStart < 0; ++i) {
            htmlStart = text.indexOf(HTML_START_TAGS[i]);
        }
        for (i = 0; i < HTML_END_TAGS.length && htmlEnd < 0; ++i) {
            htmlEnd = text.indexOf(HTML_END_TAGS[i]);
            if (htmlEnd <= 0) continue;
            htmlEnd += HTML_END_TAGS[i].length();
        }
        if (htmlStart > -1 && htmlEnd > -1) {
            return text.substring(htmlStart, htmlEnd + 1);
        }
        String html = "<html><body style=\"font-family:'Courier',monospace;font-size:10pt;\">" + text + "</body></html>";
        html = html.replaceAll("[\\n\\r]+", " <br/> ");
        html = html.replaceAll("(http://\\S+)", "<a href=\"$1\">$1</a>");
        return html.replaceAll("mailto:(\\S+@\\S+)", "<a href=\"mailto:$1\">$1</a>");
    }

    private String replaceSpecialSequences(String text) {
        text = text.replaceAll("\\{\\\\S+ [^\\s\\\\}]*\\}", "");
        text = text.replaceAll("\\{HYPERLINK[^\\}]*\\}", "");
        text = text.replaceAll("\\{\\\\pntext[^\\}]*\\}", "");
        text = text.replaceAll("\\{\\\\f\\d+[^\\}]*\\}", "");
        text = text.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+(<.+>)\\}", "$1");
        text = text.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+\\}", "");
        text = text.replaceAll("([^\\\\])\\}+", "$1");
        text = text.replaceAll("([^\\\\])\\{+", "$1");
        text = text.replaceAll("\\\\\\}", "}");
        text = text.replaceAll("\\\\\\{", "{");
        return text;
    }

    private static String hexToString(String hex) {
        int i;
        try {
            i = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Could not interpret {} as a number.", (Object)hex, (Object)nfe);
            return null;
        }
        try {
            return new String(new byte[]{(byte)i}, WINDOWS_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unsupported encoding: {}", (Object)WINDOWS_CHARSET, (Object)e);
            return null;
        }
    }

    private String replaceRemainingControlSequences(String text) {
        text = text.replaceAll("\\\\pard*", "\n");
        text = text.replaceAll("\\\\tab", "\t");
        text = text.replaceAll("\\\\\\*\\\\\\S+", "");
        text = text.replaceAll("\\\\\\S+", "");
        return text;
    }
}

