/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank.internal.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPUtil {
    private transient Logger log = LoggerFactory.getLogger(this.getClass());
    private ChannelSftp sftp;
    private Session session;
    private String username;
    private String password;
    private String privateKey;
    private String host;
    private int port;

    public SFTPUtil(String username, String password, String host, int port) {
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public SFTPUtil(String username, String host, int port, String privateKey) {
        this.username = username;
        this.host = host;
        this.port = port;
        this.privateKey = privateKey;
    }

    public SFTPUtil() {
    }

    public void mkdirDir(String[] dirs, String tempPath, int length, int index) {
        if (++index < length) {
            tempPath = tempPath + "/" + dirs[index];
        }
        try {
            this.log.info("\u68c0\u6d4b\u76ee\u5f55[" + tempPath + "]");
            this.sftp.cd(tempPath);
            if (index < length) {
                this.mkdirDir(dirs, tempPath, length, index);
            }
        }
        catch (SftpException ex) {
            this.log.warn("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]");
            try {
                this.sftp.mkdir(tempPath);
                this.sftp.cd(tempPath);
            }
            catch (SftpException e) {
                e.printStackTrace();
                this.log.error("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f[" + e.getMessage() + "]");
            }
            this.log.info("\u8fdb\u5165\u76ee\u5f55[" + tempPath + "]");
            this.mkdirDir(dirs, tempPath, length, index);
        }
    }

    public void uploadMore(String directory, String sftpFileName, InputStream input) throws SftpException {
        try {
            this.sftp.cd(directory);
        }
        catch (SftpException e) {
            String[] dirs = directory.split("/");
            String tempPath = "";
            int index = 0;
            this.mkdirDir(dirs, tempPath, dirs.length, index);
        }
        this.sftp.put(input, sftpFileName);
    }

    public void login() {
        try {
            JSch jsch = new JSch();
            if (this.privateKey != null) {
                jsch.addIdentity(this.privateKey);
                this.log.info("sftp connect,path of private key file\uff1a{}", (Object)this.privateKey);
            }
            this.log.info("sftp connect by host:{} username:{}", (Object)this.host, (Object)this.username);
            this.session = jsch.getSession(this.username, this.host, this.port);
            this.log.info("Session is build");
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect();
            this.log.info("Session is connected");
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.log.info("channel is connected");
            this.sftp = (ChannelSftp)channel;
            this.log.info(String.format("sftp server host:[%s] port:[%s] sftp server is connect successfull", this.host, this.port));
        }
        catch (JSchException e) {
            this.log.error("Cannot connect to specified sftp server : {}:{} \n Exception message is: {}", new Object[]{this.host, this.port, e.getMessage()});
        }
    }

    public void logout() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
            this.log.info("sftp is closed already");
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            this.log.info("sshSession is closed already");
        }
    }

    public void upload(String directory, String sftpFileName, InputStream input) throws SftpException {
        try {
            this.sftp.cd(directory);
        }
        catch (SftpException e) {
            this.log.warn("directory is not exist");
            String[] dirs = directory.split("/");
            String tempPath = "";
            int index = 0;
            this.mkdirDir(dirs, tempPath, dirs.length, index);
        }
        this.sftp.put(input, sftpFileName);
        this.log.info("file:{} is upload successful", (Object)sftpFileName);
    }

    public void upload(String directory, String uploadFile) throws FileNotFoundException, SftpException {
        File file = new File(uploadFile);
        this.upload(directory, file.getName(), (InputStream)new FileInputStream(file));
    }

    public void upload(String directory, String sftpFileName, byte[] byteArr) throws SftpException {
        this.upload(directory, sftpFileName, (InputStream)new ByteArrayInputStream(byteArr));
    }

    public void upload(String directory, String sftpFileName, String dataStr, String charsetName) throws UnsupportedEncodingException, SftpException {
        this.upload(directory, sftpFileName, (InputStream)new ByteArrayInputStream(dataStr.getBytes(charsetName)));
    }

    public void download(String directory, String downloadFile, String saveFile) throws SftpException, FileNotFoundException {
        if (directory != null && !"".equals(directory)) {
            this.sftp.cd(directory);
        }
        File file = new File(saveFile);
        this.sftp.get(downloadFile, (OutputStream)new FileOutputStream(file));
        this.log.info("file:{} is download successful", (Object)downloadFile);
    }

    public byte[] download(String directory, String downloadFile) throws SftpException, IOException {
        if (directory != null && !"".equals(directory)) {
            this.sftp.cd(directory);
        }
        InputStream is = this.sftp.get(downloadFile);
        byte[] fileData = IOUtils.toByteArray((InputStream)is);
        this.log.info("file:{} is download successful", (Object)downloadFile);
        return fileData;
    }

    public void delete(String directory, String deleteFile) throws SftpException {
        this.sftp.cd(directory);
        this.sftp.rm(deleteFile);
    }

    public Vector<?> listFiles(String directory) throws SftpException {
        return this.sftp.ls(directory);
    }

    public static void main(String[] args) throws SftpException, IOException {
        SFTPUtil sftp = new SFTPUtil("root", " SoecOydhs7DhkqZ9", "192.168.0.250", 22);
        sftp.login();
        File file = new File("/Users/mac/zhangbo/ideaspace/byh-aggregation-payment/aggregation-payment-server/src/main/java/com/ebaiyihui/aggregation/payment/server/mybank/internal/util/SFTPUtil.java");
        FileInputStream is = new FileInputStream(file);
        sftp.upload("/opt", "SFTPUtil.java", (InputStream)is);
        sftp.logout();
    }
}

