/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.transfer;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.TransferRecord;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrderQueryResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrerQueryReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.WxPayV3;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.BatchesTransferDetailReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.BatchesTransferDetailResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.BatchesTransferListDetailResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.PayBatchesTransferDetail;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.PayBatchesTransferReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.PayBatchesTransferResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.TransferDetailReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.batch.TransferDetailResp;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.config.WxPayV3Configuration;
import com.ebaiyihui.aggregation.payment.server.enums.TransferDetailStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.TransferRecordMapper;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.transfer.ITransferService;
import com.ebaiyihui.aggregation.payment.server.utils.RequestHolder;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.binarywang.wxpay.bean.entpay.EntPayQueryResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.transfer.QueryTransferBatchesRequest;
import com.github.binarywang.wxpay.bean.transfer.QueryTransferBatchesResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchDetailResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesRequest;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WxPayServiceImpl
implements ITransferService {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceImpl.class);
    @Autowired
    private WxPayConfiguration wxPayConfiguration;
    @Autowired
    MchChanService mchChanService;
    @Resource
    private WxPayV3Configuration wxPayV3Configuration;
    @Resource
    private TransferRecordMapper transferRecordMapper;

    public BaseResponse<B2CPayResp> B2Ctransfer(B2CPayReq vo) {
        log.info("wx pay B2CTransfer method param={}", (Object)vo);
        MchChan mtc = RequestHolder.getMtc();
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)mtc.getParam(), WxPayParam.class);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        EntPayRequest request = new EntPayRequest();
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        request.setOpenid(vo.getToUserId());
        request.setPartnerTradeNo(vo.getOutBizNo());
        request.setAmount(vo.getAmount());
        request.setDescription(vo.getRemark());
        request.setCheckName("NO_CHECK");
        request.setSpbillCreateIp("127.0.0.1");
        EntPayResult entPayResult = new EntPayResult();
        try {
            log.info("B2Ctransfer wx pay EntPay req ={}", (Object)request);
            entPayResult = wxPayService.getEntPayService().entPay(request);
            log.info("B2Ctransfer wx pay EntPay resp ={}", (Object)entPayResult);
            if (!this.isOk((BaseWxPayResult)entPayResult)) {
                return BaseResponse.error((String)entPayResult.getReturnMsg());
            }
            B2CPayResp res = new B2CPayResp();
            res.setOutBizNo(entPayResult.getPartnerTradeNo());
            res.setPaymentNo(entPayResult.getPaymentNo());
            res.setPaymentStatus("SUCCESS");
            res.setPaymentTime(entPayResult.getPaymentTime());
            return BaseResponse.success((Object)res);
        }
        catch (WxPayException e) {
            log.error("transfer error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getReturnMsg());
        }
    }

    public BaseResponse<B2CPayOrderQueryResp> transferBillQuery(B2CPayOrerQueryReq vo) {
        MchChan mtc = RequestHolder.getMtc();
        WxPayParam wxPayParam = (WxPayParam)JSONObject.parseObject((String)mtc.getParam(), WxPayParam.class);
        WxPayService wxPayService = this.wxPayConfiguration.wxService(wxPayParam);
        wxPayService.getConfig().setSslContext(null);
        wxPayService.getConfig().setAppId(wxPayParam.getAppId());
        wxPayService.getConfig().setMchId(wxPayParam.getMchAccount());
        wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
        wxPayService.getConfig().setKeyPath(wxPayParam.getKeyPath());
        try {
            log.info("wx pay queryEntPay req ={}", (Object)vo.getOutBizNo());
            EntPayQueryResult result = wxPayService.getEntPayService().queryEntPay(vo.getOutBizNo());
            log.info("wx pay queryEntPay resp ={}", (Object)result);
            if (!this.isOk((BaseWxPayResult)result)) {
                return BaseResponse.error((String)result.getReturnMsg());
            }
            B2CPayOrderQueryResp res = new B2CPayOrderQueryResp();
            res.setPaymentNo(result.getDetailId());
            res.setOutBizNo(result.getPartnerTradeNo());
            res.setToUserId(result.getOpenid());
            res.setToUserName(result.getTransferName());
            res.setPaymentAmount(result.getPaymentAmount() + "");
            res.setStatus(result.getStatus());
            res.setPaymentTime(result.getPaymentTime());
            res.setOrderFee("");
            res.setFailReason(result.getReason());
            res.setError_code(result.getErrCode());
            res.setRemark(result.getDesc());
            return BaseResponse.success((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse<PayBatchesTransferResp> batchesTransfer(PayBatchesTransferReq req) {
        WxPayV3 wxPayV3 = this.getWxPayV3(req.getMchCode(), req.getChanCode());
        WxPayService wxPayService = this.wxPayV3Configuration.wxService(wxPayV3);
        TransferBatchesRequest transferBatchesRequest = new TransferBatchesRequest();
        BeanUtils.copyProperties((Object)req, (Object)transferBatchesRequest);
        transferBatchesRequest.setAppid(wxPayV3.getAppid());
        ArrayList<TransferBatchesRequest.TransferDetail> transferDetailList = new ArrayList<TransferBatchesRequest.TransferDetail>();
        ArrayList<TransferRecord> list = new ArrayList<TransferRecord>();
        for (PayBatchesTransferDetail payBatchesTransferDetail : req.getTransferDetailList()) {
            TransferBatchesRequest.TransferDetail transferDetail = new TransferBatchesRequest.TransferDetail();
            TransferRecord transferRecord = new TransferRecord();
            transferRecord.setOutBatchNo(req.getOutBatchNo());
            transferRecord.setBatchName(req.getBatchName());
            transferRecord.setBatchRemark(req.getBatchRemark());
            transferRecord.setOutDetailNo(payBatchesTransferDetail.getOutDetailNo());
            transferRecord.setType(req.getChanCode());
            transferRecord.setTransferStatus(TransferDetailStatusEnum.INIT.name());
            transferRecord.setAmount(payBatchesTransferDetail.getTransferAmount());
            transferRecord.setRemark(payBatchesTransferDetail.getTransferRemark());
            transferRecord.setOpenId(payBatchesTransferDetail.getOpenid());
            transferRecord.setUserName(payBatchesTransferDetail.getUserName());
            list.add(transferRecord);
            BeanUtils.copyProperties((Object)payBatchesTransferDetail, (Object)transferDetail);
            transferDetailList.add(transferDetail);
        }
        transferBatchesRequest.setTransferDetailList(transferDetailList);
        PayBatchesTransferResp payBatchesTransferResp = new PayBatchesTransferResp();
        try {
            TransferBatchesResult transferBatchesResult = wxPayService.getTransferService().transferBatches(transferBatchesRequest);
            BeanUtils.copyProperties((Object)transferBatchesResult, (Object)payBatchesTransferResp);
            for (TransferRecord transferRecord : list) {
                transferRecord.setBatchId(transferBatchesResult.getBatchId());
            }
            this.transferRecordMapper.insertList(list);
        }
        catch (WxPayException e) {
            log.error("wechat batchesTransfer error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getErrCodeDes());
        }
        return BaseResponse.success((Object)payBatchesTransferResp);
    }

    @Nullable
    private WxPayV3 getWxPayV3(String mchCode, String chanCode) {
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(mchCode, chanCode, WechatTradeTypeEnum.BATCH_TRANSFER.getDisplay());
        String param = mchChan.getParam();
        WxPayV3 wxPayV3 = (WxPayV3)JSONObject.parseObject((String)param, WxPayV3.class);
        return wxPayV3;
    }

    public BaseResponse<BatchesTransferDetailResp> batchesDetail(BatchesTransferDetailReq req) {
        BatchesTransferDetailResp result = new BatchesTransferDetailResp();
        ArrayList<BatchesTransferListDetailResp> transferDetailListTmp = new ArrayList<BatchesTransferListDetailResp>();
        WxPayV3 wxPayV3 = this.getWxPayV3(req.getMchCode(), req.getChanCode());
        WxPayService wxPayService = this.wxPayV3Configuration.wxService(wxPayV3);
        QueryTransferBatchesRequest queryTransferBatchesRequest = new QueryTransferBatchesRequest();
        BeanUtils.copyProperties((Object)req, (Object)queryTransferBatchesRequest);
        try {
            QueryTransferBatchesResult queryTransferBatchesResult = wxPayService.getTransferService().transferBatchesOutBatchNo(queryTransferBatchesRequest);
            QueryTransferBatchesResult.TransferBatch transferBatch = queryTransferBatchesResult.getTransferBatch();
            BeanUtils.copyProperties((Object)transferBatch, (Object)result);
            List transferDetailList = queryTransferBatchesResult.getTransferDetailList();
            if (!CollectionUtils.isEmpty((Collection)transferDetailList)) {
                for (QueryTransferBatchesResult.TransferDetail transferDetail : transferDetailList) {
                    BatchesTransferListDetailResp batchesTransferListDetailResp = new BatchesTransferListDetailResp();
                    BeanUtils.copyProperties((Object)transferDetail, (Object)batchesTransferListDetailResp);
                    transferDetailListTmp.add(batchesTransferListDetailResp);
                }
            }
            result.setTransferDetailList(transferDetailListTmp);
        }
        catch (WxPayException e) {
            log.error("wechat batchesDetail error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getErrCodeDes());
        }
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<TransferDetailResp> detail(TransferDetailReq req) {
        TransferDetailResp transferDetailResp = new TransferDetailResp();
        WxPayV3 wxPayV3 = this.getWxPayV3(req.getMchCode(), req.getChanCode());
        WxPayService wxPayService = this.wxPayV3Configuration.wxService(wxPayV3);
        try {
            TransferBatchDetailResult transferBatchDetailResult = wxPayService.getTransferService().transferBatchesOutBatchNoDetail(req.getOutBatchNo(), req.getOutDetailNo());
            BeanUtils.copyProperties((Object)transferBatchDetailResult, (Object)transferDetailResp);
        }
        catch (WxPayException e) {
            log.error("wechat batches one detail error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getErrCodeDes());
        }
        return BaseResponse.success((Object)transferDetailResp);
    }

    public boolean isOk(BaseWxPayResult result) {
        return result.getResultCode().equals("SUCCESS") && result.getReturnCode().equals("SUCCESS");
    }
}

