/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.unionpay;

import com.ebaiyihui.aggregation.payment.common.vo.UnionPayVo;
import com.ebaiyihui.aggregation.payment.server.unionpay.DemoBase;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.AcpService;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.CertUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.LogUtil;
import com.ebaiyihui.aggregation.payment.server.unionpay.sdk.SDKConfig;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnionPayClient {
    private static final Logger log = LoggerFactory.getLogger(UnionPayClient.class);

    public static String pay(String frontUrl, String orderId, String payType, String txnAmt, String goodsName, Date payTime, UnionPayVo payParam) {
        String txnTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
        System.out.println(txnTime);
        HashMap<String, String> requestData = new HashMap<String, String>();
        System.out.println("encoding" + DemoBase.encoding);
        requestData.put("version", "5.1.0");
        requestData.put("encoding", DemoBase.encoding);
        requestData.put("signMethod", SDKConfig.getConfig().getSignMethod());
        requestData.put("txnType", "01");
        requestData.put("txnSubType", "01");
        requestData.put("bizType", "000201");
        requestData.put("channelType", payType);
        requestData.put("merId", payParam.getMerId());
        requestData.put("accessType", "0");
        requestData.put("orderId", orderId);
        requestData.put("txnTime", txnTime);
        requestData.put("currencyCode", "156");
        requestData.put("txnAmt", UnionPayClient.changeY2F((String)txnAmt));
        requestData.put("riskRateInfo", "{commodityName=" + goodsName + "}");
        requestData.put("frontUrl", frontUrl == null ? payParam.getFrontUrl() : frontUrl);
        requestData.put("backUrl", payParam.getBackUrl());
        requestData.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date().getTime() + 900000L));
        UnionPayClient.setConfig((UnionPayVo)payParam);
        Map submitFromData = AcpService.sign(requestData, (String)DemoBase.encoding);
        String requestFrontUrl = SDKConfig.getConfig().getFrontRequestUrl();
        String html = AcpService.createAutoFormHtml((String)requestFrontUrl, (Map)submitFromData, (String)DemoBase.encoding);
        return html;
    }

    public static Map<String, String> query(String orderId, String txnTime, UnionPayVo payVo) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("version", "5.1.0");
        data.put("encoding", DemoBase.encoding);
        data.put("signMethod", SDKConfig.getConfig().getSignMethod());
        data.put("txnType", "00");
        data.put("txnSubType", "00");
        data.put("bizType", "000201");
        data.put("merId", payVo.getMerId());
        data.put("accessType", "0");
        data.put("orderId", orderId);
        data.put("txnTime", txnTime);
        UnionPayClient.setConfig((UnionPayVo)payVo);
        Map reqData = AcpService.sign(data, (String)DemoBase.encoding);
        String url = SDKConfig.getConfig().getSingleQueryUrl();
        Map rspData = AcpService.post((Map)reqData, (String)url, (String)DemoBase.encoding);
        return rspData;
    }

    public static Map<String, String> refund(String refundOrderId, String payType, String txnAmt, String origQryId, UnionPayVo unionPayVo) {
        String txnTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("version", "5.1.0");
        data.put("encoding", DemoBase.encoding);
        data.put("signMethod", SDKConfig.getConfig().getSignMethod());
        data.put("txnType", "04");
        data.put("txnSubType", "00");
        data.put("bizType", "000201");
        data.put("channelType", payType);
        data.put("merId", unionPayVo.getMerId());
        data.put("accessType", "0");
        data.put("orderId", refundOrderId);
        data.put("txnTime", txnTime);
        data.put("currencyCode", "156");
        data.put("txnAmt", UnionPayClient.changeY2F((String)txnAmt));
        data.put("backUrl", unionPayVo.getBackUrl());
        data.put("origQryId", origQryId);
        UnionPayClient.setConfig((UnionPayVo)unionPayVo);
        Map reqData = AcpService.sign(data, (String)DemoBase.encoding);
        String url = SDKConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)url, (String)DemoBase.encoding);
        return rspData;
    }

    public static String qrCode(String orderId, String txnAmt, UnionPayVo unionPayVo) throws IOException {
        String txnTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
        HashMap<String, String> contentData = new HashMap<String, String>();
        contentData.put("version", DemoBase.version);
        contentData.put("encoding", DemoBase.encoding);
        contentData.put("signMethod", SDKConfig.getConfig().getSignMethod());
        contentData.put("txnType", "01");
        contentData.put("txnSubType", "07");
        contentData.put("bizType", "000000");
        contentData.put("channelType", "08");
        contentData.put("merId", unionPayVo.getMerId());
        contentData.put("accessType", "0");
        contentData.put("orderId", orderId);
        contentData.put("txnTime", txnTime);
        contentData.put("txnAmt", UnionPayClient.changeY2F((String)txnAmt));
        contentData.put("currencyCode", "156");
        contentData.put("backUrl", unionPayVo.getBackUrl());
        UnionPayClient.setConfig((UnionPayVo)unionPayVo);
        Map reqData = AcpService.sign(contentData, (String)DemoBase.encoding);
        String requestAppUrl = SDKConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)requestAppUrl, (String)DemoBase.encoding);
        System.out.println("rspData=" + rspData);
        if (!rspData.isEmpty()) {
            if (AcpService.validate((Map)rspData, (String)DemoBase.encoding)) {
                LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
                String respCode = (String)rspData.get("respCode");
                if ("00".equals(respCode)) {
                    log.info("\u94f6\u8054\u8ba2\u5355\u53f7\uff1a{}", rspData.get("orderId"));
                    String qrCode = (String)rspData.get("qrCode");
                    return qrCode;
                }
            } else {
                LogUtil.writeErrorLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
        } else {
            LogUtil.writeErrorLog((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            System.out.println("\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
        }
        String reqMessage = DemoBase.genHtmlResult((Map)reqData);
        String rspMessage = DemoBase.genHtmlResult((Map)rspData);
        return "\u8bf7\u6c42\u62a5\u6587:<br/>" + reqMessage + "<br/>\u5e94\u7b54\u62a5\u6587:</br>" + rspMessage + "";
    }

    public static String qrIsSwept(String orderId, String txnAmt, String qrNo, UnionPayVo unionPayVo) throws IOException {
        String txnTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
        HashMap<String, String> contentData = new HashMap<String, String>();
        contentData.put("version", DemoBase.version);
        contentData.put("encoding", DemoBase.encoding);
        contentData.put("signMethod", SDKConfig.getConfig().getSignMethod());
        contentData.put("txnType", "01");
        contentData.put("txnSubType", "06");
        contentData.put("bizType", "000000");
        contentData.put("channelType", "08");
        contentData.put("merId", unionPayVo.getMerId());
        contentData.put("accessType", "0");
        contentData.put("orderId", orderId);
        contentData.put("txnTime", txnTime);
        contentData.put("txnAmt", UnionPayClient.changeY2F((String)txnAmt));
        contentData.put("currencyCode", "156");
        contentData.put("qrNo", qrNo);
        contentData.put("backUrl", unionPayVo.getBackUrl());
        UnionPayClient.setConfig((UnionPayVo)unionPayVo);
        Map reqData = AcpService.sign(contentData, (String)DemoBase.encoding);
        String requestAppUrl = SDKConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)requestAppUrl, (String)DemoBase.encoding);
        if (!rspData.isEmpty()) {
            if (AcpService.validate((Map)rspData, (String)DemoBase.encoding)) {
                LogUtil.writeLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
                String respCode = (String)rspData.get("respCode");
                if ("00".equals(respCode)) {
                    return "Success";
                }
            } else {
                LogUtil.writeErrorLog((String)"\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
        } else {
            LogUtil.writeErrorLog((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
        }
        String reqMessage = DemoBase.genHtmlResult((Map)reqData);
        String rspMessage = DemoBase.genHtmlResult((Map)rspData);
        return "\u8bf7\u6c42\u62a5\u6587:<br/>" + reqMessage + "<br/>\u5e94\u7b54\u62a5\u6587:</br>" + rspMessage + "";
    }

    public static void setConfig(UnionPayVo payParam) {
        SDKConfig.getConfig().setSignCertPath(payParam.getSignCert());
        SDKConfig.getConfig().setSignCertPwd(payParam.getSignCertPwd());
        SDKConfig.getConfig().setEncryptCertPath(payParam.getEncryptCert());
        SDKConfig.getConfig().setMiddleCertPath(payParam.getMiddleCert());
        SDKConfig.getConfig().setRootCertPath(payParam.getRootCert());
        CertUtil.initCert();
    }

    public static String changeY2F(String p) {
        double price = Double.valueOf(p);
        DecimalFormat df = new DecimalFormat("#.00");
        price = Double.valueOf(df.format(price));
        int money = (int)(price * 100.0);
        return money + "";
    }

    public static String getPayType(String tradeType) {
        if (tradeType.equals("H5")) {
            return "08";
        }
        if (tradeType.equals("PC")) {
            return "07";
        }
        return "08";
    }
}

