/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.xiaomi.channel.commonutils.android.l;
import com.xiaomi.channel.commonutils.android.n;
import com.xiaomi.channel.commonutils.misc.h;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.ab;
import com.xiaomi.mipush.sdk.ag;
import com.xiaomi.mipush.sdk.ah;
import com.xiaomi.mipush.sdk.ai;
import com.xiaomi.mipush.sdk.aj;
import com.xiaomi.mipush.sdk.ak;
import com.xiaomi.mipush.sdk.ao;
import com.xiaomi.mipush.sdk.ap;
import com.xiaomi.mipush.sdk.az;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.be;
import com.xiaomi.mipush.sdk.bf;
import com.xiaomi.mipush.sdk.bh;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.f;
import com.xiaomi.mipush.sdk.g;
import com.xiaomi.mipush.sdk.i;
import com.xiaomi.mipush.sdk.q;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.u;
import com.xiaomi.mipush.sdk.w;
import com.xiaomi.mipush.sdk.z;
import com.xiaomi.push.service.an;
import com.xiaomi.push.service.aq;
import com.xiaomi.push.service.clientReport.c;
import com.xiaomi.push.service.j;
import com.xiaomi.push.service.o;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.xiaomi.xmpush.thrift.ad;
import com.xiaomi.xmpush.thrift.ar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static boolean isCrashHandlerSuggested = false;
    private static Context sContext;
    private static long sCurMsgId;
    private static bh mSyncMIIDHelper;

    public static boolean shouldUseMIUIPush(Context context) {
        return az.a(context).c();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(context);
        }
        g.a(context).a(pushConfiguration);
        MiPushClient.enableGeo(context, pushConfiguration.getGeoEnable());
        b.a();
        h.a(context).a(new ag(context, string, string2));
    }

    private static boolean checkPermission(Context context) {
        boolean bl2 = false;
        if (context != null) {
            if (com.xiaomi.channel.commonutils.android.f.a() || "com.xiaomi.xmsf".equals(context.getPackageName())) {
                bl2 = true;
            } else {
                int n2 = context.getApplicationInfo().targetSdkVersion;
                if (n2 >= 23 && Build.VERSION.SDK_INT >= 23) {
                    if (com.xiaomi.channel.commonutils.android.g.a(context, "android.permission.READ_PHONE_STATE") || com.xiaomi.channel.commonutils.android.g.a(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                        bl2 = true;
                    }
                } else {
                    String string = com.xiaomi.channel.commonutils.android.d.e(context);
                    String string2 = com.xiaomi.channel.commonutils.android.d.a();
                    if (!TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2)) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            context2.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        try {
            Object object;
            boolean bl2;
            sContext = context.getApplicationContext();
            if (sContext == null) {
                sContext = context;
            }
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (n.b(context)) {
                ab.a(context);
            }
            boolean bl3 = bl2 = d.a(sContext).m() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                az.a(context).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && d.a(sContext).a(string, string2) && !d.a(sContext).n()) {
                Object object2;
                if (1 == PushMessageHelper.getPushMode(context)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, d.a(context).e());
                } else {
                    object = new ArrayList();
                    object.add(d.a(context).e());
                    object2 = PushMessageHelper.generateCommandMessage(com.xiaomi.push.service.xmpush.a.a.k, (List<String>)object, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object2);
                }
                az.a(context).a();
                if (d.a(sContext).a()) {
                    object = new com.xiaomi.xmpush.thrift.ai();
                    ((com.xiaomi.xmpush.thrift.ai)object).b(d.a(context).c());
                    ((com.xiaomi.xmpush.thrift.ai)object).c("client_info_update");
                    ((com.xiaomi.xmpush.thrift.ai)object).a(aq.a());
                    ((com.xiaomi.xmpush.thrift.ai)object).h = new HashMap<String, String>();
                    ((com.xiaomi.xmpush.thrift.ai)object).h.put("app_version", com.xiaomi.channel.commonutils.android.a.a(sContext, sContext.getPackageName()));
                    ((com.xiaomi.xmpush.thrift.ai)object).h.put("app_version_code", Integer.toString(com.xiaomi.channel.commonutils.android.a.b(sContext, sContext.getPackageName())));
                    ((com.xiaomi.xmpush.thrift.ai)object).h.put("push_sdk_vn", "3_6_9");
                    ((com.xiaomi.xmpush.thrift.ai)object).h.put("push_sdk_vc", Integer.toString(30609));
                    object2 = d.a(sContext).g();
                    if (!TextUtils.isEmpty((CharSequence)object2)) {
                        ((com.xiaomi.xmpush.thrift.ai)object).h.put("deviceid", (String)object2);
                    }
                    az.a(context).a(object, com.xiaomi.xmpush.thrift.a.i, false, null);
                    b.a(context);
                }
                if (!com.xiaomi.channel.commonutils.android.h.a(sContext, "update_devId", false)) {
                    MiPushClient.updateIMEI();
                    com.xiaomi.channel.commonutils.android.h.b(sContext, "update_devId", true);
                }
                if (!TextUtils.isEmpty((CharSequence)(object = com.xiaomi.channel.commonutils.android.d.c(context)))) {
                    object2 = new ad();
                    ((ad)object2).a(aq.a());
                    ((ad)object2).b(string);
                    ((ad)object2).c(com.xiaomi.push.service.xmpush.a.j.k);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(com.xiaomi.channel.commonutils.android.d.b(context));
                    arrayList.add((String)object);
                    arrayList.add(Build.MODEL != null ? Build.MODEL : "");
                    arrayList.add(Build.BOARD != null ? Build.BOARD : "");
                    ((ad)object2).a(arrayList);
                    az.a(context).a(object2, com.xiaomi.xmpush.thrift.a.j, false, null);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object2 = new com.xiaomi.xmpush.thrift.ai();
                    ((com.xiaomi.xmpush.thrift.ai)object2).b(d.a(sContext).c());
                    ((com.xiaomi.xmpush.thrift.ai)object2).c(com.xiaomi.xmpush.thrift.r.j.aa);
                    ((com.xiaomi.xmpush.thrift.ai)object2).a(aq.a());
                    ((com.xiaomi.xmpush.thrift.ai)object2).a(false);
                    az.a(sContext).a(object2, com.xiaomi.xmpush.thrift.a.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                object = com.xiaomi.channel.commonutils.string.d.a(6);
                d.a(sContext).i();
                d.a(sContext).a(Constants.a());
                d.a(sContext).a(string, string2, (String)object);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                com.xiaomi.xmpush.thrift.aj aj2 = new com.xiaomi.xmpush.thrift.aj();
                aj2.a(aq.a());
                aj2.b(string);
                aj2.e(string2);
                aj2.d(context.getPackageName());
                aj2.f((String)object);
                aj2.c(com.xiaomi.channel.commonutils.android.a.a(context, context.getPackageName()));
                aj2.b(com.xiaomi.channel.commonutils.android.a.b(context, context.getPackageName()));
                aj2.g("3_6_9");
                aj2.a(30609);
                aj2.h(com.xiaomi.channel.commonutils.android.d.d(sContext));
                aj2.a(com.xiaomi.xmpush.thrift.w.c);
                if (!com.xiaomi.channel.commonutils.android.f.g()) {
                    String string3 = com.xiaomi.channel.commonutils.android.d.f(sContext);
                    String string4 = com.xiaomi.channel.commonutils.android.d.h(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        if (com.xiaomi.channel.commonutils.android.f.b()) {
                            if (!TextUtils.isEmpty((CharSequence)string4)) {
                                string3 = string3 + "," + string4;
                            }
                            aj2.i(string3);
                        }
                        aj2.k(com.xiaomi.channel.commonutils.string.d.a(string3) + "," + com.xiaomi.channel.commonutils.android.d.i(sContext));
                    }
                }
                aj2.j(com.xiaomi.channel.commonutils.android.d.a());
                int n2 = com.xiaomi.channel.commonutils.android.d.b();
                if (n2 >= 0) {
                    aj2.c(n2);
                }
                az.a(sContext).a(aj2, bl2);
                b.a(context);
                context.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleGeoFenceLocUploadJobs();
            MiPushClient.scheduleDataCollectionJobs(context);
            MiPushClient.initEventPerfLogic(context);
            bf.a(sContext);
            MiPushClient.forceHandleCrash();
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                Logger.setLogger(sContext, Logger.getUserLogger());
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            try {
                if (mSyncMIIDHelper == null) {
                    mSyncMIIDHelper = new bh(sContext);
                }
                mSyncMIIDHelper.a(sContext);
            }
            catch (Exception exception) {
                com.xiaomi.channel.commonutils.logger.b.d(exception.toString());
            }
            if ("syncing".equals(ap.a(sContext).a(be.a))) {
                MiPushClient.disablePush(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.b))) {
                MiPushClient.enablePush(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.c))) {
                MiPushClient.syncAssemblePushToken(sContext);
            }
            if ("syncing".equals(ap.a(sContext).a(be.d))) {
                MiPushClient.syncAssembleFCMPushToken(sContext);
            }
            if ("syncing".equals(ap.a(context).a(be.e))) {
                MiPushClient.syncAssembleCOSPushToken(context);
            }
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = an.a(sContext).a(com.xiaomi.xmpush.thrift.g.A.a(), 86400);
        h.a(sContext).a(new ao(sContext), n2, 5);
    }

    private static void scheduleGeoFenceLocUploadJobs() {
        if (!j.e(sContext)) {
            return;
        }
        if (TextUtils.equals((CharSequence)"com.xiaomi.xmsf", (CharSequence)sContext.getPackageName())) {
            return;
        }
        if (!an.a(sContext).a(com.xiaomi.xmpush.thrift.g.ac.a(), true)) {
            return;
        }
        if (n.d()) {
            return;
        }
        u.a(sContext, true);
        int n2 = an.a(sContext).a(com.xiaomi.xmpush.thrift.g.O.a(), 900);
        n2 = Math.max(60, n2);
        h.a(sContext).a(new u(sContext, n2), n2, n2);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = com.xiaomi.xmpush.thrift.g.z.a();
        if (an.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            com.xiaomi.push.mpcd.c.a().a(new q(context));
            h.a(sContext).a(new ah(), 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return com.xiaomi.channel.commonutils.android.f.b();
    }

    private static void updateIMEI() {
        new Thread(new ai()).start();
    }

    public static void awakeApps(Context context, String[] stringArray) {
        h.a(context).a(new aj(stringArray, context));
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, com.xiaomi.xmpush.thrift.w w2) {
        if (!d.a(context).j()) {
            return;
        }
        String string = com.xiaomi.channel.commonutils.string.d.a(6);
        String string2 = d.a(context).c();
        String string3 = d.a(context).d();
        d.a(context).i();
        d.a(context).a(Constants.a());
        d.a(context).a(string2, string3, string);
        com.xiaomi.xmpush.thrift.aj aj2 = new com.xiaomi.xmpush.thrift.aj();
        aj2.a(aq.a());
        aj2.b(string2);
        aj2.e(string3);
        aj2.f(string);
        aj2.d(context.getPackageName());
        aj2.c(com.xiaomi.channel.commonutils.android.a.a(context, context.getPackageName()));
        aj2.a(w2);
        az.a(context).a(aj2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        com.xiaomi.xmpush.thrift.u u2 = new com.xiaomi.xmpush.thrift.u();
        u2.a(miPushMessage.getMessageId());
        u2.b(miPushMessage.getTopic());
        u2.d(miPushMessage.getDescription());
        u2.c(miPushMessage.getTitle());
        u2.c(miPushMessage.getNotifyId());
        u2.a(miPushMessage.getNotifyType());
        u2.b(miPushMessage.getPassThrough());
        u2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), u2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, com.xiaomi.xmpush.thrift.u u2, String string2) {
        com.xiaomi.xmpush.thrift.ai ai2 = new com.xiaomi.xmpush.thrift.ai();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!d.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            ai2.b(d.a(context).c());
        } else {
            ai2.b(string2);
        }
        ai2.c("bar:click");
        ai2.a(string);
        ai2.a(false);
        az.a(context).a(ai2, com.xiaomi.xmpush.thrift.a.i, false, u2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, com.xiaomi.xmpush.thrift.u u2, String string2, String string3) {
        com.xiaomi.xmpush.thrift.ai ai2 = new com.xiaomi.xmpush.thrift.ai();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        ai2.b(string3);
        ai2.c("bar:click");
        ai2.a(string);
        ai2.a(false);
        az.a(context).a(ai2, com.xiaomi.xmpush.thrift.a.i, false, true, u2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        az.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        az.a(context).f();
    }

    public static void unregisterPush(Context context) {
        i.d(context);
        if (!d.a(context).b()) {
            return;
        }
        com.xiaomi.xmpush.thrift.ap ap2 = new com.xiaomi.xmpush.thrift.ap();
        ap2.a(aq.a());
        ap2.b(d.a(context).c());
        ap2.c(d.a(context).e());
        ap2.e(d.a(context).d());
        ap2.d(context.getPackageName());
        az.a(context).a(ap2);
        PushMessageHandler.a();
        d.a(context).k();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        if (mSyncMIIDHelper != null) {
            o.a(context).b(mSyncMIIDHelper);
        }
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        az.a(context).a(true);
    }

    public static void enablePush(Context context) {
        az.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        az.a(context).a(null, be.c, f.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        az.a(context).a(null, be.d, f.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        az.a(context).a(null, be.e, f.c);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, com.xiaomi.push.service.xmpush.a.c.k, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, com.xiaomi.push.service.xmpush.a.d.k, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, com.xiaomi.push.service.xmpush.a.e.k, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, com.xiaomi.push.service.xmpush.a.f.k, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)d.a(context).c()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            com.xiaomi.xmpush.thrift.an an2 = new com.xiaomi.xmpush.thrift.an();
            an2.a(aq.a());
            an2.b(d.a(context).c());
            an2.c(string);
            an2.d(context.getPackageName());
            an2.e(string2);
            az.a(context).a(an2, com.xiaomi.xmpush.thrift.a.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(com.xiaomi.push.service.xmpush.a.g.k, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!d.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        ar ar2 = new ar();
        ar2.a(aq.a());
        ar2.b(d.a(context).c());
        ar2.c(string);
        ar2.d(context.getPackageName());
        ar2.e(string2);
        az.a(context).a(ar2, com.xiaomi.xmpush.thrift.a.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        az.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        az.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        az.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!d.a(context).b()) {
            return;
        }
        com.xiaomi.xmpush.thrift.r r2 = bl2 ? com.xiaomi.xmpush.thrift.r.Z : com.xiaomi.xmpush.thrift.r.Y;
        com.xiaomi.xmpush.thrift.ai ai2 = new com.xiaomi.xmpush.thrift.ai();
        ai2.b(d.a(context).c());
        ai2.c(r2.aa);
        ai2.d(context.getPackageName());
        ai2.a(aq.a());
        ai2.a(false);
        az.a(context).a(ai2, com.xiaomi.xmpush.thrift.a.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (d.a(context).j()) {
            return d.a(context).e();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (d.a(context).j()) {
            return d.a(context).h();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (com.xiaomi.push.service.xmpush.a.c.k.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(com.xiaomi.push.service.xmpush.a.c.k, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (com.xiaomi.push.service.xmpush.a.d.k.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + com.xiaomi.channel.commonutils.string.d.a(arrayList.toString(), 3) + " is unseted");
        } else if (com.xiaomi.push.service.xmpush.a.e.k.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(com.xiaomi.push.service.xmpush.a.e.k, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (com.xiaomi.push.service.xmpush.a.f.k.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + com.xiaomi.channel.commonutils.string.d.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)d.a(context).c())) {
            return;
        }
        ad ad2 = new ad();
        ad2.a(aq.a());
        ad2.b(d.a(context).c());
        ad2.c(string);
        for (String string3 : arrayList) {
            ad2.d(string3);
        }
        ad2.f(string2);
        ad2.e(context.getPackageName());
        az.a(context).a(ad2, com.xiaomi.xmpush.thrift.a.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, com.xiaomi.push.service.xmpush.a.i.k, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(com.xiaomi.push.service.xmpush.a.i.k, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, com.xiaomi.push.service.xmpush.a.i.k, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush() {
        return g.a(sContext).d(f.a);
    }

    protected static boolean getOpenFCMPush() {
        return g.a(sContext).d(f.b);
    }

    protected static boolean getOpenOPPOPush() {
        return g.a(sContext).d(f.c);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        l.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        l.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        l.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        l.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    static synchronized void setGeoEnableTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("geo_" + string, System.currentTimeMillis());
        l.a(editor);
    }

    private static long getGeoEnableTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("geo_" + string, -1L);
    }

    private static void enableGeo(Context context, boolean bl2) {
        if (Math.abs(System.currentTimeMillis() - MiPushClient.getGeoEnableTime(context, String.valueOf(bl2))) > 60000L) {
            j.a(context, bl2);
            w.a(context, bl2);
            MiPushClient.setGeoEnableTime(context, String.valueOf(bl2));
        }
    }

    private static void initEventPerfLogic(Context context) {
        c.a(new ak());
        Config config = c.c(context);
        ClientReportClient.init(context, config, new com.xiaomi.push.service.clientReport.a(context), new com.xiaomi.push.service.clientReport.b(context));
        a.a(context);
        r.a(context, config);
    }

    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(new z(sContext, uncaughtExceptionHandler));
        isCrashHandlerSuggested = true;
    }

    private static void forceHandleCrash() {
        boolean bl2 = an.a(sContext).a(com.xiaomi.xmpush.thrift.g.av.a(), false);
        if (!isCrashHandlerSuggested && bl2) {
            Thread.setDefaultUncaughtExceptionHandler(new z(sContext));
        }
    }

    static /* synthetic */ boolean access$000(Context context) {
        return MiPushClient.checkPermission(context);
    }

    static /* synthetic */ Context access$100() {
        return sContext;
    }

    static /* synthetic */ void access$200(Context context, PackageInfo packageInfo) {
        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

