/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.network;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Process;
import android.text.TextUtils;
import com.xiaomi.channel.commonutils.network.d;
import com.xiaomi.network.Fallback;
import com.xiaomi.network.Fallbacks;
import com.xiaomi.network.HostFilter;
import com.xiaomi.network.a;
import com.xiaomi.network.b;
import com.xiaomi.network.c;
import com.xiaomi.push.service.module.PushChannelRegion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostManager {
    protected Map<String, Fallbacks> mHostsMapping = new HashMap<String, Fallbacks>();
    protected static Map<String, Fallback> sReservedHosts = new HashMap<String, Fallback>();
    protected static Context sAppContext;
    private HostFilter sHostFilter;
    protected HttpGet sHttpGetter;
    private String sUserId = "0";
    private long remoteRequestFailureCount = 0L;
    private final long MAX_REQUEST_FAILURE_CNT = 15L;
    private long lastRemoteRequestTimestamp = 0L;
    private String currentISP = "isp_prov_city_country_ip";
    private static HostManager sInstance;
    private static HostManagerFactory factory;
    private static String sAppName;
    private static String sAppVersion;
    protected static boolean hostLoaded;

    public static synchronized HostManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("the host manager is not initialized yet.");
        }
        return sInstance;
    }

    public static synchronized void setHostManagerFactory(HostManagerFactory hostManagerFactory) {
        factory = hostManagerFactory;
        sInstance = null;
    }

    public static synchronized void init(Context context, HostFilter hostFilter, HttpGet httpGet, String string, String string2, String string3) {
        sAppContext = context.getApplicationContext();
        if (sAppContext == null) {
            sAppContext = context;
        }
        if (sInstance == null) {
            sInstance = factory == null ? new HostManager(context, hostFilter, httpGet, string, string2, string3) : factory.a(context, hostFilter, httpGet, string);
        }
    }

    protected HostManager(Context context, HostFilter hostFilter, HttpGet httpGet, String string) {
        this(context, hostFilter, httpGet, string, null, null);
    }

    protected HostManager(Context context, HostFilter hostFilter, HttpGet httpGet, String string, String string2, String string3) {
        this.sHttpGetter = httpGet;
        this.sHostFilter = hostFilter == null ? new a(this) : hostFilter;
        this.sUserId = string;
        sAppName = string2 != null ? string2 : context.getPackageName();
        sAppVersion = string3 != null ? string3 : this.getVersionName();
    }

    static String getActiveNetworkLabel() {
        block7: {
            if (sAppContext == null) {
                return "unknown";
            }
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)sAppContext.getSystemService("connectivity");
                if (connectivityManager == null) {
                    return "unknown";
                }
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo == null) {
                    return "unknown";
                }
                if (networkInfo.getType() == 1) {
                    WifiManager wifiManager = (WifiManager)sAppContext.getSystemService("wifi");
                    if (wifiManager != null && wifiManager.getConnectionInfo() != null) {
                        return "WIFI-" + wifiManager.getConnectionInfo().getSSID();
                    }
                    break block7;
                }
                return networkInfo.getTypeName() + "-" + networkInfo.getSubtypeName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "unknown";
    }

    public Fallback getFallbacksByURL(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("the url is empty");
        }
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        return this.getFallbacksByHost(string2, true);
    }

    public Fallback getFallbacksByHost(String string) {
        return this.getFallbacksByHost(string, true);
    }

    public Fallback getFallbacksByHost(String string, boolean bl2) {
        Fallback fallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("the host is empty");
        }
        if (!this.sHostFilter.a(string)) {
            return null;
        }
        Fallback fallback2 = this.getLocalFallback(string);
        if (fallback2 != null && fallback2.b()) {
            return fallback2;
        }
        if (bl2 && d.c(sAppContext) && (fallback = this.requestRemoteFallback(string)) != null) {
            return fallback;
        }
        fallback = new b(this, string, fallback2);
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Fallback getLocalFallback(String string) {
        Fallbacks fallbacks = null;
        Object object = this.mHostsMapping;
        synchronized (object) {
            this.checkHostMapping();
            fallbacks = this.mHostsMapping.get(string);
        }
        if (fallbacks != null && (object = fallbacks.getFallback()) != null) {
            return object;
        }
        return null;
    }

    protected Fallback requestRemoteFallback(String string) {
        if (System.currentTimeMillis() - this.lastRemoteRequestTimestamp > this.remoteRequestFailureCount * 60L * 1000L) {
            this.lastRemoteRequestTimestamp = System.currentTimeMillis();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            Fallback fallback = this.requestRemoteFallbacks(arrayList).get(0);
            if (fallback != null) {
                this.remoteRequestFailureCount = 0L;
                return fallback;
            }
            if (this.remoteRequestFailureCount < 15L) {
                ++this.remoteRequestFailureCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ArrayList<Fallback> requestRemoteFallbacks(ArrayList<String> arrayList) {
        ArrayList<Fallback> arrayList2;
        block28: {
            void var4_8;
            Object object;
            this.purge();
            Map<String, Fallbacks> map = this.mHostsMapping;
            // MONITORENTER : map
            this.checkHostMapping();
            for (String string : this.mHostsMapping.keySet()) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            // MONITOREXIT : map
            boolean bl2 = sReservedHosts.isEmpty();
            arrayList2 = sReservedHosts;
            // MONITORENTER : arrayList2
            for (Object object2 : sReservedHosts.values().toArray()) {
                object = (Fallback)object2;
                if (((Fallback)object).b()) continue;
                bl2 = true;
                sReservedHosts.remove(((Fallback)object).b);
            }
            // MONITOREXIT : arrayList2
            if (!arrayList.contains(this.getHost())) {
                arrayList.add(this.getHost());
            }
            arrayList2 = new ArrayList<Fallback>(arrayList.size());
            boolean bl3 = false;
            while (var4_8 < arrayList.size()) {
                arrayList2.add(null);
                ++var4_8;
            }
            try {
                String string;
                Object object3;
                Object object2;
                String string2 = d.e(sAppContext) ? "wifi" : "wap";
                String string3 = this.getRemoteFallbackJSON(arrayList, string2, this.sUserId, bl2);
                if (TextUtils.isEmpty((CharSequence)string3)) break block28;
                JSONObject jSONObject = new JSONObject(string3);
                com.xiaomi.channel.commonutils.logger.b.b(string3);
                if (!"OK".equalsIgnoreCase(jSONObject.getString("S"))) break block28;
                object2 = jSONObject.getJSONObject("R");
                object = object2.getString("province");
                String string4 = object2.getString("city");
                String string5 = object2.getString("isp");
                String string6 = object2.getString("ip");
                String string7 = object2.getString("country");
                JSONObject jSONObject2 = object2.getJSONObject(string2);
                String string8 = string2;
                if (string8.equals("wap")) {
                    string8 = HostManager.getActiveNetworkLabel();
                }
                com.xiaomi.channel.commonutils.logger.b.c("get bucket: ip = " + string6 + " net = " + string5 + string8 + " hosts = " + jSONObject2.toString());
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    String string9 = arrayList.get(i2);
                    JSONArray jSONArray = jSONObject2.optJSONArray(string9);
                    if (jSONArray == null) {
                        com.xiaomi.channel.commonutils.logger.b.a("no bucket found for " + string9);
                        continue;
                    }
                    object3 = new Fallback(string9);
                    for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                        string = jSONArray.getString(i3);
                        if (TextUtils.isEmpty((CharSequence)string)) continue;
                        ((Fallback)object3).a(new c(string, jSONArray.length() - i3));
                    }
                    arrayList2.set(i2, (Fallback)object3);
                    ((Fallback)object3).g = string7;
                    ((Fallback)object3).c = object;
                    ((Fallback)object3).e = string5;
                    ((Fallback)object3).f = string6;
                    ((Fallback)object3).d = string4;
                    if (object2.has("stat-percent")) {
                        ((Fallback)object3).a(object2.getDouble("stat-percent"));
                    }
                    if (object2.has("stat-domain")) {
                        ((Fallback)object3).c(object2.getString("stat-domain"));
                    }
                    if (object2.has("ttl")) {
                        ((Fallback)object3).a((long)object2.getInt("ttl") * 1000L);
                    }
                    this.setCurrentISP(((Fallback)object3).e());
                }
                JSONObject jSONObject3 = object2.optJSONObject("reserved");
                if (jSONObject3 != null) {
                    long l2 = 604800000L;
                    if (object2.has("reserved-ttl")) {
                        l2 = (long)object2.getInt("reserved-ttl") * 1000L;
                    }
                    object3 = jSONObject3.keys();
                    while (object3.hasNext()) {
                        String string10 = (String)object3.next();
                        string = jSONObject3.optJSONArray(string10);
                        if (string == null) {
                            com.xiaomi.channel.commonutils.logger.b.a("no bucket found for " + string10);
                            continue;
                        }
                        Fallback fallback = new Fallback(string10);
                        fallback.a(l2);
                        for (int i4 = 0; i4 < string.length(); ++i4) {
                            String string11 = string.getString(i4);
                            if (TextUtils.isEmpty((CharSequence)string11)) continue;
                            fallback.a(new c(string11, string.length() - i4));
                        }
                        Map<String, Fallback> map2 = sReservedHosts;
                        // MONITORENTER : map2
                        if (this.sHostFilter.a(string10)) {
                            sReservedHosts.put(string10, fallback);
                        }
                        // MONITOREXIT : map2
                    }
                }
            }
            catch (Exception exception) {
                com.xiaomi.channel.commonutils.logger.b.a("failed to get bucket " + exception.getMessage());
            }
        }
        boolean bl4 = false;
        while (true) {
            void var4_13;
            if (var4_13 >= arrayList.size()) {
                this.persist();
                return arrayList2;
            }
            Fallback fallback = (Fallback)arrayList2.get((int)var4_13);
            if (fallback != null) {
                this.updateFallbacks(arrayList.get((int)var4_13), fallback);
            }
            ++var4_13;
        }
    }

    protected String getHost() {
        String string = com.xiaomi.push.service.a.a(sAppContext).a();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return PushChannelRegion.Europe.name().equals(string) ? "resolver.msg.global.xiaomi.net" : "resolver.msg.xiaomi.net";
        }
        return "resolver.msg.xiaomi.net";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRemoteFallbackJSON(ArrayList<String> arrayList, String string, String string2, boolean bl2) {
        Object object;
        ArrayList<Object> arrayList2 = new ArrayList<String>();
        ArrayList<com.xiaomi.channel.commonutils.network.a> arrayList3 = new ArrayList<com.xiaomi.channel.commonutils.network.a>();
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("type", string));
        if (string.equals("wap")) {
            arrayList3.add(new com.xiaomi.channel.commonutils.network.a("conpt", HostManager.obfuscate(d.k(sAppContext))));
        }
        if (bl2) {
            arrayList3.add(new com.xiaomi.channel.commonutils.network.a("reserved", "1"));
        }
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("uuid", string2));
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("list", com.xiaomi.channel.commonutils.string.d.a(arrayList, ",")));
        Fallback fallback = this.getLocalFallback(this.getHost());
        String string3 = String.format(Locale.US, "http://%1$s/gslb/?ver=4.0", this.getHost());
        if (fallback == null) {
            arrayList2.add(string3);
            object = sReservedHosts;
            synchronized (object) {
                Fallback fallback2 = sReservedHosts.get("resolver.msg.xiaomi.net");
                if (fallback2 != null) {
                    for (String object2 : fallback2.a(true)) {
                        arrayList2.add(String.format(Locale.US, "http://%1$s/gslb/?ver=4.0", object2));
                    }
                }
            }
        } else {
            arrayList2 = fallback.a(string3);
        }
        object = null;
        for (Object object3 : arrayList2) {
            Uri.Builder builder = Uri.parse((String)object3).buildUpon();
            for (com.xiaomi.channel.commonutils.network.c c2 : arrayList3) {
                builder.appendQueryParameter(c2.a(), c2.b());
            }
            try {
                if (this.sHttpGetter == null) {
                    return d.a(sAppContext, new URL(builder.toString()));
                }
                return this.sHttpGetter.a(builder.toString());
            }
            catch (IOException iOException) {
                object = iOException;
            }
        }
        if (object != null) {
            com.xiaomi.channel.commonutils.logger.b.a("network exception: " + ((Throwable)object).getMessage());
            throw object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            for (Map.Entry<String, Fallbacks> entry : this.mHostsMapping.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(":\n");
                stringBuilder.append(entry.getValue().toString());
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFallbacks(String string, Fallback fallback) {
        if (TextUtils.isEmpty((CharSequence)string) || fallback == null) {
            throw new IllegalArgumentException("the argument is invalid " + string + ", " + fallback);
        }
        if (this.sHostFilter.a(string)) {
            Map<String, Fallbacks> map = this.mHostsMapping;
            synchronized (map) {
                this.checkHostMapping();
                if (this.mHostsMapping.containsKey(string)) {
                    Fallbacks fallbacks = this.mHostsMapping.get(string);
                    fallbacks.addFallback(fallback);
                } else {
                    Fallbacks fallbacks = new Fallbacks(string);
                    fallbacks.addFallback(fallback);
                    this.mHostsMapping.put(string, fallbacks);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFallbacks() {
        int n2;
        ArrayList<String> arrayList = null;
        Object object = this.mHostsMapping;
        synchronized (object) {
            this.checkHostMapping();
            arrayList = new ArrayList<String>(this.mHostsMapping.keySet());
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                Fallbacks fallbacks = this.mHostsMapping.get(arrayList.get(n2));
                if (fallbacks == null || fallbacks.getFallback() == null) continue;
                arrayList.remove(n2);
            }
        }
        object = this.requestRemoteFallbacks(arrayList);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (((ArrayList)object).get(n2) == null) continue;
            this.updateFallbacks(arrayList.get(n2), (Fallback)((ArrayList)object).get(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadHosts() {
        BufferedReader bufferedReader;
        block6: {
            String string;
            bufferedReader = null;
            try {
                File file = new File(sAppContext.getFilesDir(), this.getProcessName());
                if (!file.isFile()) break block6;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    com.xiaomi.channel.commonutils.logger.b.a("load host exception " + throwable.getMessage());
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    com.xiaomi.channel.commonutils.file.b.a(bufferedReader);
                }
            }
            com.xiaomi.channel.commonutils.file.b.a(bufferedReader);
            return string;
        }
        com.xiaomi.channel.commonutils.file.b.a(bufferedReader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkHostMapping() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            if (!hostLoaded) {
                hostLoaded = true;
                this.mHostsMapping.clear();
                try {
                    String string = this.loadHosts();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        this.fromJSON(string);
                        com.xiaomi.channel.commonutils.logger.b.b("loading the new hosts succeed");
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a("load bucket failure: " + throwable.getMessage());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReservedHost(String string, String string2) {
        Fallback fallback = sReservedHosts.get(string);
        Map<String, Fallback> map = sReservedHosts;
        synchronized (map) {
            if (fallback == null) {
                fallback = new Fallback(string);
                fallback.a(604800000L);
                fallback.b(string2);
                sReservedHosts.put(string, fallback);
            } else {
                fallback.b(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            try {
                FileOutputStream fileOutputStream = sAppContext.openFileOutput(this.getProcessName(), 0);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                String string = this.toJSON().toString();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bufferedWriter.write(string);
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                com.xiaomi.channel.commonutils.logger.b.a("persist bucket failure: " + exception.getMessage());
            }
        }
    }

    protected String getProcessName() {
        List list = ((ActivityManager)sAppContext.getSystemService("activity")).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != Process.myPid()) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return "com.xiaomi";
    }

    private String getVersionName() {
        try {
            PackageInfo packageInfo = sAppContext.getPackageManager().getPackageInfo(sAppContext.getPackageName(), 16384);
            if (packageInfo != null) {
                return packageInfo.versionName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            for (Fallbacks object : this.mHostsMapping.values()) {
                object.purge(true);
            }
            boolean bl2 = false;
            block4: while (!bl2) {
                bl2 = true;
                for (String string : this.mHostsMapping.keySet()) {
                    if (!this.mHostsMapping.get(string).getFallbacks().isEmpty()) continue;
                    this.mHostsMapping.remove(string);
                    bl2 = false;
                    continue block4;
                }
            }
        }
    }

    static String obfuscate(String string) {
        try {
            int n2 = string.length();
            byte[] byArray = string.getBytes("UTF-8");
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byte by2 = byArray[i2];
                if ((by2 & 0xF0) == 240) continue;
                byte by3 = (byte)(n2 + (by2 >> 4) & 0xF);
                byArray[i2] = (byte)(by2 & 0xF0 | by2 & 0xF ^ by3);
            }
            return new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void setCurrentISP(String string) {
        this.currentISP = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject toJSON() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ver", 2);
            JSONArray jSONArray = new JSONArray();
            for (Fallbacks object : this.mHostsMapping.values()) {
                jSONArray.put((Object)object.toJSON());
            }
            jSONObject.put("data", (Object)jSONArray);
            JSONArray jSONArray2 = new JSONArray();
            for (Fallback fallback : sReservedHosts.values()) {
                jSONArray2.put((Object)fallback.f());
            }
            jSONObject.put("reserved", (Object)jSONArray2);
            return jSONObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fromJSON(String string) {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("ver");
            if (n2 != 2) {
                throw new JSONException("Bad version");
            }
            JSONArray jSONArray = jSONObject.optJSONArray("data");
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                Fallbacks fallbacks = new Fallbacks().fromJSON(jSONArray.getJSONObject(i2));
                this.mHostsMapping.put(fallbacks.getHost(), fallbacks);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("reserved");
            for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                Fallback fallback = new Fallback("").a(jSONArray2.getJSONObject(i3));
                sReservedHosts.put(fallback.b, fallback);
            }
        }
    }

    static {
        hostLoaded = false;
    }

    public static interface HttpGet {
        public String a(String var1);
    }

    public static interface HostManagerFactory {
        public HostManager a(Context var1, HostFilter var2, HttpGet var3, String var4);
    }
}

