/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import io.rong.common.RLog;
import io.rong.common.SystemUtils;
import io.rong.imlib.NativeClient;
import io.rong.imlib.common.DeviceUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FileUtils {
    private static String TAG = "FileUtils";
    private static Map<String, Boolean> downloadMap = new HashMap<String, Boolean>();

    public static InputStream getFileInputStream(String path) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(path));
        }
        catch (FileNotFoundException e) {
            RLog.e(TAG, "getFileInputStream", e);
        }
        return fileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromUri(Uri uri) {
        InputStream input = FileUtils.getFileInputStream(uri.getPath());
        try {
            int count = 0;
            while (count == 0 && (count = input.available()) != 0) {
            }
            byte[] bytes = new byte[count];
            input.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeByte(Uri uri, byte[] data) {
        File fileFolder = new File(uri.getPath().substring(0, uri.getPath().lastIndexOf("/")));
        fileFolder.mkdirs();
        File file = new File(uri.getPath());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            RLog.e(TAG, "writeByte", e);
        }
    }

    public static File convertBitmap2File(Bitmap bm, String dir, String name) {
        File targetFile;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            RLog.e(TAG, "convertBitmap2File: dir does not exist! -" + dirFile.getAbsolutePath());
            dirFile.mkdirs();
        }
        if ((targetFile = new File(dirFile.getPath() + File.separator + name)).exists()) {
            boolean isDelete = targetFile.delete();
            RLog.e(TAG, "convertBitmap2File targetFile isDelete:" + isDelete);
        }
        File tmpFile = new File(dirFile.getPath() + File.separator + name + ".tmp");
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            RLog.e(TAG, "convertBitmap2File: Exception!", e);
        }
        targetFile = new File(dirFile.getPath() + File.separator + name);
        if (tmpFile.renameTo(targetFile)) {
            return targetFile;
        }
        return tmpFile;
    }

    public static File copyFile(File src, String path, String name) {
        File dest = null;
        if (!src.exists()) {
            RLog.e(TAG, "copyFile: src file does not exist! -" + src.getAbsolutePath());
            return dest;
        }
        dest = new File(path);
        if (!dest.exists()) {
            RLog.d(TAG, "copyFile: dir does not exist!");
            dest.mkdirs();
        }
        dest = new File(path + name);
        try {
            int length;
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            fos.flush();
            fos.close();
            fis.close();
        }
        catch (IOException e) {
            RLog.e(TAG, "copyFile: Exception!", e);
            return dest;
        }
        return dest;
    }

    public static byte[] file2byte(File file) {
        if (!file.exists()) {
            RLog.e(TAG, "file2byte: src file does not exist! -" + file.getAbsolutePath());
            return null;
        }
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e1) {
            RLog.e(TAG, "file2byte: Exception!", e1);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File byte2File(byte[] buf, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                RLog.d(TAG, "byte2File: dir does not exist!");
                dir.mkdirs();
            }
            file = new File(dir.getPath() + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            RLog.e(TAG, "byte2File: Exception!", e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "byte2File: IOException!", e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "byte2File: IOException!", e);
                }
            }
        }
        return file;
    }

    public static String getCachePath(Context context) {
        return FileUtils.getCachePath(context, "");
    }

    private static boolean hasFilePermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static String getCachePath(Context context, String dir) {
        File tarDir;
        File cacheDir;
        boolean sdCardExist = false;
        try {
            sdCardExist = "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Exception e) {
            RLog.e(TAG, "getCachePath", e);
        }
        if (Build.VERSION.SDK_INT >= 19 || FileUtils.hasFilePermission(context)) {
            try {
                cacheDir = context.getExternalCacheDir();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(TAG, "getCachePath ArrayIndexOutOfBoundsException", e);
                cacheDir = null;
            }
        } else {
            cacheDir = context.getCacheDir();
        }
        if (!sdCardExist || cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            cacheDir = context.getCacheDir();
        }
        if ((tarDir = new File(cacheDir.getPath() + File.separator + dir)).exists() && tarDir.isFile()) {
            boolean isDelete = tarDir.delete();
            RLog.e(TAG, "getCachePath isDelete:" + isDelete);
        }
        if (!tarDir.exists()) {
            boolean result = tarDir.mkdir();
            RLog.w(TAG, "getCachePath = " + tarDir.getPath() + ", result = " + result);
            if (!result) {
                if (Build.VERSION.SDK_INT >= 23 && FileUtils.hasFilePermission(context)) {
                    tarDir = new File("/sdcard/cache/" + dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                } else {
                    File filesDir = context.getFilesDir();
                    tarDir = new File(filesDir, dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                }
                RLog.e(TAG, "change path = " + tarDir.getPath() + ", result = " + result);
            }
        }
        return tarDir.getPath();
    }

    public static String getCacheDirsPath(Context context, String dir) {
        File tarDir;
        File cacheDir;
        boolean sdCardExist = false;
        try {
            sdCardExist = "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Exception e) {
            RLog.e(TAG, "getCacheDirsPath ", e);
        }
        if (Build.VERSION.SDK_INT >= 19 || FileUtils.hasFilePermission(context)) {
            try {
                cacheDir = context.getExternalCacheDir();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(TAG, "getCacheDirsPath ArrayIndexOutOfBoundsException", e);
                cacheDir = null;
            }
        } else {
            cacheDir = context.getCacheDir();
        }
        if (!sdCardExist || cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            cacheDir = context.getCacheDir();
        }
        if ((tarDir = new File(cacheDir.getPath() + File.separator + dir)).exists()) {
            if (tarDir.isFile()) {
                boolean isDelete = tarDir.delete();
                RLog.e(TAG, "getCacheDirsPath isDelete:" + isDelete);
            }
        } else {
            tarDir.mkdirs();
        }
        if (!tarDir.exists()) {
            boolean result = tarDir.mkdir();
            RLog.w(TAG, "getCachePath = " + tarDir.getPath() + ", result = " + result);
            if (!result) {
                if (Build.VERSION.SDK_INT >= 23 && FileUtils.hasFilePermission(context)) {
                    tarDir = new File("/sdcard/cache/" + dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                } else {
                    File filesDir = context.getFilesDir();
                    tarDir = new File(filesDir, dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                }
                RLog.e(TAG, "change path = " + tarDir.getPath() + ", result = " + result);
            }
        }
        return tarDir.getPath();
    }

    public static String getTempFilePath(Context context, int messageId) {
        return FileUtils.getTempFilePath(context, messageId + "");
    }

    public static String getTempFilePath(Context context, String id) {
        SharedPreferences sp = context.getSharedPreferences("Statistics", 0);
        String appKey = sp.getString("appKey", "Null");
        String userId = SystemUtils.getCurrentProcessName(context).equals(context.getPackageName()) ? sp.getString("userId", "Null") : NativeClient.getInstance().getCurrentUserId();
        String subDir = "TempFile" + File.separator + appKey + File.separator + userId;
        String path = FileUtils.getCacheDirsPath(context, subDir) + File.separator + id + ".txt";
        return path;
    }

    public static String getInternalCachePath(Context context, String dir) {
        File cacheDir = new File(context.getCacheDir().getPath() + File.separator + dir);
        if (!cacheDir.exists()) {
            boolean result = cacheDir.mkdir();
            RLog.w(TAG, "getInternalCachePath = " + cacheDir.getPath() + ", result = " + result);
        }
        return cacheDir.getPath();
    }

    public static String getMediaDownloadDir(Context context) {
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        String path = "/sdcard";
        if (sdCardExist) {
            File file = Environment.getExternalStorageDirectory();
            path = file.getPath();
        }
        try {
            Resources resources = context.getResources();
            String filePath = resources.getString(resources.getIdentifier("rc_media_message_default_save_path", "string", context.getPackageName()));
            RLog.i(TAG, "getMediaDownloadDir: filePath=" + filePath);
            path = path + filePath;
            File file = new File(path);
            if (!file.exists() && !file.mkdirs()) {
                path = "/sdcard";
            }
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            path = "/sdcard";
        }
        return path;
    }

    public static long getFileSize(File file) {
        long size = 0L;
        try {
            if (file.exists()) {
                FileInputStream fis = null;
                fis = new FileInputStream(file);
                size = fis.available();
                if (fis != null) {
                    fis.close();
                }
            } else {
                RLog.d(TAG, "file doesn't exist");
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "getFileSize", e);
        }
        return size;
    }

    public static void saveFile(String str, String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                File dir = new File(file.getParent());
                dir.mkdirs();
                boolean isCreateNewFile = file.createNewFile();
                RLog.e(TAG, "saveFile isCreateNewFile" + isCreateNewFile);
            }
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(str.getBytes());
            outStream.close();
        }
        catch (Exception e) {
            RLog.e(TAG, "saveFile", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String path) {
        FileInputStream in = null;
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            in = new FileInputStream(path);
            reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            RLog.e(TAG, "getStringFromFile IOException", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "getStringFromFile IOException", e);
                }
            }
        }
        return content.toString();
    }

    public static void removeFile(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                boolean isDelete = file.delete();
                RLog.e(TAG, "removeFile isDelete:" + isDelete);
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "removeFile Exception", e);
        }
    }

    public static String getTempFileMD5(Context context, int messageId) {
        return FileUtils.getTempFileMD5(context, messageId + "");
    }

    public static String getTempFileMD5(Context context, String tag) {
        if (context == null) {
            return null;
        }
        SharedPreferences sp = context.getSharedPreferences("Statistics", 0);
        String appKey = sp.getString("appKey", "Null");
        String userId = SystemUtils.getCurrentProcessName(context).equals(context.getPackageName()) ? sp.getString("userId", "Null") : NativeClient.getInstance().getCurrentUserId();
        String result = DeviceUtils.ShortMD5(appKey, userId, tag);
        return result;
    }
}

